/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.to;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Arrays;
import org.geolatte.common.dataformats.json.to.CrsTo;
import org.geolatte.common.dataformats.json.to.GeometryCollectionTo;
import org.geolatte.common.dataformats.json.to.LineStringTo;
import org.geolatte.common.dataformats.json.to.MultiLineStringTo;
import org.geolatte.common.dataformats.json.to.MultiPointTo;
import org.geolatte.common.dataformats.json.to.MultiPolygonTo;
import org.geolatte.common.dataformats.json.to.NamedCrsPropertyTo;
import org.geolatte.common.dataformats.json.to.PointTo;
import org.geolatte.common.dataformats.json.to.PolygonTo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonIgnoreProperties(value={"valid"})
@JsonSubTypes(value={@JsonSubTypes.Type(value=PointTo.class, name="Point"), @JsonSubTypes.Type(value=MultiPointTo.class, name="MultiPoint"), @JsonSubTypes.Type(value=LineStringTo.class, name="LineString"), @JsonSubTypes.Type(value=MultiLineStringTo.class, name="MultiLineString"), @JsonSubTypes.Type(value=PolygonTo.class, name="Polygon"), @JsonSubTypes.Type(value=MultiPolygonTo.class, name="MultiPolygon"), @JsonSubTypes.Type(value=GeometryCollectionTo.class, name="GeometryCollection")})
public abstract class GeoJsonTo {
    private CrsTo crs;
    private double[] bbox;

    GeoJsonTo() {
    }

    GeoJsonTo(CrsTo crs, double[] bbox) {
        this.crs = crs;
        this.bbox = bbox;
    }

    public abstract boolean isValid();

    public CrsTo getCrs() {
        return this.crs;
    }

    public void setCrs(CrsTo crs) {
        this.crs = crs;
    }

    public double[] getBbox() {
        return this.bbox;
    }

    protected void setBbox(double[] bbox) {
        this.bbox = bbox;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (!o2.getClass().equals(this.getClass())) {
            return false;
        }
        GeoJsonTo geoJsonTo = (GeoJsonTo)o2;
        if (!Arrays.equals(this.bbox, geoJsonTo.bbox)) {
            return false;
        }
        return !(this.crs != null ? !this.crs.equals(geoJsonTo.crs) : geoJsonTo.crs != null);
    }

    public int hashCode() {
        int result = this.crs != null ? this.crs.hashCode() : 0;
        result = 31 * result + (this.bbox != null ? Arrays.hashCode(this.bbox) : 0);
        return result;
    }

    public static CrsTo createCrsTo(String crsName) {
        String nameToUse = crsName == null ? "EPSG:4326" : crsName;
        CrsTo result = new CrsTo();
        NamedCrsPropertyTo property = new NamedCrsPropertyTo();
        property.setName(nameToUse);
        result.setProperties(property);
        return result;
    }

    public static double[] createBoundingBox(double[] coordinates) {
        int maxActualCoords = Math.min(coordinates.length, 3);
        double[] result = new double[maxActualCoords * 2];
        for (int i2 = 0; i2 < maxActualCoords; ++i2) {
            result[i2] = coordinates[i2];
            result[maxActualCoords + i2] = coordinates[i2];
        }
        return result;
    }

    public static double[] createBoundingBox(double[][] input) {
        int i2;
        int maxActualCoords = Math.min(input[0].length, 3);
        double[] result = new double[maxActualCoords * 2];
        for (i2 = 0; i2 < maxActualCoords; ++i2) {
            result[i2] = Double.MAX_VALUE;
        }
        for (i2 = maxActualCoords; i2 < result.length; ++i2) {
            result[i2] = -1.7976931348623157E308;
        }
        for (double[] point : input) {
            for (int i3 = 0; i3 < maxActualCoords; ++i3) {
                result[i3] = Math.min(point[i3], result[i3]);
                result[i3 + maxActualCoords] = Math.max(point[i3], result[i3 + maxActualCoords]);
            }
        }
        return result;
    }

    public static double[] createBoundingBox(double[][][] input) {
        double[] bbox = GeoJsonTo.createBoundingBox(input[0]);
        for (int i2 = 1; i2 < input.length; ++i2) {
            double[] current = GeoJsonTo.createBoundingBox(input[i2]);
            GeoJsonTo.mergeInto(bbox, current);
        }
        return bbox;
    }

    public static double[] createBoundingBox(double[][][][] input) {
        double[] bbox = GeoJsonTo.createBoundingBox(input[0]);
        for (int i2 = 1; i2 < input.length; ++i2) {
            double[] current = GeoJsonTo.createBoundingBox(input[i2]);
            GeoJsonTo.mergeInto(bbox, current);
        }
        return bbox;
    }

    private static void mergeInto(double[] first, double[] second) {
        for (int j2 = 0; j2 < first.length / 2; ++j2) {
            first[j2] = Math.min(first[j2], second[j2]);
            first[j2 + first.length / 2] = Math.max(first[j2 + first.length / 2], second[j2 + first.length / 2]);
        }
    }
}

