/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.geolatte.common.dataformats.json.jackson.GeometrySerializer;
import org.geolatte.common.dataformats.json.jackson.JsonMapper;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;

public class PolygonSerializer
extends GeometrySerializer<Polygon> {
    public PolygonSerializer(JsonMapper containingTransformation) {
        super(containingTransformation);
    }

    @Override
    protected void writeShapeSpecificSerialization(Polygon value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeFieldName("type");
        jgen.writeString("Polygon");
        jgen.writeArrayFieldStart("coordinates");
        JsonSerializer<Object> ser = provider.findValueSerializer(Double.class, null);
        LinearRing exterior = value.getExteriorRing();
        jgen.writeStartArray();
        for (int j2 = 0; j2 < exterior.getNumPoints(); ++j2) {
            Point point = exterior.getPointN(j2);
            jgen.writeStartArray();
            ser.serialize(point.getX(), jgen, provider);
            ser.serialize(point.getY(), jgen, provider);
            jgen.writeEndArray();
        }
        jgen.writeEndArray();
        for (int i2 = 0; i2 < value.getNumInteriorRing(); ++i2) {
            LinearRing ml2 = value.getInteriorRingN(i2);
            jgen.writeStartArray();
            for (int j3 = 0; j3 < ml2.getNumPoints(); ++j3) {
                Point point = ml2.getPointN(j3);
                jgen.writeStartArray();
                ser.serialize(point.getX(), jgen, provider);
                ser.serialize(point.getY(), jgen, provider);
                jgen.writeEndArray();
            }
            jgen.writeEndArray();
        }
        jgen.writeEndArray();
    }
}

