/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.jackson;

import java.io.IOException;
import java.util.Map;
import org.geolatte.common.dataformats.json.jackson.AbstractJsonDeserializer;
import org.geolatte.common.dataformats.json.jackson.JsonMapper;

public abstract class GeoJsonDeserializer<T>
extends AbstractJsonDeserializer<T> {
    private Class<T> deserializerClass;

    public GeoJsonDeserializer(JsonMapper owner, Class<T> clazz) {
        super(owner);
        this.deserializerClass = clazz;
    }

    protected Class<T> getDeserializerClass() {
        return this.deserializerClass;
    }

    protected Integer getSrid() throws IOException {
        Map crsContent = this.getTypedParam("crs", null, Map.class);
        if (crsContent != null) {
            if (crsContent.get("type") == null || !"name".equals(crsContent.get("type"))) {
                throw new IOException("If the crs is specified the type must be specified. Currently, only named crses are supported.");
            }
            Object properties = crsContent.get("properties");
            if (properties == null || !(properties instanceof Map) || !((Map)properties).containsKey("name")) {
                throw new IOException("A crs specification requires a properties value containing a name value.");
            }
            String sridString = ((Map)properties).get("name").toString();
            if (sridString.startsWith("EPSG:")) {
                Integer srid = this.parseDefault(sridString.substring(5), (Integer)null);
                if (srid == null) {
                    throw new IOException("Unable to derive SRID from crs name");
                }
                return srid;
            }
            if (sridString.startsWith("urn:ogc:def:crs:EPSG:")) {
                String[] splits = sridString.split(":");
                if (splits.length != 7) {
                    throw new IOException("Unable to derive SRID from crs name");
                }
                Integer srid = this.parseDefault(splits[6], (Integer)null);
                if (srid == null) {
                    throw new IOException("Unable to derive SRID from crs name");
                }
                return srid;
            }
            throw new IOException("Unable to derive SRID from crs name");
        }
        return null;
    }
}

