/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.cql;

import java.util.Date;
import java.util.HashMap;
import org.geolatte.common.cql.AbstractBuilder;
import org.geolatte.common.cql.node.AAfterExpr;
import org.geolatte.common.cql.node.AAndExpr;
import org.geolatte.common.cql.node.ABeforeExpr;
import org.geolatte.common.cql.node.ACompoundIdAttr;
import org.geolatte.common.cql.node.ADoesNotExistExpr;
import org.geolatte.common.cql.node.ADuringExpr;
import org.geolatte.common.cql.node.AEqExpr;
import org.geolatte.common.cql.node.AExistsExpr;
import org.geolatte.common.cql.node.AFromToTimespanLiteral;
import org.geolatte.common.cql.node.AGeoEqualsExpr;
import org.geolatte.common.cql.node.AGtExpr;
import org.geolatte.common.cql.node.AGteExpr;
import org.geolatte.common.cql.node.AIdAttr;
import org.geolatte.common.cql.node.AIlikeExpr;
import org.geolatte.common.cql.node.ALikeExpr;
import org.geolatte.common.cql.node.ALtExpr;
import org.geolatte.common.cql.node.ALteExpr;
import org.geolatte.common.cql.node.ANeqExpr;
import org.geolatte.common.cql.node.ANotExpr;
import org.geolatte.common.cql.node.ANotIlikeExpr;
import org.geolatte.common.cql.node.ANotLikeExpr;
import org.geolatte.common.cql.node.AOrExpr;
import org.geolatte.common.cql.node.Node;
import org.geolatte.common.cql.node.PAttr;
import org.geolatte.common.cql.node.PTimespanLiteral;
import org.geolatte.common.cql.node.Start;
import org.geolatte.common.expressions.BooleanExpression;
import org.geolatte.common.expressions.ComparableExpression;
import org.geolatte.common.expressions.EmptyBasicTypeSwitch;
import org.geolatte.common.expressions.Expression;
import org.geolatte.common.expressions.Expressions;
import org.geolatte.common.expressions.NumberExpression;
import org.geolatte.common.expressions.StringExpression;
import org.geolatte.common.reflection.EntityClassReader;
import org.geolatte.geom.Geometry;

class FilterExpressionBuilder
extends AbstractBuilder {
    private Expression<Boolean> exp = null;
    private EntityClassReader reader;
    private HashMap<Node, Expression> translatedExpressions = new HashMap();

    public FilterExpressionBuilder(Class clazz) {
        this.reader = EntityClassReader.getClassReaderFor(clazz);
    }

    public FilterExpressionBuilder() {
    }

    public Expression<Boolean> getExp() {
        return this.exp;
    }

    @Override
    public void outStart(Start node) {
        node.getPExpr().apply(this);
        this.exp = this.translatedExpressions.get(node.getPExpr());
    }

    @Override
    public void outAAndExpr(AAndExpr node) {
        this.translatedExpressions.put(node, Expressions.and(this.translatedExpressions.get(node.getLeft()), this.translatedExpressions.get(node.getRight())));
    }

    @Override
    public void outAOrExpr(AOrExpr node) {
        this.translatedExpressions.put(node, Expressions.or(this.translatedExpressions.get(node.getLeft()), this.translatedExpressions.get(node.getRight())));
    }

    @Override
    public void outANotExpr(ANotExpr node) {
        this.translatedExpressions.put(node, Expressions.not(this.translatedExpressions.get(node.getExpr())));
    }

    @Override
    public void outAGtExpr(final AGtExpr node) {
        this.translatedExpressions.get(node.getLeft()).switchOn(new EmptyBasicTypeSwitch(){

            @Override
            public void caseNumber(Expression<Number> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isGreaterThan((NumberExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft()), Expressions.constant(Double.parseDouble(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString()))));
            }

            @Override
            public void caseBoolean(Expression<Boolean> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isGreaterThan((BooleanExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft()), Expressions.constant(Boolean.parseBoolean(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString()))));
            }

            @Override
            public void caseString(Expression<String> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isGreaterThan((StringExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft()), Expressions.constant(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString())));
            }
        });
    }

    @Override
    public void outALtExpr(final ALtExpr node) {
        this.translatedExpressions.get(node.getLeft()).switchOn(new EmptyBasicTypeSwitch(){

            @Override
            public void caseNumber(Expression<Number> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isLessThan((ComparableExpression<Number>)((NumberExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft())), Expressions.constant(Double.parseDouble(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString()))));
            }

            @Override
            public void caseBoolean(Expression<Boolean> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isLessThan((BooleanExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft()), Expressions.constant(Boolean.parseBoolean(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString()))));
            }

            @Override
            public void caseString(Expression<String> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isLessThan((StringExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft()), Expressions.constant(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString())));
            }
        });
    }

    @Override
    public void outAGteExpr(final AGteExpr node) {
        this.translatedExpressions.get(node.getLeft()).switchOn(new EmptyBasicTypeSwitch(){

            @Override
            public void caseNumber(Expression<Number> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isGreaterThanOrEqual((NumberExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft()), Expressions.constant(Double.parseDouble(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString()))));
            }

            @Override
            public void caseBoolean(Expression<Boolean> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isGreaterThanOrEqual((BooleanExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft()), Expressions.constant(Boolean.parseBoolean(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString()))));
            }

            @Override
            public void caseString(Expression<String> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isGreaterThanOrEqual((StringExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft()), Expressions.constant(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString())));
            }
        });
    }

    @Override
    public void outALteExpr(final ALteExpr node) {
        this.translatedExpressions.get(node.getLeft()).switchOn(new EmptyBasicTypeSwitch(){

            @Override
            public void caseNumber(Expression<Number> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isLessThanOrEqual((NumberExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft()), Expressions.constant(Double.parseDouble(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString()))));
            }

            @Override
            public void caseBoolean(Expression<Boolean> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isLessThanOrEqual((BooleanExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft()), (Object)Expressions.constant(Boolean.parseBoolean(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString()))));
            }

            @Override
            public void caseString(Expression<String> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isLessThanOrEqual((StringExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft()), Expressions.constant(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString())));
            }
        });
    }

    @Override
    public void outAEqExpr(final AEqExpr node) {
        this.translatedExpressions.get(node.getLeft()).switchOn(new EmptyBasicTypeSwitch(){

            @Override
            public void caseNumber(Expression<Number> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isEqual((NumberExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft()), Expressions.constant(Double.parseDouble(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString()))));
            }

            @Override
            public void caseBoolean(Expression<Boolean> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isEqual((BooleanExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft()), Expressions.constant(Boolean.parseBoolean(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString()))));
            }

            @Override
            public void caseString(Expression<String> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isEqual((StringExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft()), Expressions.constant(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString())));
            }
        });
    }

    @Override
    public void outANeqExpr(final ANeqExpr node) {
        this.translatedExpressions.get(node.getLeft()).switchOn(new EmptyBasicTypeSwitch(){

            @Override
            public void caseNumber(Expression<Number> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isNotEqual((NumberExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft()), Expressions.constant(Double.parseDouble(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString()))));
            }

            @Override
            public void caseBoolean(Expression<Boolean> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isNotEqual((BooleanExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft()), Expressions.constant(Boolean.parseBoolean(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString()))));
            }

            @Override
            public void caseString(Expression<String> expr) {
                FilterExpressionBuilder.this.translatedExpressions.put(node, Expressions.isNotEqual((StringExpression)FilterExpressionBuilder.this.translatedExpressions.get(node.getLeft()), Expressions.constant(FilterExpressionBuilder.this.getLiteral(node.getRight()).toString())));
            }
        });
    }

    @Override
    public void outALikeExpr(ALikeExpr node) {
        this.translatedExpressions.put(node, Expressions.like((Expression<String>)this.translatedExpressions.get(node.getLeft()), Expressions.constant(this.escapeStringLiteral(this.getLiteral(node.getRight()).toString()))));
    }

    @Override
    public void outANotLikeExpr(ANotLikeExpr node) {
        this.translatedExpressions.put(node, Expressions.notLike((Expression<String>)this.translatedExpressions.get(node.getLeft()), Expressions.constant(this.escapeStringLiteral(this.getLiteral(node.getRight()).toString()))));
    }

    @Override
    public void outAIlikeExpr(AIlikeExpr node) {
        this.translatedExpressions.put(node, Expressions.like((Expression<String>)this.translatedExpressions.get(node.getLeft()), (Expression<String>)Expressions.constant(this.escapeStringLiteral(this.getLiteral(node.getRight()).toString())), true));
    }

    @Override
    public void outANotIlikeExpr(ANotIlikeExpr node) {
        this.translatedExpressions.put(node, Expressions.notLike((Expression<String>)this.translatedExpressions.get(node.getLeft()), (Expression<String>)Expressions.constant(this.escapeStringLiteral(this.getLiteral(node.getRight()).toString())), true));
    }

    @Override
    public void outABeforeExpr(ABeforeExpr node) {
        this.translatedExpressions.put(node, Expressions.isBefore(this.translatedExpressions.get(node.getAttr()), Expressions.constant(FilterExpressionBuilder.parseDate(this.getLiteral(node.getDateTime()).toString()))));
    }

    @Override
    public void outAAfterExpr(AAfterExpr node) {
        this.translatedExpressions.put(node, Expressions.isAfter(this.translatedExpressions.get(node.getAttr()), Expressions.constant(FilterExpressionBuilder.parseDate(this.getLiteral(node.getDateTime()).toString()))));
    }

    @Override
    public void outADuringExpr(ADuringExpr node) {
        PTimespanLiteral timespan = node.getTimeSpan();
        if (timespan instanceof AFromToTimespanLiteral) {
            AFromToTimespanLiteral fromToTimespan = (AFromToTimespanLiteral)timespan;
            Date lowDate = FilterExpressionBuilder.parseDate(fromToTimespan.getFrom().getText().trim());
            Date highDate = FilterExpressionBuilder.parseDate(fromToTimespan.getTo().getText().trim());
            this.translatedExpressions.put(node, Expressions.isBetween((ComparableExpression)this.translatedExpressions.get(node.getAttr()), Expressions.constant(lowDate), Expressions.constant(highDate)));
        }
    }

    @Override
    public void outAExistsExpr(AExistsExpr node) {
        PAttr attribute = node.getAttr();
        this.translatedExpressions.put(node, Expressions.exists(this.getPropertyPath(attribute)));
    }

    @Override
    public void outADoesNotExistExpr(ADoesNotExistExpr node) {
        PAttr attribute = node.getAttr();
        this.translatedExpressions.put(node, Expressions.doesNotExist(this.getPropertyPath(attribute)));
    }

    @Override
    public void outAGeoEqualsExpr(AGeoEqualsExpr node) {
        this.translatedExpressions.put(node, Expressions.geoEquals(this.translatedExpressions.get(node.getLeft()), Expressions.constant((Geometry)this.getLiteral(node.getRight()))));
    }

    @Override
    public void outACompoundIdAttr(ACompoundIdAttr node) {
        this.outPAttr(node);
    }

    @Override
    public void caseAIdAttr(AIdAttr node) {
        this.outPAttr(node);
    }

    private void outPAttr(PAttr node) {
        if (node.parent() == null || node.parent() instanceof ACompoundIdAttr) {
            return;
        }
        String attributeName = this.getPropertyPath(node);
        Class attributeType = this.reader.getPropertyType(attributeName);
        if (Number.class.isAssignableFrom(attributeType) || Integer.TYPE.isAssignableFrom(attributeType) || Long.TYPE.isAssignableFrom(attributeType) || Short.TYPE.isAssignableFrom(attributeType) || Float.TYPE.isAssignableFrom(attributeType) || Double.TYPE.isAssignableFrom(attributeType) || Byte.TYPE.isAssignableFrom(attributeType)) {
            this.translatedExpressions.put(node, Expressions.numberProperty(attributeName));
        } else if (String.class.isAssignableFrom(attributeType)) {
            this.translatedExpressions.put(node, Expressions.stringProperty(attributeName));
        } else if (Boolean.class.isAssignableFrom(attributeType)) {
            this.translatedExpressions.put(node, Expressions.booleanProperty(attributeName));
        } else if (Date.class.isAssignableFrom(attributeType)) {
            this.translatedExpressions.put(node, Expressions.dateProperty(attributeName));
        } else if (Geometry.class.isAssignableFrom(attributeType)) {
            this.translatedExpressions.put(node, Expressions.geometryProperty(attributeName));
        }
    }

    private String escapeStringLiteral(String string) {
        return string.replace("''", "'");
    }
}

