/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SimpleLogFormatter
extends Formatter {
    private static final String LS = System.getProperty("line.separator");

    @Override
    public String format(LogRecord r2) {
        StringBuffer sb = new StringBuffer();
        sb.append(r2.getLevel().getName()).append("\t");
        sb.append(String.valueOf(MessageFormat.format("{0, date, yy-MM-dd} {0, time, kk:mm:ss.SSSS} ", new Date(r2.getMillis()))) + "\t");
        String cnm = r2.getSourceClassName();
        String cn2 = "";
        if (cnm != null) {
            int cnl = cnm.length();
            if (cnl > 20) {
                cn2 = r2.getSourceClassName().substring(cnl - 19);
            } else {
                char[] sp = new char[]{' '};
                StringBuffer sb1 = new StringBuffer().append(cnm);
                cn2 = sb1.append(sp, 0, 1).toString();
            }
        }
        sb.append(cn2).append("\t").append(" ");
        sb.append(SimpleLogFormatter.left(r2.getSourceMethodName(), 23, ' ')).append("\t");
        sb.append(r2.getThreadID()).append("\t");
        sb.append(this.formatMessage(r2)).append(LS);
        if (r2.getThrown() != null) {
            sb.append("Throwable occurred: ");
            Throwable t2 = r2.getThrown();
            PrintWriter pw2 = null;
            try {
                StringWriter sw = new StringWriter();
                pw2 = new PrintWriter(sw);
                t2.printStackTrace(pw2);
                sb.append(sw.toString());
            }
            finally {
                if (pw2 != null) {
                    try {
                        pw2.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return sb.toString();
    }

    public static String left(String s2, int width, char fillChar) {
        if (s2.length() >= width) {
            return s2;
        }
        StringBuffer sb = new StringBuffer(width);
        sb.append(s2);
        int i2 = width - s2.length();
        while (--i2 >= 0) {
            sb.append(fillChar);
        }
        return sb.toString();
    }
}

