/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.paho.client.mqttv3.BufferedMessage;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsCallback;
import org.eclipse.paho.client.mqttv3.internal.CommsReceiver;
import org.eclipse.paho.client.mqttv3.internal.CommsSender;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.DisconnectedMessageBuffer;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.HighResolutionTimer;
import org.eclipse.paho.client.mqttv3.internal.IDiscardedBufferMessageCallback;
import org.eclipse.paho.client.mqttv3.internal.IDisconnectedBufferCallback;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class ClientComms {
    public static String VERSION = "${project.version}";
    public static String BUILD_LEVEL = "L${build.level}";
    private final String CLASS_NAME = ClientComms.class.getName();
    private final Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", this.CLASS_NAME);
    private static final byte CONNECTED = 0;
    private static final byte CONNECTING = 1;
    private static final byte DISCONNECTING = 2;
    private static final byte DISCONNECTED = 3;
    private static final byte CLOSED = 4;
    private IMqttAsyncClient client;
    private int networkModuleIndex;
    private NetworkModule[] networkModules;
    private CommsReceiver receiver;
    private CommsSender sender;
    private CommsCallback callback;
    private ClientState clientState;
    private MqttConnectOptions conOptions;
    private MqttClientPersistence persistence;
    private MqttPingSender pingSender;
    private CommsTokenStore tokenStore;
    private boolean stoppingComms = false;
    private byte conState = (byte)3;
    private final Object conLock = new Object();
    private boolean closePending = false;
    private boolean resting = false;
    private DisconnectedMessageBuffer disconnectedMessageBuffer;
    private ExecutorService executorService;

    public ClientComms(IMqttAsyncClient client, MqttClientPersistence persistence, MqttPingSender pingSender, ExecutorService executorService, HighResolutionTimer highResolutionTimer) throws MqttException {
        this.conState = (byte)3;
        this.client = client;
        this.persistence = persistence;
        this.pingSender = pingSender;
        this.pingSender.init(this);
        this.executorService = executorService;
        this.tokenStore = new CommsTokenStore(this.getClient().getClientId());
        this.callback = new CommsCallback(this);
        this.clientState = new ClientState(persistence, this.tokenStore, this.callback, this, pingSender, highResolutionTimer);
        this.callback.setClientState(this.clientState);
        this.log.setResourceName(this.getClient().getClientId());
    }

    CommsReceiver getReceiver() {
        return this.receiver;
    }

    private void shutdownExecutorService() {
        String methodName = "shutdownExecutorService";
        this.executorService.shutdown();
        try {
            if (this.executorService != null && this.conOptions != null && !this.executorService.awaitTermination(this.conOptions.getExecutorServiceTimeout(), TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(this.conOptions.getExecutorServiceTimeout(), TimeUnit.SECONDS)) {
                    this.log.fine(this.CLASS_NAME, methodName, "executorService did not terminate");
                }
            }
        }
        catch (InterruptedException ie2) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    void internalSend(MqttWireMessage message, MqttToken token) throws MqttException {
        String methodName = "internalSend";
        this.log.fine(this.CLASS_NAME, "internalSend", "200", new Object[]{message.getKey(), message, token});
        if (token.getClient() != null) {
            this.log.fine(this.CLASS_NAME, "internalSend", "213", new Object[]{message.getKey(), message, token});
            throw new MqttException(32201);
        }
        token.internalTok.setClient(this.getClient());
        try {
            this.clientState.send(message, token);
        }
        catch (MqttException e2) {
            token.internalTok.setClient(null);
            if (message instanceof MqttPublish) {
                this.clientState.undo((MqttPublish)message);
            }
            throw e2;
        }
    }

    public void sendNoWait(MqttWireMessage message, MqttToken token) throws MqttException {
        String methodName = "sendNoWait";
        if (this.isConnected() || !this.isConnected() && message instanceof MqttConnect || this.isDisconnecting() && message instanceof MqttDisconnect) {
            if (this.disconnectedMessageBuffer != null && this.disconnectedMessageBuffer.getMessageCount() != 0) {
                this.log.fine(this.CLASS_NAME, "sendNoWait", "507", new Object[]{message.getKey()});
                if (this.disconnectedMessageBuffer.isPersistBuffer()) {
                    this.clientState.persistBufferedMessage(message);
                }
                this.disconnectedMessageBuffer.putMessage(message, token);
            } else {
                this.internalSend(message, token);
            }
        } else if (this.disconnectedMessageBuffer != null) {
            this.log.fine(this.CLASS_NAME, "sendNoWait", "508", new Object[]{message.getKey()});
            if (this.disconnectedMessageBuffer.isPersistBuffer()) {
                this.clientState.persistBufferedMessage(message);
            }
            this.disconnectedMessageBuffer.putMessage(message, token);
        } else {
            this.log.fine(this.CLASS_NAME, "sendNoWait", "208");
            throw ExceptionHelper.createMqttException(32104);
        }
    }

    public boolean removeMessage(IMqttDeliveryToken token) throws MqttException {
        return this.clientState.removeMessage(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean force) throws MqttException {
        String methodName = "close";
        Object object = this.conLock;
        synchronized (object) {
            if (!this.isClosed()) {
                if (!this.isDisconnected() || force) {
                    this.log.fine(this.CLASS_NAME, "close", "224");
                    if (this.isConnecting()) {
                        throw new MqttException(32110);
                    }
                    if (this.isConnected()) {
                        throw ExceptionHelper.createMqttException(32100);
                    }
                    if (this.isDisconnecting()) {
                        this.closePending = true;
                        return;
                    }
                }
                this.conState = (byte)4;
                this.clientState.close();
                this.clientState = null;
                this.callback = null;
                this.persistence = null;
                this.sender = null;
                this.pingSender = null;
                this.receiver = null;
                this.networkModules = null;
                this.conOptions = null;
                this.tokenStore = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(MqttConnectOptions options, MqttToken token) throws MqttException {
        String methodName = "connect";
        Object object = this.conLock;
        synchronized (object) {
            if (!this.isDisconnected() || this.closePending) {
                this.log.fine(this.CLASS_NAME, "connect", "207", new Object[]{this.conState});
                if (this.isClosed() || this.closePending) {
                    throw new MqttException(32111);
                }
                if (this.isConnecting()) {
                    throw new MqttException(32110);
                }
                if (this.isDisconnecting()) {
                    throw new MqttException(32102);
                }
                throw ExceptionHelper.createMqttException(32100);
            }
            this.log.fine(this.CLASS_NAME, "connect", "214");
            this.conState = 1;
            this.conOptions = options;
            MqttConnect connect = new MqttConnect(this.client.getClientId(), this.conOptions.getMqttVersion(), this.conOptions.isCleanSession(), this.conOptions.getKeepAliveInterval(), this.conOptions.getUserName(), this.conOptions.getPassword(), this.conOptions.getWillMessage(), this.conOptions.getWillDestination());
            this.clientState.setKeepAliveSecs(this.conOptions.getKeepAliveInterval());
            this.clientState.setCleanSession(this.conOptions.isCleanSession());
            this.clientState.setMaxInflight(this.conOptions.getMaxInflight());
            this.tokenStore.open();
            ConnectBG conbg = new ConnectBG(this, token, connect, this.executorService);
            conbg.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectComplete(MqttConnack cack, MqttException mex) throws MqttException {
        String methodName = "connectComplete";
        int rc = cack.getReturnCode();
        Object object = this.conLock;
        synchronized (object) {
            if (rc == 0) {
                this.log.fine(this.CLASS_NAME, "connectComplete", "215");
                this.conState = 0;
                return;
            }
        }
        this.log.fine(this.CLASS_NAME, "connectComplete", "204", new Object[]{rc});
        throw mex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownConnection(MqttToken token, MqttException reason) {
        boolean wasConnected;
        String methodName = "shutdownConnection";
        MqttToken endToken = null;
        Object object = this.conLock;
        synchronized (object) {
            if (this.stoppingComms || this.closePending || this.isClosed()) {
                return;
            }
            this.stoppingComms = true;
            this.log.fine(this.CLASS_NAME, "shutdownConnection", "216");
            wasConnected = this.isConnected() || this.isDisconnecting();
            this.conState = (byte)2;
        }
        if (token != null && !token.isComplete()) {
            token.internalTok.setException(reason);
        }
        if (this.callback != null) {
            this.callback.stop();
        }
        if (this.receiver != null) {
            this.receiver.stop();
        }
        try {
            NetworkModule networkModule;
            if (this.networkModules != null && (networkModule = this.networkModules[this.networkModuleIndex]) != null) {
                networkModule.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tokenStore.quiesce(new MqttException(32102));
        endToken = this.handleOldTokens(token, reason);
        try {
            this.clientState.disconnected(reason);
            if (this.clientState.getCleanSession()) {
                this.callback.removeMessageListeners();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.sender != null) {
            this.sender.stop();
        }
        if (this.pingSender != null) {
            this.pingSender.stop();
        }
        try {
            if (this.disconnectedMessageBuffer == null && this.persistence != null) {
                this.persistence.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.conLock;
        synchronized (object) {
            this.log.fine(this.CLASS_NAME, "shutdownConnection", "217");
            this.conState = (byte)3;
            this.stoppingComms = false;
        }
        if (endToken != null && this.callback != null) {
            this.callback.asyncOperationComplete(endToken);
        }
        if (wasConnected && this.callback != null) {
            this.callback.connectionLost(reason);
        }
        object = this.conLock;
        synchronized (object) {
            if (this.closePending) {
                try {
                    this.close(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private MqttToken handleOldTokens(MqttToken token, MqttException reason) {
        String methodName = "handleOldTokens";
        this.log.fine(this.CLASS_NAME, "handleOldTokens", "222");
        MqttToken tokToNotifyLater = null;
        try {
            if (token != null && !token.isComplete() && this.tokenStore.getToken(token.internalTok.getKey()) == null) {
                this.tokenStore.saveToken(token, token.internalTok.getKey());
            }
            Vector toksToNot = this.clientState.resolveOldTokens(reason);
            Enumeration toksToNotE = toksToNot.elements();
            while (toksToNotE.hasMoreElements()) {
                MqttToken tok = (MqttToken)toksToNotE.nextElement();
                if (tok.internalTok.getKey().equals("Disc") || tok.internalTok.getKey().equals("Con")) {
                    tokToNotifyLater = tok;
                    continue;
                }
                this.callback.asyncOperationComplete(tok);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tokToNotifyLater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(MqttDisconnect disconnect, long quiesceTimeout, MqttToken token) throws MqttException {
        String methodName = "disconnect";
        Object object = this.conLock;
        synchronized (object) {
            if (this.isClosed()) {
                this.log.fine(this.CLASS_NAME, "disconnect", "223");
                throw ExceptionHelper.createMqttException(32111);
            }
            if (this.isDisconnected()) {
                this.log.fine(this.CLASS_NAME, "disconnect", "211");
                throw ExceptionHelper.createMqttException(32101);
            }
            if (this.isDisconnecting()) {
                this.log.fine(this.CLASS_NAME, "disconnect", "219");
                throw ExceptionHelper.createMqttException(32102);
            }
            if (Thread.currentThread() == this.callback.getThread()) {
                this.log.fine(this.CLASS_NAME, "disconnect", "210");
                throw ExceptionHelper.createMqttException(32107);
            }
            this.log.fine(this.CLASS_NAME, "disconnect", "218");
            this.conState = (byte)2;
            DisconnectBG discbg = new DisconnectBG(disconnect, quiesceTimeout, token, this.executorService);
            discbg.start();
        }
    }

    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws MqttException {
        this.disconnectForcibly(quiesceTimeout, disconnectTimeout, true);
    }

    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout, boolean sendDisconnectPacket) throws MqttException {
        this.conState = (byte)2;
        if (this.clientState != null) {
            this.clientState.quiesce(quiesceTimeout);
        }
        MqttToken token = new MqttToken(this.client.getClientId());
        try {
            try {
                if (sendDisconnectPacket) {
                    this.internalSend(new MqttDisconnect(), token);
                    token.waitForCompletion(disconnectTimeout);
                }
            }
            catch (Exception exception) {
                token.internalTok.markComplete(null, null);
                this.shutdownConnection(token, null);
            }
        }
        finally {
            token.internalTok.markComplete(null, null);
            this.shutdownConnection(token, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisconnected() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisconnecting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.resting;
        }
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.callback.setCallback(mqttCallback);
    }

    public void setReconnectCallback(MqttCallbackExtended callback) {
        this.callback.setReconnectCallback(callback);
    }

    public void setManualAcks(boolean manualAcks) {
        this.callback.setManualAcks(manualAcks);
    }

    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        this.callback.messageArrivedComplete(messageId, qos);
    }

    public void setMessageListener(String topicFilter, IMqttMessageListener messageListener) {
        this.callback.setMessageListener(topicFilter, messageListener);
    }

    public void removeMessageListener(String topicFilter) {
        this.callback.removeMessageListener(topicFilter);
    }

    protected MqttTopic getTopic(String topic) {
        return new MqttTopic(topic, this);
    }

    public void setNetworkModuleIndex(int index) {
        this.networkModuleIndex = index;
    }

    public int getNetworkModuleIndex() {
        return this.networkModuleIndex;
    }

    public NetworkModule[] getNetworkModules() {
        return this.networkModules;
    }

    public void setNetworkModules(NetworkModule[] networkModules) {
        this.networkModules = (NetworkModule[])networkModules.clone();
    }

    public MqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.tokenStore.getOutstandingDelTokens();
    }

    protected void deliveryComplete(MqttPublish msg) throws MqttPersistenceException {
        this.clientState.deliveryComplete(msg);
    }

    protected void deliveryComplete(int messageId) throws MqttPersistenceException {
        this.clientState.deliveryComplete(messageId);
    }

    public IMqttAsyncClient getClient() {
        return this.client;
    }

    public long getKeepAlive() {
        return this.clientState.getKeepAlive();
    }

    public ClientState getClientState() {
        return this.clientState;
    }

    public MqttConnectOptions getConOptions() {
        return this.conOptions;
    }

    public Properties getDebug() {
        Properties props = new Properties();
        props.put("conState", (Object)this.conState);
        props.put("serverURI", this.getClient().getServerURI());
        props.put("callback", this.callback);
        props.put("stoppingComms", (Object)this.stoppingComms);
        return props;
    }

    public MqttToken checkForActivity() {
        return this.checkForActivity(null);
    }

    public MqttToken checkForActivity(IMqttActionListener pingCallback) {
        MqttToken token = null;
        try {
            token = this.clientState.checkForActivity(pingCallback);
        }
        catch (MqttException e2) {
            this.handleRunException(e2);
        }
        catch (Exception e3) {
            this.handleRunException(e3);
        }
        return token;
    }

    private void handleRunException(Exception ex2) {
        String methodName = "handleRunException";
        this.log.fine(this.CLASS_NAME, "handleRunException", "804", null, ex2);
        MqttException mex = !(ex2 instanceof MqttException) ? new MqttException(32109, (Throwable)ex2) : (MqttException)ex2;
        this.shutdownConnection(null, mex);
    }

    public void setRestingState(boolean resting) {
        this.resting = resting;
    }

    public void setDisconnectedMessageBuffer(DisconnectedMessageBuffer disconnectedMessageBuffer) {
        this.disconnectedMessageBuffer = disconnectedMessageBuffer;
    }

    public int getBufferedMessageCount() {
        return this.disconnectedMessageBuffer.getMessageCount();
    }

    public MqttMessage getBufferedMessage(int bufferIndex) {
        MqttPublish send = (MqttPublish)this.disconnectedMessageBuffer.getMessage(bufferIndex).getMessage();
        return send.getMessage();
    }

    public void deleteBufferedMessage(int bufferIndex) {
        this.disconnectedMessageBuffer.deleteMessage(bufferIndex);
    }

    public void notifyConnect() {
        String methodName = "notifyConnect";
        if (this.disconnectedMessageBuffer != null) {
            this.log.fine(this.CLASS_NAME, "notifyConnect", "509", null);
            this.disconnectedMessageBuffer.setPublishCallback(new ReconnectDisconnectedBufferCallback("notifyConnect"));
            this.disconnectedMessageBuffer.setMessageDiscardedCallBack(new MessageDiscardedCallback());
            if (this.executorService == null) {
                new Thread(this.disconnectedMessageBuffer).start();
            } else {
                this.executorService.execute(this.disconnectedMessageBuffer);
            }
        }
    }

    public int getActualInFlight() {
        return this.clientState.getActualInFlight();
    }

    private class ConnectBG
    implements Runnable {
        ClientComms clientComms = null;
        MqttToken conToken;
        MqttConnect conPacket;
        private String threadName;

        ConnectBG(ClientComms cc2, MqttToken cToken, MqttConnect cPacket, ExecutorService executorService) {
            this.clientComms = cc2;
            this.conToken = cToken;
            this.conPacket = cPacket;
            this.threadName = "MQTT Con: " + ClientComms.this.getClient().getClientId();
        }

        void start() {
            if (ClientComms.this.executorService == null) {
                new Thread(this).start();
            } else {
                ClientComms.this.executorService.execute(this);
            }
        }

        @Override
        public void run() {
            Thread.currentThread().setName(this.threadName);
            String methodName = "connectBG:run";
            MqttException mqttEx = null;
            ClientComms.this.log.fine(ClientComms.this.CLASS_NAME, "connectBG:run", "220");
            try {
                MqttDeliveryToken[] toks;
                MqttDeliveryToken[] mqttDeliveryTokenArray = toks = ClientComms.this.tokenStore.getOutstandingDelTokens();
                int n2 = toks.length;
                int n3 = 0;
                while (n3 < n2) {
                    MqttDeliveryToken tok = mqttDeliveryTokenArray[n3];
                    tok.internalTok.setException(null);
                    ++n3;
                }
                ClientComms.this.tokenStore.saveToken(this.conToken, this.conPacket);
                NetworkModule networkModule = ClientComms.this.networkModules[ClientComms.this.networkModuleIndex];
                networkModule.start();
                ClientComms.this.receiver = new CommsReceiver(this.clientComms, ClientComms.this.clientState, ClientComms.this.tokenStore, networkModule.getInputStream());
                ClientComms.this.receiver.start("MQTT Rec: " + ClientComms.this.getClient().getClientId(), ClientComms.this.executorService);
                ClientComms.this.sender = new CommsSender(this.clientComms, ClientComms.this.clientState, ClientComms.this.tokenStore, networkModule.getOutputStream());
                ClientComms.this.sender.start("MQTT Snd: " + ClientComms.this.getClient().getClientId(), ClientComms.this.executorService);
                ClientComms.this.callback.start("MQTT Call: " + ClientComms.this.getClient().getClientId(), ClientComms.this.executorService);
                ClientComms.this.internalSend(this.conPacket, this.conToken);
            }
            catch (MqttException ex2) {
                ClientComms.this.log.fine(ClientComms.this.CLASS_NAME, "connectBG:run", "212", null, ex2);
                mqttEx = ex2;
            }
            catch (Exception ex3) {
                ClientComms.this.log.fine(ClientComms.this.CLASS_NAME, "connectBG:run", "209", null, ex3);
                mqttEx = ExceptionHelper.createMqttException(ex3);
            }
            if (mqttEx != null) {
                ClientComms.this.shutdownConnection(this.conToken, mqttEx);
            }
        }
    }

    private class DisconnectBG
    implements Runnable {
        MqttDisconnect disconnect;
        long quiesceTimeout;
        MqttToken token;
        private String threadName;

        DisconnectBG(MqttDisconnect disconnect, long quiesceTimeout, MqttToken token, ExecutorService executorService) {
            this.disconnect = disconnect;
            this.quiesceTimeout = quiesceTimeout;
            this.token = token;
        }

        void start() {
            this.threadName = "MQTT Disc: " + ClientComms.this.getClient().getClientId();
            if (ClientComms.this.executorService == null) {
                new Thread(this).start();
            } else {
                ClientComms.this.executorService.execute(this);
            }
        }

        @Override
        public void run() {
            Thread.currentThread().setName(this.threadName);
            String methodName = "disconnectBG:run";
            ClientComms.this.log.fine(ClientComms.this.CLASS_NAME, "disconnectBG:run", "221");
            ClientComms.this.clientState.quiesce(this.quiesceTimeout);
            try {
                try {
                    ClientComms.this.internalSend(this.disconnect, this.token);
                    if (ClientComms.this.sender != null && ClientComms.this.sender.isRunning()) {
                        this.token.internalTok.waitUntilSent();
                    }
                }
                catch (MqttException mqttException) {
                    this.token.internalTok.markComplete(null, null);
                    if (ClientComms.this.sender == null || !ClientComms.this.sender.isRunning()) {
                        this.token.internalTok.notifyComplete();
                    }
                    ClientComms.this.shutdownConnection(this.token, null);
                }
            }
            finally {
                this.token.internalTok.markComplete(null, null);
                if (ClientComms.this.sender == null || !ClientComms.this.sender.isRunning()) {
                    this.token.internalTok.notifyComplete();
                }
                ClientComms.this.shutdownConnection(this.token, null);
            }
        }
    }

    class MessageDiscardedCallback
    implements IDiscardedBufferMessageCallback {
        MessageDiscardedCallback() {
        }

        @Override
        public void messageDiscarded(MqttWireMessage message) {
            if (ClientComms.this.disconnectedMessageBuffer.isPersistBuffer()) {
                ClientComms.this.clientState.unPersistBufferedMessage(message);
            }
        }
    }

    class ReconnectDisconnectedBufferCallback
    implements IDisconnectedBufferCallback {
        final String methodName;

        ReconnectDisconnectedBufferCallback(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public void publishBufferedMessage(BufferedMessage bufferedMessage) throws MqttException {
            if (ClientComms.this.isConnected()) {
                while (ClientComms.this.clientState.getActualInFlight() >= ClientComms.this.clientState.getMaxInFlight() - 3) {
                    Thread.yield();
                }
            } else {
                ClientComms.this.log.fine(ClientComms.this.CLASS_NAME, this.methodName, "208");
                throw ExceptionHelper.createMqttException(32104);
            }
            ClientComms.this.log.fine(ClientComms.this.CLASS_NAME, this.methodName, "510", new Object[]{bufferedMessage.getMessage().getKey()});
            ClientComms.this.internalSend(bufferedMessage.getMessage(), bufferedMessage.getToken());
            ClientComms.this.clientState.unPersistBufferedMessage(bufferedMessage.getMessage());
        }
    }
}

