/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.Moment;
import net.time4j.PlainTimestamp;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.engine.EpochDays;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZonalTransition;
import net.time4j.tz.model.DaylightSavingRule;
import net.time4j.tz.model.OffsetIndicator;
import net.time4j.tz.model.RuleComparator;
import net.time4j.tz.model.SPX;
import net.time4j.tz.model.TransitionModel;

final class RuleBasedTransitionModel
extends TransitionModel {
    private static final int LAST_CACHED_YEAR;
    private static final long serialVersionUID = 2456700806862862287L;
    private final transient ZonalTransition initial;
    private final transient List<DaylightSavingRule> rules;
    private final transient ConcurrentMap<Integer, List<ZonalTransition>> tCache = new ConcurrentHashMap<Integer, List<ZonalTransition>>();
    private final transient List<ZonalTransition> stdTransitions;
    private final transient boolean gregorian;

    RuleBasedTransitionModel(ZonalOffset zonalOffset, List<DaylightSavingRule> list) {
        this(zonalOffset, list, true);
    }

    RuleBasedTransitionModel(ZonalOffset zonalOffset, List<DaylightSavingRule> list, boolean bl2) {
        this(new ZonalTransition(Long.MIN_VALUE, zonalOffset.getIntegralAmount(), zonalOffset.getIntegralAmount(), 0), list, bl2);
    }

    RuleBasedTransitionModel(ZonalTransition zonalTransition, List<DaylightSavingRule> list, boolean bl2) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Missing daylight saving rules.");
        }
        if (list.size() >= 128) {
            throw new IllegalArgumentException("Too many daylight saving rules: " + list);
        }
        if (bl2) {
            list = new ArrayList<DaylightSavingRule>(list);
        }
        List<DaylightSavingRule> list2 = list;
        list2.sort(RuleComparator.INSTANCE);
        String string = null;
        if (list2.size() > 1) {
            for (DaylightSavingRule object2 : list2) {
                if (string == null) {
                    string = object2.getCalendarType();
                    continue;
                }
                if (string.equals(object2.getCalendarType())) continue;
                throw new IllegalArgumentException("Rules with different calendar systems not permitted.");
            }
        }
        this.gregorian = "iso8601".equals(string);
        Object object = zonalTransition;
        if (zonalTransition.getPosixTime() == Long.MIN_VALUE) {
            if (zonalTransition.getExtraOffset() != 0) {
                throw new IllegalArgumentException("Initial transition must not have any dst-offset: " + zonalTransition);
            }
            object = new ZonalTransition(((Moment)Moment.axis().getMinimum()).getPosixTime(), zonalTransition.getRawOffset(), zonalTransition.getRawOffset(), 0);
        } else {
            ZonalTransition l2 = RuleBasedTransitionModel.getNextTransition(zonalTransition.getPosixTime(), zonalTransition, list2);
            if (zonalTransition.getTotalOffset() != l2.getPreviousOffset()) {
                throw new IllegalArgumentException("Inconsistent model: " + zonalTransition + " / " + list);
            }
        }
        this.initial = object;
        this.rules = Collections.unmodifiableList(list2);
        long l2 = TransitionModel.getFutureMoment(1);
        this.stdTransitions = RuleBasedTransitionModel.getTransitions(this.initial, this.rules, 0L, l2);
    }

    @Override
    public ZonalOffset getInitialOffset() {
        return ZonalOffset.ofTotalSeconds(this.initial.getTotalOffset());
    }

    @Override
    public ZonalTransition getStartTransition(UnixTime unixTime) {
        long l2 = this.initial.getPosixTime();
        if (unixTime.getPosixTime() <= l2) {
            return null;
        }
        ZonalTransition zonalTransition = null;
        int n2 = this.initial.getRawOffset();
        int n3 = this.rules.size();
        DaylightSavingRule daylightSavingRule = this.rules.get(0);
        DaylightSavingRule daylightSavingRule2 = this.rules.get(n3 - 1);
        int n4 = RuleBasedTransitionModel.getShift(daylightSavingRule, n2, daylightSavingRule2.getSavings());
        int n5 = RuleBasedTransitionModel.getYear(daylightSavingRule, unixTime.getPosixTime() + (long)n4);
        List<ZonalTransition> list = this.getTransitions(n5);
        for (int i2 = 0; i2 < n3; ++i2) {
            ZonalTransition zonalTransition2 = list.get(i2);
            long l3 = zonalTransition2.getPosixTime();
            if (unixTime.getPosixTime() < l3) {
                if (zonalTransition != null || (zonalTransition2 = i2 == 0 ? this.getTransitions(n5 - 1).get(n3 - 1) : list.get(i2 - 1)).getPosixTime() <= l2) break;
                zonalTransition = zonalTransition2;
                break;
            }
            if (l3 <= l2) continue;
            zonalTransition = zonalTransition2;
        }
        return zonalTransition;
    }

    @Override
    public ZonalTransition getConflictTransition(GregorianDate gregorianDate, WallTime wallTime) {
        long l2 = TransitionModel.toLocalSecs(gregorianDate, wallTime);
        return this.getConflictTransition(gregorianDate, l2);
    }

    @Override
    public Optional<ZonalTransition> findNextTransition(UnixTime unixTime) {
        ZonalTransition zonalTransition = RuleBasedTransitionModel.getNextTransition(unixTime.getPosixTime(), this.initial, this.rules);
        return zonalTransition == null ? Optional.empty() : Optional.of(zonalTransition);
    }

    @Override
    public List<ZonalOffset> getValidOffsets(GregorianDate gregorianDate, WallTime wallTime) {
        long l2 = TransitionModel.toLocalSecs(gregorianDate, wallTime);
        return this.getValidOffsets(gregorianDate, l2);
    }

    @Override
    public List<ZonalTransition> getStdTransitions() {
        return this.stdTransitions;
    }

    @Override
    public List<ZonalTransition> getTransitions(UnixTime unixTime, UnixTime unixTime2) {
        return RuleBasedTransitionModel.getTransitions(this.initial, this.rules, unixTime.getPosixTime(), unixTime2.getPosixTime());
    }

    @Override
    public boolean hasNegativeDST() {
        for (DaylightSavingRule daylightSavingRule : this.rules) {
            if (daylightSavingRule.getSavings() >= 0) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RuleBasedTransitionModel) {
            RuleBasedTransitionModel ruleBasedTransitionModel = (RuleBasedTransitionModel)object;
            return this.initial.equals(ruleBasedTransitionModel.initial) && this.rules.equals(ruleBasedTransitionModel.rules);
        }
        return false;
    }

    public int hashCode() {
        return 17 * this.initial.hashCode() + 37 * this.rules.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[initial=");
        stringBuilder.append(this.initial);
        stringBuilder.append(",rules=");
        stringBuilder.append(this.rules);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public void dump(Appendable appendable) throws IOException {
        appendable.append("*** Last rules:").append(NEW_LINE);
        for (DaylightSavingRule daylightSavingRule : this.rules) {
            appendable.append(">>> ").append(daylightSavingRule.toString()).append(NEW_LINE);
        }
    }

    ZonalTransition getInitialTransition() {
        return this.initial;
    }

    List<DaylightSavingRule> getRules() {
        return this.rules;
    }

    ZonalTransition getConflictTransition(GregorianDate gregorianDate, long l2) {
        int n2;
        long l3 = this.initial.getPosixTime();
        if (l2 <= l3 + (long)(n2 = Math.max(this.initial.getPreviousOffset(), this.initial.getTotalOffset()))) {
            return null;
        }
        for (ZonalTransition zonalTransition : this.getTransitions(gregorianDate)) {
            long l4 = zonalTransition.getPosixTime();
            if (zonalTransition.isGap()) {
                if (l2 < l4 + (long)zonalTransition.getPreviousOffset()) {
                    return null;
                }
                if (l2 >= l4 + (long)zonalTransition.getTotalOffset()) continue;
                return zonalTransition;
            }
            if (!zonalTransition.isOverlap()) continue;
            if (l2 < l4 + (long)zonalTransition.getTotalOffset()) {
                return null;
            }
            if (l2 >= l4 + (long)zonalTransition.getPreviousOffset()) continue;
            return zonalTransition;
        }
        return null;
    }

    List<ZonalOffset> getValidOffsets(GregorianDate gregorianDate, long l2) {
        long l3 = this.initial.getPosixTime();
        int n2 = this.initial.getTotalOffset();
        int n3 = Math.max(this.initial.getPreviousOffset(), n2);
        if (l2 <= l3 + (long)n3) {
            return TransitionModel.toList(n2);
        }
        for (ZonalTransition zonalTransition : this.getTransitions(gregorianDate)) {
            long l4 = zonalTransition.getPosixTime();
            n2 = zonalTransition.getTotalOffset();
            if (zonalTransition.isGap()) {
                if (l2 < l4 + (long)zonalTransition.getPreviousOffset()) {
                    return TransitionModel.toList(zonalTransition.getPreviousOffset());
                }
                if (l2 >= l4 + (long)n2) continue;
                return Collections.emptyList();
            }
            if (!zonalTransition.isOverlap()) continue;
            if (l2 < l4 + (long)n2) {
                return TransitionModel.toList(zonalTransition.getPreviousOffset());
            }
            if (l2 >= l4 + (long)zonalTransition.getPreviousOffset()) continue;
            return TransitionModel.toList(n2, zonalTransition.getPreviousOffset());
        }
        return TransitionModel.toList(n2);
    }

    static List<ZonalTransition> getTransitions(ZonalTransition zonalTransition, List<DaylightSavingRule> list, long l2, long l3) {
        long l4 = zonalTransition.getPosixTime();
        if (l2 > l3) {
            throw new IllegalArgumentException("Start after end.");
        }
        if (l3 <= l4 || l2 == l3) {
            return Collections.emptyList();
        }
        ArrayList<ZonalTransition> arrayList = new ArrayList<ZonalTransition>();
        int n2 = Integer.MIN_VALUE;
        int n3 = list.size();
        int n4 = 0;
        int n5 = zonalTransition.getRawOffset();
        while (true) {
            DaylightSavingRule daylightSavingRule = list.get(n4 % n3);
            DaylightSavingRule daylightSavingRule2 = list.get((n4 - 1 + n3) % n3);
            int n6 = RuleBasedTransitionModel.getShift(daylightSavingRule, n5, daylightSavingRule2.getSavings());
            if (n4 == 0) {
                n2 = RuleBasedTransitionModel.getYear(daylightSavingRule, Math.max(l2, l4) + (long)n6);
            } else if (n4 % n3 == 0) {
                ++n2;
            }
            long l5 = RuleBasedTransitionModel.getTransitionTime(daylightSavingRule, n2, n6);
            ++n4;
            if (l5 >= l3) break;
            if (l5 < l2 || l5 <= l4) continue;
            arrayList.add(new ZonalTransition(l5, n5 + daylightSavingRule2.getSavings(), n5 + daylightSavingRule.getSavings(), daylightSavingRule.getSavings()));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static ZonalTransition getNextTransition(long l2, ZonalTransition zonalTransition, List<DaylightSavingRule> list) {
        long l3 = Math.max(l2, zonalTransition.getPosixTime());
        int n2 = Integer.MIN_VALUE;
        int n3 = zonalTransition.getRawOffset();
        ZonalTransition zonalTransition2 = null;
        int n4 = 0;
        int n5 = list.size();
        while (zonalTransition2 == null) {
            DaylightSavingRule daylightSavingRule = list.get(n4 % n5);
            DaylightSavingRule daylightSavingRule2 = list.get((n4 - 1 + n5) % n5);
            int n6 = RuleBasedTransitionModel.getShift(daylightSavingRule, n3, daylightSavingRule2.getSavings());
            if (n4 == 0) {
                n2 = RuleBasedTransitionModel.getYear(daylightSavingRule, l3 + (long)n6);
            } else if (n4 % n5 == 0) {
                ++n2;
            }
            long l4 = RuleBasedTransitionModel.getTransitionTime(daylightSavingRule, n2, n6);
            if (l4 > l3) {
                zonalTransition2 = new ZonalTransition(l4, n3 + daylightSavingRule2.getSavings(), n3 + daylightSavingRule.getSavings(), daylightSavingRule.getSavings());
            }
            ++n4;
        }
        return zonalTransition2;
    }

    private static int getShift(DaylightSavingRule daylightSavingRule, int n2, int n3) {
        OffsetIndicator offsetIndicator = daylightSavingRule.getIndicator();
        switch (offsetIndicator) {
            case UTC_TIME: {
                return 0;
            }
            case STANDARD_TIME: {
                return n2;
            }
            case WALL_TIME: {
                return n2 + n3;
            }
        }
        throw new UnsupportedOperationException(offsetIndicator.name());
    }

    private static long getTransitionTime(DaylightSavingRule daylightSavingRule, int n2, int n3) {
        PlainTimestamp plainTimestamp = daylightSavingRule.getDate(n2).at(daylightSavingRule.getTimeOfDay());
        return plainTimestamp.at(ZonalOffset.ofTotalSeconds(n3)).getPosixTime();
    }

    private List<ZonalTransition> getTransitions(GregorianDate gregorianDate) {
        return this.getTransitions(this.rules.get(0).toCalendarYear(gregorianDate));
    }

    private List<ZonalTransition> getTransitions(int n2) {
        Integer n3 = n2;
        List list = (List)this.tCache.get(n3);
        if (list == null) {
            List list2;
            ArrayList<ZonalTransition> arrayList = new ArrayList<ZonalTransition>();
            int n4 = this.initial.getRawOffset();
            int n5 = this.rules.size();
            for (int i2 = 0; i2 < n5; ++i2) {
                DaylightSavingRule daylightSavingRule = this.rules.get(i2);
                DaylightSavingRule daylightSavingRule2 = this.rules.get((i2 - 1 + n5) % n5);
                int n6 = RuleBasedTransitionModel.getShift(daylightSavingRule, n4, daylightSavingRule2.getSavings());
                arrayList.add(new ZonalTransition(RuleBasedTransitionModel.getTransitionTime(daylightSavingRule, n2, n6), n4 + daylightSavingRule2.getSavings(), n4 + daylightSavingRule.getSavings(), daylightSavingRule.getSavings()));
            }
            list = Collections.unmodifiableList(arrayList);
            if (n2 <= LAST_CACHED_YEAR && this.gregorian && (list2 = this.tCache.putIfAbsent(n3, list)) != null) {
                list = list2;
            }
        }
        return list;
    }

    private static int getYear(DaylightSavingRule daylightSavingRule, long l2) {
        return daylightSavingRule.toCalendarYear(EpochDays.MODIFIED_JULIAN_DATE.transform(MathUtils.floorDivide(l2, 86400), EpochDays.UNIX));
    }

    private Object writeReplace() {
        return new SPX(this, 125);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        long l2 = TransitionModel.getFutureMoment(100);
        long l3 = EpochDays.MODIFIED_JULIAN_DATE.transform(l2, EpochDays.UNIX);
        LAST_CACHED_YEAR = GregorianMath.readYear(GregorianMath.toPackedDate(l3));
    }
}

