/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.text.ParseException;
import net.time4j.CalendarUnit;
import net.time4j.PlainDate;
import net.time4j.base.MathUtils;
import net.time4j.engine.TimePoint;
import net.time4j.range.CalendarQuarter;
import net.time4j.range.SingleUnitTimeSpan;

public final class Quarters
extends SingleUnitTimeSpan<CalendarUnit, Quarters> {
    public static final Quarters ZERO = new Quarters(0);
    public static final Quarters ONE = new Quarters(1);
    private static final long serialVersionUID = -2100419304667904214L;

    private Quarters(int n2) {
        super(n2, CalendarUnit.QUARTERS);
    }

    public static Quarters of(int n2) {
        return n2 == 0 ? ZERO : (n2 == 1 ? ONE : new Quarters(n2));
    }

    public static <T extends TimePoint<? super CalendarUnit, T>> Quarters between(T t2, T t3) {
        long l2 = CalendarUnit.QUARTERS.between(t2, t3);
        return Quarters.of(MathUtils.safeCast(l2));
    }

    public static Quarters between(CalendarQuarter calendarQuarter, CalendarQuarter calendarQuarter2) {
        PlainDate plainDate = calendarQuarter.atDayOfQuarter(1);
        PlainDate plainDate2 = calendarQuarter2.atDayOfQuarter(1);
        return Quarters.between(plainDate, plainDate2);
    }

    public static Quarters parsePeriod(String string) throws ParseException {
        int n2 = SingleUnitTimeSpan.parsePeriod(string, 'Q');
        return Quarters.of(n2);
    }

    @Override
    Quarters with(int n2) {
        return Quarters.of(n2);
    }

    @Override
    Quarters self() {
        return this;
    }
}

