/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import net.time4j.CalendarUnit;
import net.time4j.IsoDateUnit;
import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.engine.BasicUnit;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.engine.UnitRule;
import net.time4j.range.HolidayModel;

class BusinessDayUnit
extends BasicUnit
implements IsoDateUnit {
    private final UnitRule<PlainDate> dateRule;

    BusinessDayUnit(final HolidayModel holidayModel) {
        this.dateRule = new UnitRule<PlainDate>(){

            @Override
            public PlainDate addTo(PlainDate plainDate, long l2) {
                PlainDate plainDate2;
                block3: {
                    block2: {
                        plainDate2 = plainDate;
                        if (l2 <= 0L) break block2;
                        int n2 = 0;
                        while ((long)n2 < l2) {
                            plainDate2 = plainDate2.with(holidayModel.nextBusinessDay());
                            ++n2;
                        }
                        break block3;
                    }
                    if (l2 >= 0L) break block3;
                    int n3 = 0;
                    while ((long)n3 > l2) {
                        plainDate2 = plainDate2.with(holidayModel.previousBusinessDay());
                        --n3;
                    }
                }
                return plainDate2;
            }

            @Override
            public long between(PlainDate plainDate, PlainDate plainDate2) {
                if (plainDate.isSimultaneous(plainDate2)) {
                    return 0L;
                }
                long l2 = 0L;
                boolean bl2 = plainDate.isAfter(plainDate2);
                if (bl2) {
                    do {
                        if (holidayModel.test(plainDate2 = plainDate2.plus(1L, CalendarUnit.DAYS))) continue;
                        ++l2;
                    } while (plainDate2.isBefore(plainDate));
                } else {
                    do {
                        if (holidayModel.test(plainDate = plainDate.plus(1L, CalendarUnit.DAYS))) continue;
                        ++l2;
                    } while (plainDate.isBefore(plainDate2));
                }
                return bl2 ? -l2 : l2;
            }
        };
    }

    @Override
    public char getSymbol() {
        return '\u0000';
    }

    @Override
    public double getLength() {
        return 86400.0;
    }

    @Override
    public <T extends ChronoEntity<T>> UnitRule<T> derive(Chronology<T> chronology) {
        if (PlainDate.class.isAssignableFrom(chronology.getChronoType())) {
            UnitRule<PlainDate> unitRule = this.dateRule;
            return unitRule;
        }
        if (PlainTimestamp.class.isAssignableFrom(chronology.getChronoType())) {
            UnitRule<PlainTimestamp> unitRule = new UnitRule<PlainTimestamp>(){

                @Override
                public PlainTimestamp addTo(PlainTimestamp plainTimestamp, long l2) {
                    PlainDate plainDate = BusinessDayUnit.this.dateRule.addTo(plainTimestamp.toDate(), l2);
                    return PlainTimestamp.of(plainDate, plainTimestamp.toTime());
                }

                @Override
                public long between(PlainTimestamp plainTimestamp, PlainTimestamp plainTimestamp2) {
                    long l2 = BusinessDayUnit.this.dateRule.between(plainTimestamp.toDate(), plainTimestamp2.toDate());
                    if (l2 > 0L && plainTimestamp.toTime().isAfter(plainTimestamp2.toTime())) {
                        --l2;
                    } else if (l2 < 0L && plainTimestamp.toTime().isBefore(plainTimestamp2.toTime())) {
                        ++l2;
                    }
                    return l2;
                }
            };
            return unitRule;
        }
        throw new UnsupportedOperationException(chronology.getChronoType().getName());
    }
}

