/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.tz.OffsetSign;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

final class TimezoneOffsetProcessor
implements FormatProcessor<TZID> {
    static final TimezoneOffsetProcessor EXTENDED_LONG_PARSER = new TimezoneOffsetProcessor();
    private final FormatStyle precision;
    private final boolean extended;
    private final List<String> zeroOffsets;
    private final boolean caseInsensitive;
    private final Leniency lenientMode;

    TimezoneOffsetProcessor(FormatStyle formatStyle, boolean bl2, List<String> list) {
        if (formatStyle == null) {
            throw new NullPointerException("Missing display mode.");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Missing zero offsets.");
        }
        ArrayList<String> arrayList = new ArrayList<String>(list);
        for (String string : arrayList) {
            if (!string.trim().isEmpty()) continue;
            throw new IllegalArgumentException("Zero offset must not be white-space-only.");
        }
        this.precision = formatStyle;
        this.extended = bl2;
        this.zeroOffsets = Collections.unmodifiableList(arrayList);
        this.caseInsensitive = true;
        this.lenientMode = Leniency.SMART;
    }

    private TimezoneOffsetProcessor() {
        this.precision = FormatStyle.LONG;
        this.extended = true;
        this.zeroOffsets = Collections.emptyList();
        this.caseInsensitive = true;
        this.lenientMode = Leniency.SMART;
    }

    private TimezoneOffsetProcessor(FormatStyle formatStyle, boolean bl2, List<String> list, boolean bl3, Leniency leniency) {
        this.precision = formatStyle;
        this.extended = bl2;
        this.zeroOffsets = list;
        this.caseInsensitive = bl3;
        this.lenientMode = leniency;
    }

    @Override
    public int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl2) throws IOException {
        ZonalOffset zonalOffset;
        int n2 = -1;
        int n3 = 0;
        if (appendable instanceof CharSequence) {
            n2 = ((CharSequence)((Object)appendable)).length();
        }
        TZID tZID = null;
        if (chronoDisplay.hasTimezone()) {
            tZID = chronoDisplay.getTimezone();
        }
        if (tZID == null) {
            zonalOffset = TimezoneOffsetProcessor.getOffset(chronoDisplay, attributeQuery);
        } else if (tZID instanceof ZonalOffset) {
            zonalOffset = (ZonalOffset)tZID;
        } else if (chronoDisplay instanceof UnixTime) {
            zonalOffset = Timezone.of(tZID).getOffset((UnixTime)((Object)chronoDisplay));
        } else {
            throw new IllegalArgumentException("Cannot extract timezone offset from: " + chronoDisplay);
        }
        int n4 = zonalOffset.getIntegralAmount();
        int n5 = zonalOffset.getFractionalAmount();
        if ((n4 | n5) == 0) {
            String string = this.zeroOffsets.get(0);
            appendable.append(string);
            n3 = string.length();
        } else {
            boolean bl3 = n4 < 0 || n5 < 0;
            appendable.append(bl3 ? (char)'-' : '+');
            ++n3;
            int n6 = Math.abs(n4);
            int n7 = n6 / 3600;
            int n8 = n6 / 60 % 60;
            int n9 = n6 % 60;
            if (n7 < 10) {
                appendable.append('0');
                ++n3;
            }
            String string = String.valueOf(n7);
            appendable.append(string);
            n3 += string.length();
            if (this.precision != FormatStyle.SHORT || n8 != 0) {
                if (this.extended) {
                    appendable.append(':');
                    ++n3;
                }
                if (n8 < 10) {
                    appendable.append('0');
                    ++n3;
                }
                String string2 = String.valueOf(n8);
                appendable.append(string2);
                n3 += string2.length();
                if (this.precision != FormatStyle.SHORT && this.precision != FormatStyle.MEDIUM && (this.precision == FormatStyle.FULL || (n9 | n5) != 0)) {
                    if (this.extended) {
                        appendable.append(':');
                        ++n3;
                    }
                    if (n9 < 10) {
                        appendable.append('0');
                        ++n3;
                    }
                    String string3 = String.valueOf(n9);
                    appendable.append(string3);
                    n3 += string3.length();
                    if (n5 != 0) {
                        appendable.append('.');
                        ++n3;
                        String string4 = String.valueOf(Math.abs(n5));
                        int n10 = 9 - string4.length();
                        for (int i2 = 0; i2 < n10; ++i2) {
                            appendable.append('0');
                            ++n3;
                        }
                        appendable.append(string4);
                        n3 += string4.length();
                    }
                }
            }
        }
        if (n2 != -1 && n3 > 0 && set != null) {
            set.add(new ElementPosition(TimezoneElement.TIMEZONE_ID, n2, n2 + n3));
        }
        return n3;
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl2) {
        ZonalOffset zonalOffset;
        int n2;
        OffsetSign offsetSign;
        int n3;
        int n4 = charSequence.length();
        int n5 = parseLog.getPosition();
        int n6 = n5;
        if (n6 >= n4) {
            parseLog.setError(n5, "Missing timezone offset.");
            return;
        }
        for (String string : this.zeroOffsets) {
            int n7 = string.length();
            if (n4 - n6 < n7) continue;
            String string2 = charSequence.subSequence(n6, n6 + n7).toString();
            int n8 = n3 = (int)((bl2 ? this.caseInsensitive : attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE)) ? 1 : 0);
            if ((n3 == 0 || !string2.equalsIgnoreCase(string)) && (n3 != 0 || !string2.equals(string))) continue;
            parsedEntity.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.UTC);
            parseLog.setPosition(n6 + n7);
            return;
        }
        Leniency leniency = bl2 ? this.lenientMode : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
        char c2 = charSequence.charAt(n6);
        if (c2 == '+') {
            offsetSign = OffsetSign.AHEAD_OF_UTC;
            ++n6;
        } else if (c2 == '-') {
            offsetSign = OffsetSign.BEHIND_UTC;
            ++n6;
        } else if (Character.isDigit(c2) && leniency.isLax()) {
            offsetSign = OffsetSign.AHEAD_OF_UTC;
        } else {
            parseLog.setError(n5, "Missing sign of timezone offset.");
            return;
        }
        int n9 = TimezoneOffsetProcessor.parseNum(charSequence, n6, leniency);
        if (n9 == -1000) {
            parseLog.setError(n6, "Hour part in timezone offset does not match expected pattern HH.");
            return;
        }
        if (n9 < 0) {
            n9 ^= 0xFFFFFFFF;
            ++n6;
        } else {
            n6 += 2;
        }
        if (n6 >= n4) {
            if (this.precision == FormatStyle.SHORT) {
                parsedEntity.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.ofHours(offsetSign, n9));
                parseLog.setPosition(n6);
            } else {
                parseLog.setError(n6, "Missing minute part in timezone offset.");
            }
            return;
        }
        n3 = 0;
        if (this.extended) {
            if (charSequence.charAt(n6) == ':') {
                n3 = 1;
            } else {
                if (this.precision == FormatStyle.SHORT) {
                    parsedEntity.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.ofHours(offsetSign, n9));
                    parseLog.setPosition(n6);
                    return;
                }
                parseLog.setError(n6, "Colon expected in timezone offset.");
                return;
            }
        }
        int n10 = TimezoneOffsetProcessor.parseNum(charSequence, n6 + n3, Leniency.STRICT);
        int n11 = 0;
        int n12 = 0;
        if (n10 == -1000) {
            if (this.precision == FormatStyle.SHORT) {
                parsedEntity.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.ofHours(offsetSign, n9));
                parseLog.setPosition(n6);
            } else {
                parseLog.setError(n6 + n3, "Minute part in timezone offset does not match expected pattern mm.");
            }
            return;
        }
        n6 += n3;
        if ((n6 += 2) < n4 && (this.precision == FormatStyle.LONG || this.precision == FormatStyle.FULL)) {
            n3 = 0;
            if (this.extended) {
                if (charSequence.charAt(n6) == ':') {
                    n3 = 1;
                    n11 = TimezoneOffsetProcessor.parseNum(charSequence, n6 + n3, Leniency.STRICT);
                } else {
                    if (this.precision == FormatStyle.FULL) {
                        parseLog.setError(n6, "Colon expected in timezone offset.");
                        return;
                    }
                    n11 = -1000;
                }
            } else {
                n11 = TimezoneOffsetProcessor.parseNum(charSequence, n6, Leniency.STRICT);
            }
            if (n11 == -1000) {
                if (this.precision == FormatStyle.FULL) {
                    parseLog.setError(n6, "Second part in timezone offset does not match expected pattern ss.");
                    return;
                }
                n11 = 0;
            } else {
                char c3;
                n6 += n3;
                if ((n6 += 2) + 10 <= n4 && (c3 = charSequence.charAt(n6)) == '.') {
                    int n13 = n6 + 9;
                    for (n2 = ++n6; n2 < n13; ++n2) {
                        char c4 = charSequence.charAt(n2);
                        if (c4 >= '0' && c4 <= '9') {
                            n12 = n12 * 10 + (c4 - 48);
                            ++n6;
                            continue;
                        }
                        parseLog.setError(n6, "9 digits in fractional part of timezone offset expected.");
                        return;
                    }
                }
            }
        }
        if (n11 == 0 && n12 == 0) {
            zonalOffset = ZonalOffset.ofHoursMinutes(offsetSign, n9, n10);
        } else {
            n2 = n9 * 3600 + n10 * 60 + n11;
            if (offsetSign == OffsetSign.BEHIND_UTC) {
                n2 = -n2;
                n12 = -n12;
            }
            zonalOffset = ZonalOffset.ofTotalSeconds(n2, n12);
        }
        parsedEntity.put(TimezoneElement.TIMEZONE_OFFSET, zonalOffset);
        parseLog.setPosition(n6);
    }

    @Override
    public ChronoElement<TZID> getElement() {
        return TimezoneElement.TIMEZONE_OFFSET;
    }

    @Override
    public FormatProcessor<TZID> withElement(ChronoElement<TZID> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<TZID> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n2) {
        return new TimezoneOffsetProcessor(this.precision, this.extended, this.zeroOffsets, attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE), attributeQuery.get(Attributes.LENIENCY, Leniency.SMART));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TimezoneOffsetProcessor) {
            TimezoneOffsetProcessor timezoneOffsetProcessor = (TimezoneOffsetProcessor)object;
            return this.precision == timezoneOffsetProcessor.precision && this.extended == timezoneOffsetProcessor.extended && this.zeroOffsets.equals(timezoneOffsetProcessor.zeroOffsets);
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.precision.hashCode() + 31 * this.zeroOffsets.hashCode() + (this.extended ? 1 : 0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[precision=");
        stringBuilder.append((Object)this.precision);
        stringBuilder.append(", extended=");
        stringBuilder.append(this.extended);
        stringBuilder.append(", zero-offsets=");
        stringBuilder.append(this.zeroOffsets);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static ZonalOffset getOffset(ChronoDisplay chronoDisplay, AttributeQuery attributeQuery) {
        if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
            TZID tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            if (tZID instanceof ZonalOffset) {
                return (ZonalOffset)tZID;
            }
            if (tZID != null) {
                throw new IllegalArgumentException("Use a timezone offset instead of [" + tZID.canonical() + "] when formatting [" + chronoDisplay + "].");
            }
        }
        throw new IllegalArgumentException("Cannot extract timezone offset from format attributes for: " + chronoDisplay);
    }

    private static int parseNum(CharSequence charSequence, int n2, Leniency leniency) {
        int n3 = 0;
        for (int i2 = 0; i2 < 2; ++i2) {
            int n4 = n2 + i2 >= charSequence.length() ? 0 : (int)charSequence.charAt(n2 + i2);
            if (n4 < 48 || n4 > 57) {
                if (i2 == 0 || leniency.isStrict()) {
                    return -1000;
                }
                return ~n3;
            }
            n3 = n3 * 10 + (n4 - 48);
        }
        return n3;
    }
}

