/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.time.format.FormatStyle;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.AdjustableElement;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.Weekmodel;
import net.time4j.engine.BridgeChronology;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.Chronology;
import net.time4j.engine.EpochDays;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.NumberSystem;
import net.time4j.format.OutputContext;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.SignPolicy;
import net.time4j.format.internal.DualFormatElement;
import net.time4j.history.ChronoHistory;
import net.time4j.tz.NameStyle;

public enum PatternType {
    CLDR,
    SIMPLE_DATE_FORMAT,
    THREETEN,
    CLDR_24,
    CLDR_DATE,
    DYNAMIC;


    Map<ChronoElement<?>, ChronoElement<?>> registerSymbol(ChronoFormatter.Builder<?> builder, Locale locale, char c2, int n2) {
        Chronology<?> chronology = PatternType.getEffectiveChronology(builder);
        switch (this) {
            case CLDR: {
                return this.cldr(builder, locale, c2, n2);
            }
            case SIMPLE_DATE_FORMAT: {
                return this.sdf(builder, chronology, locale, c2, n2);
            }
            case THREETEN: {
                return this.threeten(builder, chronology, locale, c2, n2);
            }
            case CLDR_24: {
                return this.cldr24(builder, locale, c2, n2);
            }
            case CLDR_DATE: {
                Class<?> clazz = chronology.getChronoType();
                if (Calendrical.class.isAssignableFrom(clazz) || CalendarVariant.class.isAssignableFrom(clazz)) {
                    return this.general(builder, chronology, c2, n2, locale);
                }
                throw new IllegalArgumentException("No calendar chronology.");
            }
            case DYNAMIC: {
                return this.dynamic(builder, c2, n2, locale);
            }
        }
        throw new UnsupportedOperationException(this.name());
    }

    private static boolean isGeneralSymbol(char c2) {
        switch (c2) {
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'L': 
            case 'M': 
            case 'U': 
            case 'W': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'g': 
            case 'r': 
            case 'w': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    private static boolean isISO(Chronology<?> chronology) {
        return PatternType.getCalendarType(chronology).equals("iso8601");
    }

    private static String getCalendarType(Chronology<?> chronology) {
        CalendarType calendarType = chronology.getChronoType().getAnnotation(CalendarType.class);
        return calendarType == null ? "iso8601" : calendarType.value();
    }

    private static ChronoElement<Integer> findEthiopianHour(Chronology<?> chronology) {
        for (ChronoExtension chronoExtension : chronology.getExtensions()) {
            for (ChronoElement<?> chronoElement : chronoExtension.getElements(Locale.ROOT, Attributes.empty())) {
                if (!chronoElement.name().equals("ETHIOPIAN_HOUR")) continue;
                return (ChronoElement)PatternType.cast(chronoElement);
            }
        }
        return null;
    }

    private static Chronology<?> getEffectiveChronology(ChronoFormatter.Builder<?> builder) {
        Chronology<?> chronology = builder.getChronology();
        while (chronology instanceof BridgeChronology) {
            chronology = chronology.preparser();
        }
        return chronology;
    }

    private Map<ChronoElement<?>, ChronoElement<?>> cldr(ChronoFormatter.Builder<?> builder, Locale locale, char c2, int n2) {
        Chronology<?> chronology = PatternType.getEffectiveChronology(builder);
        if (PatternType.isGeneralSymbol(c2) && !PatternType.isISO(chronology)) {
            return this.general(builder, chronology, c2, n2, locale);
        }
        if (c2 == 'h' && PatternType.getCalendarType(chronology).equals("ethiopic")) {
            ChronoElement<Integer> chronoElement = PatternType.findEthiopianHour(chronology);
            if (chronoElement == null) {
                throw new IllegalArgumentException("Ethiopian time not available.");
            }
            PatternType.addNumber(chronoElement, c2, builder, n2, false);
            return Collections.emptyMap();
        }
        return this.cldrISO(builder, chronology, locale, c2, n2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<ChronoElement<?>, ChronoElement<?>> cldrISO(ChronoFormatter.Builder<?> builder, Chronology<?> chronology, Locale locale, char c2, int n2, boolean bl2) {
        switch (c2) {
            case 'G': {
                TextWidth textWidth;
                if (n2 <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n2 == 4 || bl2) {
                    textWidth = TextWidth.WIDE;
                } else {
                    if (n2 != 5) throw new IllegalArgumentException("Too many pattern letters (G): " + n2);
                    textWidth = TextWidth.NARROW;
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                ChronoHistory chronoHistory = ChronoHistory.of(locale);
                TextElement textElement = (TextElement)TextElement.class.cast(chronoHistory.era());
                builder.addText(textElement);
                builder.endSection();
                HashMap hashMap = new HashMap();
                hashMap.put(PlainDate.YEAR, chronoHistory.yearOfEra());
                hashMap.put(PlainDate.MONTH_OF_YEAR, chronoHistory.month());
                hashMap.put(PlainDate.MONTH_AS_NUMBER, chronoHistory.month());
                hashMap.put(PlainDate.DAY_OF_MONTH, chronoHistory.dayOfMonth());
                hashMap.put(PlainDate.DAY_OF_YEAR, chronoHistory.dayOfYear());
                return hashMap;
            }
            case 'y': {
                if (n2 == 2) {
                    builder.addTwoDigitYear(PlainDate.YEAR);
                    return Collections.emptyMap();
                }
                builder.addYear(PlainDate.YEAR, n2, false, false);
                return Collections.emptyMap();
            }
            case 'Y': {
                if (n2 == 2) {
                    builder.addTwoDigitYear(PlainDate.YEAR_OF_WEEKDATE);
                    return Collections.emptyMap();
                }
                builder.addYear(PlainDate.YEAR_OF_WEEKDATE, n2, false, false);
                return Collections.emptyMap();
            }
            case 'u': {
                builder.addYear(PlainDate.YEAR, n2, true, false);
                return Collections.emptyMap();
            }
            case 'r': {
                builder.startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
                builder.startSection(Attributes.ZERO_DIGIT, 48);
                builder.addYear(PlainDate.YEAR, n2, true, false);
                builder.endSection();
                builder.endSection();
                return Collections.emptyMap();
            }
            case 'Q': {
                PatternType.addQuarterOfYear(builder, n2);
                return Collections.emptyMap();
            }
            case 'q': {
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                PatternType.addQuarterOfYear(builder, n2);
                builder.endSection();
                return Collections.emptyMap();
            }
            case 'M': {
                PatternType.addMonth(builder, Math.min(n2, bl2 ? 4 : n2));
                return Collections.emptyMap();
            }
            case 'L': {
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                PatternType.addMonth(builder, Math.min(n2, bl2 ? 4 : n2));
                builder.endSection();
                return Collections.emptyMap();
            }
            case 'w': {
                if (n2 > 2) throw new IllegalArgumentException("Too many pattern letters (w): " + n2);
                AdjustableElement<Integer, PlainDate> adjustableElement = Weekmodel.of(locale).weekOfYear();
                for (ChronoElement<?> chronoElement : chronology.getRegisteredElements()) {
                    if (chronoElement.getSymbol() != c2 || !chronoElement.equals(Weekmodel.ISO.weekOfYear())) continue;
                    adjustableElement = Weekmodel.ISO.weekOfYear();
                    break;
                }
                PatternType.addNumber(adjustableElement, c2, builder, n2, bl2);
                return Collections.emptyMap();
            }
            case 'W': {
                if (n2 != 1) throw new IllegalArgumentException("Too many pattern letters (W): " + n2);
                builder.addFixedInteger(Weekmodel.of(locale).weekOfMonth(), 1);
                return Collections.emptyMap();
            }
            case 'd': {
                PatternType.addNumber(PlainDate.DAY_OF_MONTH, c2, builder, n2, bl2);
                return Collections.emptyMap();
            }
            case 'D': {
                if (n2 < 3) {
                    builder.addInteger(PlainDate.DAY_OF_YEAR, n2, 3);
                    return Collections.emptyMap();
                }
                if (n2 != 3 && !bl2) throw new IllegalArgumentException("Too many pattern letters (D): " + n2);
                builder.addFixedInteger(PlainDate.DAY_OF_YEAR, n2);
                return Collections.emptyMap();
            }
            case 'F': {
                if (n2 != 1 && !bl2) throw new IllegalArgumentException("Too many pattern letters (F): " + n2);
                builder.addFixedInteger(PlainDate.WEEKDAY_IN_MONTH, n2);
                return Collections.emptyMap();
            }
            case 'g': {
                builder.addLongNumber(EpochDays.MODIFIED_JULIAN_DATE, n2, 18, SignPolicy.SHOW_WHEN_NEGATIVE);
                return Collections.emptyMap();
            }
            case 'E': {
                TextWidth textWidth;
                if (n2 <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n2 == 4 || bl2) {
                    textWidth = TextWidth.WIDE;
                } else if (n2 == 5) {
                    textWidth = TextWidth.NARROW;
                } else {
                    if (n2 != 6) throw new IllegalArgumentException("Too many pattern letters (E): " + n2);
                    textWidth = TextWidth.SHORT;
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(PlainDate.DAY_OF_WEEK);
                builder.endSection();
                return Collections.emptyMap();
            }
            case 'e': {
                if (n2 <= 2) {
                    builder.addFixedNumerical(Weekmodel.of(locale).localDayOfWeek(), n2);
                    return Collections.emptyMap();
                }
                this.cldrISO(builder, chronology, locale, 'E', n2, bl2);
                return Collections.emptyMap();
            }
            case 'c': {
                if (n2 == 2) {
                    throw new IllegalArgumentException("Invalid pattern count of 2 for symbol 'c'.");
                }
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                if (n2 == 1) {
                    builder.addFixedNumerical(Weekmodel.of(locale).localDayOfWeek(), 1);
                } else {
                    this.cldrISO(builder, chronology, locale, 'E', n2, bl2);
                }
                builder.endSection();
                return Collections.emptyMap();
            }
            case 'a': {
                TextWidth textWidth = bl2 ? TextWidth.ABBREVIATED : PatternType.getPeriodWidth(n2);
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(PlainTime.AM_PM_OF_DAY);
                builder.endSection();
                if (!PatternType.getCalendarType(chronology).equals("ethiopic")) return Collections.emptyMap();
                ChronoElement<Integer> chronoElement = PatternType.findEthiopianHour(chronology);
                if (chronoElement == null) {
                    throw new IllegalArgumentException("Ethiopian time not available.");
                }
                HashMap hashMap = new HashMap();
                hashMap.put(chronoElement, PlainTime.CLOCK_HOUR_OF_AMPM);
                return hashMap;
            }
            case 'b': {
                TextWidth textWidth = PatternType.getPeriodWidth(n2);
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addDayPeriodFixed();
                builder.endSection();
                return Collections.emptyMap();
            }
            case 'B': {
                TextWidth textWidth = PatternType.getPeriodWidth(n2);
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addDayPeriodApproximate();
                builder.endSection();
                return Collections.emptyMap();
            }
            case 'h': {
                PatternType.addNumber(PlainTime.CLOCK_HOUR_OF_AMPM, c2, builder, n2, bl2);
                return Collections.emptyMap();
            }
            case 'H': {
                PatternType.addNumber(PlainTime.DIGITAL_HOUR_OF_DAY, c2, builder, n2, bl2);
                return Collections.emptyMap();
            }
            case 'K': {
                PatternType.addNumber(PlainTime.DIGITAL_HOUR_OF_AMPM, c2, builder, n2, bl2);
                return Collections.emptyMap();
            }
            case 'k': {
                PatternType.addNumber(PlainTime.CLOCK_HOUR_OF_DAY, c2, builder, n2, bl2);
                return Collections.emptyMap();
            }
            case 'm': {
                PatternType.addNumber(PlainTime.MINUTE_OF_HOUR, c2, builder, n2, bl2);
                return Collections.emptyMap();
            }
            case 's': {
                PatternType.addNumber(PlainTime.SECOND_OF_MINUTE, c2, builder, n2, bl2);
                return Collections.emptyMap();
            }
            case 'S': {
                builder.addFraction(PlainTime.NANO_OF_SECOND, n2, n2, false);
                return Collections.emptyMap();
            }
            case 'A': {
                builder.addInteger(PlainTime.MILLI_OF_DAY, n2, 8);
                return Collections.emptyMap();
            }
            case 'z': {
                try {
                    if (n2 < 4) {
                        builder.addShortTimezoneName();
                        return Collections.emptyMap();
                    }
                    if (n2 != 4 && !bl2) throw new IllegalArgumentException("Too many pattern letters (z): " + n2);
                    builder.addLongTimezoneName();
                    return Collections.emptyMap();
                }
                catch (IllegalStateException illegalStateException) {
                    throw new IllegalArgumentException(illegalStateException.getMessage());
                }
            }
            case 'Z': {
                if (n2 < 4) {
                    builder.addTimezoneOffset(FormatStyle.LONG, false, Collections.singletonList("+0000"));
                    return Collections.emptyMap();
                }
                if (n2 == 4) {
                    builder.addLongLocalizedOffset();
                    return Collections.emptyMap();
                }
                if (n2 != 5) throw new IllegalArgumentException("Too many pattern letters (Z): " + n2);
                builder.addTimezoneOffset(FormatStyle.LONG, true, Collections.singletonList("Z"));
                return Collections.emptyMap();
            }
            case 'O': {
                if (n2 == 1) {
                    builder.addShortLocalizedOffset();
                    return Collections.emptyMap();
                }
                if (n2 != 4) throw new IllegalArgumentException("Count of pattern letters O is not 1 or 4: " + n2);
                builder.addLongLocalizedOffset();
                return Collections.emptyMap();
            }
            case 'v': {
                if (n2 == 1) {
                    builder.addTimezoneName(NameStyle.SHORT_GENERIC_TIME);
                    return Collections.emptyMap();
                }
                if (n2 != 4) throw new IllegalArgumentException("Count of pattern letters v is not 1 or 4: " + n2);
                builder.addTimezoneName(NameStyle.LONG_GENERIC_TIME);
                return Collections.emptyMap();
            }
            case 'V': {
                if (n2 != 2) throw new IllegalArgumentException("Count of pattern letters V is not 2: " + n2);
                try {
                    builder.addTimezoneID();
                    return Collections.emptyMap();
                }
                catch (IllegalStateException illegalStateException) {
                    throw new IllegalArgumentException(illegalStateException.getMessage());
                }
            }
            case 'X': {
                PatternType.addOffset(builder, c2, n2, true);
                return Collections.emptyMap();
            }
            case 'x': {
                PatternType.addOffset(builder, c2, n2, false);
                return Collections.emptyMap();
            }
            default: {
                throw new IllegalArgumentException("Unsupported pattern symbol: " + c2);
            }
        }
    }

    private static TextWidth getPeriodWidth(int n2) {
        if (n2 <= 3) {
            return TextWidth.ABBREVIATED;
        }
        if (n2 == 4) {
            return TextWidth.WIDE;
        }
        if (n2 == 5) {
            return TextWidth.NARROW;
        }
        throw new IllegalArgumentException("Too many pattern letters: " + n2);
    }

    private Map<ChronoElement<?>, ChronoElement<?>> sdf(ChronoFormatter.Builder<?> builder, Chronology<?> chronology, Locale locale, char c2, int n2) {
        switch (c2) {
            case 'W': {
                builder.addFixedInteger(Weekmodel.of(locale).boundedWeekOfMonth(), n2);
                break;
            }
            case 'u': {
                builder.addFixedNumerical(PlainDate.DAY_OF_WEEK, n2);
                break;
            }
            case 'S': {
                builder.addFixedInteger(PlainTime.MILLI_OF_SECOND, n2);
                break;
            }
            case 'Z': {
                PatternType.addOffset(builder, c2, 2, false);
                break;
            }
            case 'B': 
            case 'O': 
            case 'Q': 
            case 'U': 
            case 'V': 
            case 'b': 
            case 'c': 
            case 'e': 
            case 'g': 
            case 'q': 
            case 'r': 
            case 'v': 
            case 'x': {
                throw new IllegalArgumentException("CLDR pattern symbol not supported in SimpleDateFormat-style: " + c2);
            }
            case 'X': {
                if (n2 >= 4) {
                    throw new IllegalArgumentException("Too many pattern letters (X): " + n2);
                }
                return this.cldrISO(builder, chronology, locale, 'X', n2, true);
            }
            default: {
                return this.cldrISO(builder, chronology, locale, c2, n2, true);
            }
        }
        return Collections.emptyMap();
    }

    private Map<ChronoElement<?>, ChronoElement<?>> threeten(ChronoFormatter.Builder<?> builder, Chronology<?> chronology, Locale locale, char c2, int n2) {
        switch (c2) {
            case 'G': {
                TextWidth textWidth;
                if (n2 <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n2 == 4) {
                    textWidth = TextWidth.WIDE;
                } else if (n2 == 5) {
                    textWidth = TextWidth.NARROW;
                } else {
                    throw new IllegalArgumentException("Too many pattern letters (G): " + n2);
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                ChronoHistory chronoHistory = ChronoHistory.PROLEPTIC_GREGORIAN;
                TextElement textElement = (TextElement)TextElement.class.cast(chronoHistory.era());
                builder.addText(textElement);
                builder.endSection();
                builder.setProlepticGregorian();
                HashMap hashMap = new HashMap();
                hashMap.put(PlainDate.YEAR, chronoHistory.yearOfEra());
                hashMap.put(PlainDate.MONTH_OF_YEAR, chronoHistory.month());
                hashMap.put(PlainDate.MONTH_AS_NUMBER, chronoHistory.month());
                hashMap.put(PlainDate.DAY_OF_MONTH, chronoHistory.dayOfMonth());
                hashMap.put(PlainDate.DAY_OF_YEAR, chronoHistory.dayOfYear());
                return hashMap;
            }
            case 'y': {
                if (n2 == 2) {
                    builder.startSection(Attributes.PIVOT_YEAR, 2100);
                    builder.addTwoDigitYear(PlainDate.YEAR);
                    builder.endSection();
                    break;
                }
                builder.addYear(PlainDate.YEAR, n2, false, true);
                break;
            }
            case 'Y': {
                if (n2 == 2) {
                    builder.startSection(Attributes.PIVOT_YEAR, 2100);
                    builder.addTwoDigitYear(PlainDate.YEAR_OF_WEEKDATE);
                    builder.endSection();
                    break;
                }
                builder.addYear(PlainDate.YEAR_OF_WEEKDATE, n2, false, true);
                break;
            }
            case 'u': {
                if (n2 == 2) {
                    builder.startSection(Attributes.PIVOT_YEAR, 2100);
                    builder.addProlepticIsoYearWithTwoDigits();
                    builder.endSection();
                    break;
                }
                builder.addYear(PlainDate.YEAR, n2, true, true);
                break;
            }
            case 'W': {
                if (n2 == 1) {
                    builder.addFixedInteger(Weekmodel.of(locale).boundedWeekOfMonth(), 1);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters (W): " + n2);
            }
            case 'E': {
                TextWidth textWidth;
                if (n2 <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n2 == 4) {
                    textWidth = TextWidth.WIDE;
                } else if (n2 == 5) {
                    textWidth = TextWidth.NARROW;
                } else {
                    throw new IllegalArgumentException("Too many pattern letters (E): " + n2);
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(PlainDate.DAY_OF_WEEK);
                builder.endSection();
                break;
            }
            case 'e': {
                if (n2 <= 2) {
                    builder.addFixedNumerical(Weekmodel.of(locale).localDayOfWeek(), n2);
                    break;
                }
                this.threeten(builder, chronology, locale, 'E', n2);
                break;
            }
            case 'c': {
                if (n2 == 2) {
                    throw new IllegalArgumentException("Invalid pattern count of 2 for symbol 'c'.");
                }
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                this.threeten(builder, chronology, locale, 'e', n2);
                builder.endSection();
                break;
            }
            case 'a': {
                TextWidth textWidth = PatternType.getPeriodWidth(n2);
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(PlainTime.AM_PM_OF_DAY);
                builder.endSection();
                break;
            }
            case 'A': 
            case 'D': 
            case 'F': 
            case 'H': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'Q': 
            case 'S': 
            case 'd': 
            case 'g': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 'q': 
            case 's': 
            case 'w': {
                return this.cldrISO(builder, chronology, locale, c2, n2, false);
            }
            case 'n': {
                builder.addInteger(PlainTime.NANO_OF_SECOND, n2, 9);
                break;
            }
            case 'N': {
                builder.addLongNumber(PlainTime.NANO_OF_DAY, n2, 18, SignPolicy.SHOW_NEVER);
                break;
            }
            case 'z': {
                if (ChronoFormatter.hasUnixChronology(chronology)) {
                    return this.cldrISO(builder, chronology, locale, 'z', n2, false);
                }
                if (n2 <= 3) {
                    builder.addTimezoneName(NameStyle.SHORT_GENERIC_TIME);
                    break;
                }
                if (n2 == 4) {
                    builder.addTimezoneName(NameStyle.LONG_GENERIC_TIME);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters (z): " + n2);
            }
            case 'Z': {
                if (n2 < 4) {
                    builder.addTimezoneOffset(FormatStyle.MEDIUM, false, Collections.singletonList("+0000"));
                    break;
                }
                if (n2 == 4) {
                    builder.addLongLocalizedOffset();
                    break;
                }
                if (n2 == 5) {
                    builder.addTimezoneOffset(FormatStyle.LONG, true, Collections.singletonList("Z"));
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters (Z): " + n2);
            }
            case 'O': 
            case 'V': 
            case 'X': 
            case 'v': 
            case 'x': {
                return this.cldrISO(builder, chronology, locale, c2, n2, false);
            }
            case 'p': {
                builder.padNext(n2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported pattern symbol: " + c2);
            }
        }
        return Collections.emptyMap();
    }

    private Map<ChronoElement<?>, ChronoElement<?>> cldr24(ChronoFormatter.Builder<?> builder, Locale locale, char c2, int n2) {
        if (c2 == 'H') {
            PatternType.addNumber(PlainTime.HOUR_FROM_0_TO_24, c2, builder, n2, false);
            return Collections.emptyMap();
        }
        return this.cldr(builder, locale, c2, n2);
    }

    private static void addOffset(ChronoFormatter.Builder<?> builder, char c2, int n2, boolean bl2) {
        switch (n2) {
            case 1: {
                builder.addTimezoneOffset(FormatStyle.SHORT, false, Collections.singletonList(bl2 ? "Z" : "+00"));
                break;
            }
            case 2: {
                builder.addTimezoneOffset(FormatStyle.MEDIUM, false, Collections.singletonList(bl2 ? "Z" : "+0000"));
                break;
            }
            case 3: {
                builder.addTimezoneOffset(FormatStyle.MEDIUM, true, Collections.singletonList(bl2 ? "Z" : "+00:00"));
                break;
            }
            case 4: {
                builder.addTimezoneOffset(FormatStyle.LONG, false, Collections.singletonList(bl2 ? "Z" : "+0000"));
                break;
            }
            case 5: {
                builder.addTimezoneOffset(FormatStyle.LONG, true, Collections.singletonList(bl2 ? "Z" : "+00:00"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters (" + c2 + "): " + n2);
            }
        }
    }

    private static void addNumber(ChronoElement<Integer> chronoElement, char c2, ChronoFormatter.Builder<?> builder, int n2, boolean bl2) {
        if (n2 == 1) {
            builder.addInteger(chronoElement, 1, 2);
        } else if (n2 == 2 || bl2) {
            builder.addFixedInteger(chronoElement, n2);
        } else {
            throw new IllegalArgumentException("Too many pattern letters (" + c2 + "): " + n2);
        }
    }

    private static void addMonth(ChronoFormatter.Builder<?> builder, int n2) {
        switch (n2) {
            case 1: {
                builder.addInteger(PlainDate.MONTH_AS_NUMBER, 1, 2);
                break;
            }
            case 2: {
                builder.addFixedInteger(PlainDate.MONTH_AS_NUMBER, 2);
                break;
            }
            case 3: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED);
                builder.addText(PlainDate.MONTH_OF_YEAR);
                builder.endSection();
                break;
            }
            case 4: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                builder.addText(PlainDate.MONTH_OF_YEAR);
                builder.endSection();
                break;
            }
            case 5: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.NARROW);
                builder.addText(PlainDate.MONTH_OF_YEAR);
                builder.endSection();
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters for month: " + n2);
            }
        }
    }

    private static void addQuarterOfYear(ChronoFormatter.Builder<?> builder, int n2) {
        switch (n2) {
            case 1: 
            case 2: {
                builder.addFixedNumerical(PlainDate.QUARTER_OF_YEAR, n2);
                break;
            }
            case 3: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED);
                builder.addText(PlainDate.QUARTER_OF_YEAR);
                builder.endSection();
                break;
            }
            case 4: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                builder.addText(PlainDate.QUARTER_OF_YEAR);
                builder.endSection();
                break;
            }
            case 5: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.NARROW);
                builder.addText(PlainDate.QUARTER_OF_YEAR);
                builder.endSection();
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters for quarter-of-year: " + n2);
            }
        }
    }

    private Map<ChronoElement<?>, ChronoElement<?>> general(ChronoFormatter.Builder<?> builder, Chronology<?> chronology, char c2, int n2, Locale locale) {
        ChronoElement chronoElement;
        TextElement textElement;
        String string;
        if (c2 == 'g') {
            builder.addLongNumber(EpochDays.MODIFIED_JULIAN_DATE, n2, 18, SignPolicy.SHOW_WHEN_NEGATIVE);
            return Collections.emptyMap();
        }
        if (c2 == 'G' && chronology == PlainDate.axis()) {
            return this.cldrISO(builder, chronology, locale, c2, n2, false);
        }
        Set<ChronoElement<?>> set = PatternType.getElements(chronology, c2, locale);
        ChronoElement<?> chronoElement2 = PatternType.find(set, c2, string = builder.getChronology().getChronoType().getName());
        if (Integer.class.isAssignableFrom(chronoElement2.getType())) {
            textElement = null;
            if (chronoElement2 instanceof DualFormatElement) {
                textElement = (TextElement)PatternType.cast(chronoElement2);
            }
            chronoElement = (ChronoElement)PatternType.cast(chronoElement2);
        } else if (chronoElement2 instanceof TextElement) {
            textElement = (TextElement)PatternType.cast(chronoElement2);
            chronoElement = null;
        } else {
            throw new IllegalStateException("Implementation error: " + chronoElement2 + " in \"" + string + "\"");
        }
        switch (c2) {
            case 'G': {
                TextWidth textWidth;
                if (n2 <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n2 == 4) {
                    textWidth = TextWidth.WIDE;
                } else if (n2 == 5) {
                    textWidth = TextWidth.NARROW;
                } else {
                    throw new IllegalArgumentException("Too many pattern letters (G): " + n2);
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            case 'y': {
                boolean bl2 = false;
                if (locale.getLanguage().equals("am") && PatternType.getCalendarType(chronology).equals("ethiopic")) {
                    bl2 = true;
                    builder.startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ETHIOPIC);
                }
                if (n2 == 2) {
                    builder.addTwoDigitYear(chronoElement);
                } else {
                    builder.addYear(chronoElement, n2, false, false);
                }
                if (!bl2) break;
                builder.endSection();
                break;
            }
            case 'U': {
                TextWidth textWidth;
                if (textElement == null) {
                    throw new IllegalStateException("Implementation error: " + chronoElement2 + " in \"" + string + "\"");
                }
                if (n2 <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n2 == 4) {
                    textWidth = TextWidth.WIDE;
                } else if (n2 == 5) {
                    textWidth = TextWidth.NARROW;
                } else {
                    throw new IllegalArgumentException("Too many pattern letters (U): " + n2);
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            case 'r': {
                builder.startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
                builder.startSection(Attributes.ZERO_DIGIT, 48);
                builder.addYear(chronoElement, n2, true, false);
                builder.endSection();
                builder.endSection();
                break;
            }
            case 'M': {
                PatternType.addMonth(builder, n2, textElement);
                break;
            }
            case 'L': {
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                PatternType.addMonth(builder, n2, textElement);
                builder.endSection();
                break;
            }
            case 'w': {
                PatternType.addNumber(chronoElement, c2, builder, n2, false);
                break;
            }
            case 'W': {
                if (n2 == 1) {
                    builder.addFixedInteger(chronoElement, 1);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters (W): " + n2);
            }
            case 'd': {
                if (chronoElement == null) {
                    if (n2 <= 2) {
                        builder.startSection(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS, n2);
                        builder.addText(textElement);
                        builder.endSection();
                        break;
                    }
                    throw new IllegalArgumentException("Too many pattern letters for day-of-month: " + n2);
                }
                PatternType.addNumber(chronoElement, c2, builder, n2, false);
                break;
            }
            case 'D': {
                if (n2 < 3) {
                    builder.addInteger(chronoElement, n2, 3);
                    break;
                }
                if (n2 == 3) {
                    builder.addFixedInteger(chronoElement, n2);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters (D): " + n2);
            }
            case 'E': {
                TextWidth textWidth;
                if (n2 <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n2 == 4) {
                    textWidth = TextWidth.WIDE;
                } else if (n2 == 5) {
                    textWidth = TextWidth.NARROW;
                } else if (n2 == 6) {
                    textWidth = TextWidth.SHORT;
                } else {
                    throw new IllegalArgumentException("Too many pattern letters (E): " + n2);
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            case 'e': {
                if (n2 <= 2) {
                    ChronoElement chronoElement3 = (ChronoElement)PatternType.cast(chronoElement2);
                    builder.addFixedNumerical(chronoElement3, n2);
                    break;
                }
                this.general(builder, chronology, 'E', n2, locale);
                break;
            }
            case 'c': {
                if (n2 == 2) {
                    throw new IllegalArgumentException("Invalid pattern count of 2 for symbol 'c'.");
                }
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                if (n2 == 1) {
                    ChronoElement chronoElement4 = (ChronoElement)PatternType.cast(chronoElement2);
                    builder.addFixedNumerical(chronoElement4, 1);
                } else {
                    this.general(builder, chronology, 'E', n2, locale);
                }
                builder.endSection();
                break;
            }
            case 'F': {
                if (n2 == 1) {
                    builder.addFixedInteger(chronoElement, n2);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters (F): " + n2);
            }
            default: {
                throw new IllegalArgumentException("Unsupported pattern symbol: " + c2);
            }
        }
        return Collections.emptyMap();
    }

    private static int capitalized(int n2) {
        if (n2 >= 65 && n2 <= 90) {
            return n2;
        }
        return n2 + 65 - 97;
    }

    private static <V extends Enum<V>> void addEnumElementAsText(ChronoFormatter.Builder<?> builder, ChronoElement<V> chronoElement) {
        builder.addText(chronoElement);
    }

    private static <V extends Enum<V>> void addEnumElementAsInteger(ChronoFormatter.Builder<?> builder, ChronoElement<V> chronoElement, int n2) {
        builder.addNumerical(chronoElement, n2, 9);
    }

    private static ChronoElement<?> findDynamicElement(Chronology<?> chronology, Locale locale, int n2) {
        ChronoElement<?> chronoElement = PatternType.findDynamicElement(chronology, locale, n2, false);
        if (chronoElement == null) {
            chronoElement = PatternType.findDynamicElement(chronology, locale, n2, true);
        }
        return chronoElement;
    }

    private static ChronoElement<?> findDynamicElement(Chronology<?> chronology, Locale locale, int n2, boolean bl2) {
        if (bl2) {
            n2 = PatternType.capitalized(n2);
        }
        for (ChronoElement<?> object : chronology.getRegisteredElements()) {
            int n3 = object.getSymbol();
            if (bl2) {
                n3 = PatternType.capitalized(n3);
            }
            if (n3 != n2) continue;
            return object;
        }
        for (ChronoExtension chronoExtension : chronology.getExtensions()) {
            for (ChronoElement<?> chronoElement : chronoExtension.getElements(locale, Attributes.empty())) {
                int n4 = chronoElement.getSymbol();
                if (bl2) {
                    n4 = PatternType.capitalized(n4);
                }
                if (n4 != n2) continue;
                return chronoElement;
            }
        }
        return null;
    }

    private Map<ChronoElement<?>, ChronoElement<?>> dynamic(ChronoFormatter.Builder<?> builder, char c2, int n2, Locale locale) {
        boolean bl2 = c2 >= 'A' && c2 <= 'Z';
        Chronology<?> chronology = PatternType.getEffectiveChronology(builder);
        ChronoElement<?> chronoElement = PatternType.findDynamicElement(chronology, locale, c2);
        if (chronoElement == null) {
            throw new IllegalArgumentException("Cannot resolve symbol: " + c2);
        }
        if (bl2 && (chronoElement instanceof TextElement || Enum.class.isAssignableFrom(chronoElement.getType()))) {
            switch (n2) {
                case 1: {
                    builder.startSection(Attributes.TEXT_WIDTH, TextWidth.NARROW);
                    break;
                }
                case 2: {
                    builder.startSection(Attributes.TEXT_WIDTH, TextWidth.SHORT);
                    break;
                }
                case 3: {
                    builder.startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED);
                    break;
                }
                case 4: {
                    builder.startSection(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal count of symbols: " + c2);
                }
            }
            if (chronoElement instanceof TextElement) {
                TextElement textElement = (TextElement)PatternType.cast(chronoElement);
                builder.addText(textElement);
            } else {
                PatternType.addEnumElementAsText(builder, (ChronoElement)PatternType.cast(chronoElement));
            }
            builder.endSection();
        } else if (chronoElement.getType() == Integer.class) {
            ChronoElement chronoElement2 = (ChronoElement)PatternType.cast(chronoElement);
            builder.addInteger(chronoElement2, n2, 9);
        } else if (Enum.class.isAssignableFrom(chronoElement.getType())) {
            PatternType.addEnumElementAsInteger(builder, (ChronoElement)PatternType.cast(chronoElement), n2);
        } else {
            throw new IllegalArgumentException("Can only handle enum or integer elements in a numerical way: " + chronoElement);
        }
        return Collections.emptyMap();
    }

    private static Set<ChronoElement<?>> getElements(Chronology<?> chronology, char c2, Locale locale) {
        if (c2 == 'w' || c2 == 'W' || c2 == 'e' || c2 == 'c') {
            for (ChronoExtension chronoExtension : chronology.getExtensions()) {
                for (ChronoElement<?> chronoElement : chronoExtension.getElements(locale, Attributes.empty())) {
                    if ((c2 != 'e' && c2 != 'c' || !chronoElement.name().equals("LOCAL_DAY_OF_WEEK")) && (c2 != 'w' || !chronoElement.name().equals("WEEK_OF_YEAR")) && (c2 != 'W' || !chronoElement.name().equals("WEEK_OF_MONTH"))) continue;
                    return Collections.singleton(chronoElement);
                }
            }
            return Collections.emptySet();
        }
        return chronology.getRegisteredElements();
    }

    private static ChronoElement<?> find(Set<ChronoElement<?>> set, char c2, String string) {
        char c3 = c2 == 'L' ? (char)'M' : (c2 == 'c' ? (char)'e' : (char)c2);
        for (ChronoElement<?> chronoElement : set) {
            if (!chronoElement.isDateElement() || chronoElement.getSymbol() != c3 || c3 == 'M' && chronoElement.name().equals("MONTH_AS_NUMBER")) continue;
            return chronoElement;
        }
        if (c2 == 'y' && string.equals("net.time4j.PlainDate")) {
            return PlainDate.YEAR;
        }
        throw new IllegalArgumentException("Cannot find any chronological date element for symbol " + c2 + " in \"" + string + "\".");
    }

    private static <V extends Enum<V>> void addMonth(ChronoFormatter.Builder<?> builder, int n2, TextElement<?> textElement) {
        switch (n2) {
            case 1: 
            case 2: {
                if (Enum.class.isAssignableFrom(textElement.getType())) {
                    ChronoElement chronoElement = (ChronoElement)PatternType.cast(textElement);
                    if (n2 == 1) {
                        builder.addNumerical(chronoElement, 1, 2);
                        break;
                    }
                    builder.addFixedNumerical(chronoElement, 2);
                    break;
                }
                builder.startSection(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS, n2);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            case 3: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            case 4: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            case 5: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.NARROW);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters for month: " + n2);
            }
        }
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }
}

