/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.LiteralProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;

final class DecimalProcessor
implements FormatProcessor<BigDecimal> {
    private final FormatProcessor<Void> decimalSeparator;
    private final ChronoElement<BigDecimal> element;
    private final int precision;
    private final int scale;
    private final char zeroDigit;
    private final Leniency lenientMode;
    private final int protectedLength;

    DecimalProcessor(ChronoElement<BigDecimal> chronoElement, int n2, int n3) {
        this.decimalSeparator = new LiteralProcessor(Attributes.DECIMAL_SEPARATOR);
        this.element = chronoElement;
        this.precision = n2;
        this.scale = n3;
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        if (n2 < 2) {
            throw new IllegalArgumentException("Precision must be >= 2: " + n2);
        }
        if (n3 >= n2) {
            throw new IllegalArgumentException("Precision must be bigger than scale: " + n2 + "," + n3);
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("Scale must be bigger than zero.");
        }
        this.zeroDigit = (char)48;
        this.lenientMode = Leniency.SMART;
        this.protectedLength = 0;
    }

    private DecimalProcessor(FormatProcessor<Void> formatProcessor, ChronoElement<BigDecimal> chronoElement, int n2, int n3, char c2, Leniency leniency, int n4) {
        this.decimalSeparator = formatProcessor;
        this.element = chronoElement;
        this.precision = n2;
        this.scale = n3;
        this.zeroDigit = c2;
        this.lenientMode = leniency;
        this.protectedLength = n4;
    }

    @Override
    public int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl2) throws IOException {
        int n2;
        int n3;
        int n4;
        BigDecimal bigDecimal = chronoDisplay.get(this.element).setScale(this.scale, RoundingMode.FLOOR);
        String string = bigDecimal.toPlainString();
        int n5 = 0;
        int n6 = 0;
        int n7 = -1;
        int n8 = string.length();
        for (n4 = 0; n4 < n8; ++n4) {
            char c2 = string.charAt(n4);
            if (c2 == '.') {
                n7 = n4;
                continue;
            }
            if (n7 >= 0) {
                ++n6;
                continue;
            }
            ++n5;
        }
        n4 = this.precision - this.scale - n5;
        if (n4 < 0) {
            throw new IllegalArgumentException("Integer part of element value exceeds fixed format width: " + string);
        }
        StringBuilder stringBuilder = new StringBuilder(this.precision + 1);
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuilder.append('0');
        }
        for (n3 = 0; n3 < n5; ++n3) {
            stringBuilder.append(string.charAt(n3));
        }
        this.decimalSeparator.print(chronoDisplay, stringBuilder, attributeQuery, set, bl2);
        for (n3 = 0; n3 < n6; ++n3) {
            stringBuilder.append(string.charAt(n5 + 1 + n3));
        }
        for (n3 = 0; n3 < this.scale - n6; ++n3) {
            stringBuilder.append('0');
        }
        string = stringBuilder.toString();
        n3 = bl2 ? this.zeroDigit : attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue();
        if (n3 != 48) {
            n2 = n3 - 48;
            char[] cArray = string.toCharArray();
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                char c3 = cArray[i2];
                if (c3 < '0' || c3 > '9') continue;
                cArray[i2] = (char)(c3 + n2);
            }
            string = new String(cArray);
        }
        n2 = -1;
        int n9 = string.length();
        if (appendable instanceof CharSequence) {
            n2 = ((CharSequence)((Object)appendable)).length();
        }
        appendable.append(string);
        if (n2 != -1 && n9 > 0 && set != null) {
            set.add(new ElementPosition(this.element, n2, n2 + n9));
        }
        return n9;
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl2) {
        int n2;
        Leniency leniency;
        int n3;
        int n4;
        int n5 = charSequence.length();
        int n6 = n4 = parseLog.getPosition();
        int n7 = n3 = bl2 ? this.protectedLength : attributeQuery.get(Attributes.PROTECTED_CHARACTERS, 0);
        if (n3 > 0) {
            n5 -= n3;
        }
        if (n6 >= n5) {
            parseLog.setError(n6, "Missing digits for: " + this.element.name());
            parseLog.setWarning();
            return;
        }
        char c2 = bl2 ? this.zeroDigit : attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue();
        int n8 = Math.min(n5, n6 + 18);
        long l2 = 0L;
        boolean bl3 = true;
        int n9 = 0;
        while (n6 + n9 < n8) {
            int n10 = charSequence.charAt(n6 + n9) - c2;
            if (n10 >= 0 && n10 <= 9) {
                l2 = l2 * 10L + (long)n10;
                ++n9;
                bl3 = false;
                continue;
            }
            if (!bl3) break;
            parseLog.setError(n4, "Digit expected.");
            return;
        }
        Leniency leniency2 = leniency = bl2 ? this.lenientMode : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
        if (!leniency.isLax() && n9 != this.precision - this.scale) {
            parseLog.setError(n6, "Integer part of decimal element does not match expected width.");
            return;
        }
        parseLog.setPosition(n6 += n9);
        this.decimalSeparator.parse(charSequence, parseLog, attributeQuery, null, bl2);
        if (parseLog.isError()) {
            return;
        }
        n8 = Math.min(n5, ++n6 + 18);
        int n11 = 0;
        long l3 = 0L;
        while (n6 + n11 < n8 && (n2 = charSequence.charAt(n6 + n11) - c2) >= 0 && n2 <= 9) {
            l3 = l3 * 10L + (long)n2;
            ++n11;
        }
        if (n11 == 0) {
            parseLog.setError(n6, "Fraction part expected.");
            return;
        }
        if (leniency.isStrict() && n11 != this.scale) {
            parseLog.setError(n6, "Fraction part of decimal element does not match expected width.");
            return;
        }
        parseLog.setPosition(n6 += n11);
        BigDecimal bigDecimal = new BigDecimal(l2);
        BigDecimal bigDecimal2 = new BigDecimal(BigInteger.valueOf(l3), n11);
        BigDecimal bigDecimal3 = bigDecimal.add(bigDecimal2).stripTrailingZeros();
        parsedEntity.put(this.element, bigDecimal3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DecimalProcessor) {
            DecimalProcessor decimalProcessor = (DecimalProcessor)object;
            return this.element.equals(decimalProcessor.element) && this.precision == decimalProcessor.precision && this.scale == decimalProcessor.scale;
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.element.hashCode() + 31 * (this.scale + this.precision * 10);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(", precision=");
        stringBuilder.append(this.precision);
        stringBuilder.append(", scale=");
        stringBuilder.append(this.scale);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<BigDecimal> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<BigDecimal> withElement(ChronoElement<BigDecimal> chronoElement) {
        if (this.element == chronoElement) {
            return this;
        }
        return new DecimalProcessor(chronoElement, this.precision, this.scale);
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public FormatProcessor<BigDecimal> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n2) {
        return new DecimalProcessor(this.decimalSeparator, this.element, this.precision, this.scale, attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue(), attributeQuery.get(Attributes.LENIENCY, Leniency.SMART), attributeQuery.get(Attributes.PROTECTED_CHARACTERS, 0));
    }
}

