/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.time4j.format.NumberType;
import net.time4j.format.PluralCategory;
import net.time4j.format.PluralProvider;
import net.time4j.format.PluralRules;
import net.time4j.format.internal.FormatUtils;

final class DefaultPluralProviderSPI
implements PluralProvider {
    private static final Map<String, PluralRules> CARDINAL_MAP = new HashMap<String, PluralRules>(140);
    private static final PluralRules STD_CARDINALS = new StdCardinalRules(0);
    private static final Map<String, PluralRules> ORDINAL_MAP;
    private static final PluralRules STD_ORDINALS;

    @Override
    public PluralRules load(Locale locale, NumberType numberType) {
        PluralRules pluralRules;
        Map<String, PluralRules> map;
        switch (numberType) {
            case CARDINALS: {
                map = CARDINAL_MAP;
                pluralRules = STD_CARDINALS;
                break;
            }
            case ORDINALS: {
                map = ORDINAL_MAP;
                pluralRules = STD_ORDINALS;
                break;
            }
            default: {
                throw new UnsupportedOperationException(numberType.name());
            }
        }
        PluralRules pluralRules2 = null;
        String string = FormatUtils.getRegion(locale);
        if (!string.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(locale.getLanguage());
            stringBuilder.append('_');
            stringBuilder.append(string);
            pluralRules2 = map.get(stringBuilder.toString());
        }
        if (pluralRules2 == null) {
            pluralRules2 = map.get(locale.getLanguage());
        }
        if (pluralRules2 == null) {
            return pluralRules;
        }
        return pluralRules2;
    }

    private static void fillC(Map<String, PluralRules> map, String string, int n2) {
        for (String string2 : string.split(" ")) {
            map.put(string2, new StdCardinalRules(n2));
        }
    }

    private static void fillO(Map<String, PluralRules> map, String string, int n2) {
        for (String string2 : string.split(" ")) {
            map.put(string2, new StdOrdinalRules(n2));
        }
    }

    static {
        HashMap<String, PluralRules> hashMap = new HashMap<String, PluralRules>();
        DefaultPluralProviderSPI.fillC(hashMap, "bm bo dz id ig ii in ja jbo jv jw kde kea km ko lkt", -1);
        DefaultPluralProviderSPI.fillC(hashMap, "lo ms my nqo osa root sah ses sg su th to vi wo yo zh", -1);
        DefaultPluralProviderSPI.fillC(hashMap, "pt_PT", 0);
        DefaultPluralProviderSPI.fillC(hashMap, "am as bn doi fa gu hi kn pcm zu", 1);
        DefaultPluralProviderSPI.fillC(hashMap, "ff fr hy kab pt", 1);
        DefaultPluralProviderSPI.fillC(hashMap, "si", 1);
        DefaultPluralProviderSPI.fillC(hashMap, "ak bh bho guw ln mg nso pa ti wa", 1);
        DefaultPluralProviderSPI.fillC(hashMap, "tzm", 2);
        DefaultPluralProviderSPI.fillC(hashMap, "is", 3);
        DefaultPluralProviderSPI.fillC(hashMap, "mk", 4);
        DefaultPluralProviderSPI.fillC(hashMap, "ceb fil tl", 5);
        DefaultPluralProviderSPI.fillC(hashMap, "lv prg", 6);
        DefaultPluralProviderSPI.fillC(hashMap, "lag ksh", 7);
        DefaultPluralProviderSPI.fillC(hashMap, "iu naq sat se sma smi smj smn sms", 8);
        DefaultPluralProviderSPI.fillC(hashMap, "shi", 9);
        DefaultPluralProviderSPI.fillC(hashMap, "mo ro", 10);
        DefaultPluralProviderSPI.fillC(hashMap, "bs hr sh sr", 11);
        DefaultPluralProviderSPI.fillC(hashMap, "gd", 12);
        DefaultPluralProviderSPI.fillC(hashMap, "sl", 13);
        DefaultPluralProviderSPI.fillC(hashMap, "he iw", 14);
        DefaultPluralProviderSPI.fillC(hashMap, "cs sk", 15);
        DefaultPluralProviderSPI.fillC(hashMap, "pl", 16);
        DefaultPluralProviderSPI.fillC(hashMap, "be", 17);
        DefaultPluralProviderSPI.fillC(hashMap, "lt", 18);
        DefaultPluralProviderSPI.fillC(hashMap, "mt", 19);
        DefaultPluralProviderSPI.fillC(hashMap, "ru uk", 17);
        DefaultPluralProviderSPI.fillC(hashMap, "br", 20);
        DefaultPluralProviderSPI.fillC(hashMap, "ga", 21);
        DefaultPluralProviderSPI.fillC(hashMap, "gv", 22);
        DefaultPluralProviderSPI.fillC(hashMap, "ar", 23);
        DefaultPluralProviderSPI.fillC(hashMap, "cy", 24);
        DefaultPluralProviderSPI.fillC(hashMap, "dsb hsb", 25);
        DefaultPluralProviderSPI.fillC(hashMap, "kw", 26);
        CARDINAL_MAP.putAll(hashMap);
        ORDINAL_MAP = new HashMap<String, PluralRules>(140);
        STD_ORDINALS = new StdOrdinalRules(0);
        hashMap = new HashMap();
        DefaultPluralProviderSPI.fillO(hashMap, "sv", 1);
        DefaultPluralProviderSPI.fillO(hashMap, "fil fr ga hy lo mo ms ro tl vi", 2);
        DefaultPluralProviderSPI.fillO(hashMap, "hu", 3);
        DefaultPluralProviderSPI.fillO(hashMap, "ne", 4);
        DefaultPluralProviderSPI.fillO(hashMap, "kk", 5);
        DefaultPluralProviderSPI.fillO(hashMap, "it sc scn", 6);
        DefaultPluralProviderSPI.fillO(hashMap, "ka", 7);
        DefaultPluralProviderSPI.fillO(hashMap, "sq", 8);
        DefaultPluralProviderSPI.fillO(hashMap, "en", 9);
        DefaultPluralProviderSPI.fillO(hashMap, "mr", 10);
        DefaultPluralProviderSPI.fillO(hashMap, "ca", 11);
        DefaultPluralProviderSPI.fillO(hashMap, "mk", 12);
        DefaultPluralProviderSPI.fillO(hashMap, "az", 13);
        DefaultPluralProviderSPI.fillO(hashMap, "gu hi", 14);
        DefaultPluralProviderSPI.fillO(hashMap, "as bn", 15);
        DefaultPluralProviderSPI.fillO(hashMap, "cy", 16);
        DefaultPluralProviderSPI.fillO(hashMap, "be", 17);
        DefaultPluralProviderSPI.fillO(hashMap, "uk", 18);
        DefaultPluralProviderSPI.fillO(hashMap, "tk", 19);
        DefaultPluralProviderSPI.fillO(hashMap, "or", 20);
        DefaultPluralProviderSPI.fillO(hashMap, "gd", 21);
        DefaultPluralProviderSPI.fillO(hashMap, "kw", 22);
        ORDINAL_MAP.putAll(hashMap);
    }

    private static class StdCardinalRules
    extends PluralRules {
        private final int id;

        private StdCardinalRules(int n2) {
            this.id = n2;
        }

        @Override
        public PluralCategory getCategory(long l2) {
            switch (this.id) {
                case 0: {
                    return l2 == 1L ? PluralCategory.ONE : PluralCategory.OTHER;
                }
                case 1: {
                    return l2 == 0L || l2 == 1L ? PluralCategory.ONE : PluralCategory.OTHER;
                }
                case 2: {
                    if (l2 == 0L || l2 == 1L || l2 >= 11L && l2 <= 99L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 3: {
                    if (l2 % 10L == 1L && l2 % 100L != 11L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 4: {
                    return l2 % 10L == 1L && l2 % 100L != 11L ? PluralCategory.ONE : PluralCategory.OTHER;
                }
                case 5: {
                    if (l2 >= 1L && l2 <= 3L) {
                        return PluralCategory.ONE;
                    }
                    long l3 = l2 % 10L;
                    if (l3 == 4L || l3 == 6L || l3 == 9L) {
                        return PluralCategory.OTHER;
                    }
                    return PluralCategory.ONE;
                }
                case 6: {
                    if (l2 % 10L == 0L) {
                        return PluralCategory.ZERO;
                    }
                    long l4 = l2 % 100L;
                    if (l4 >= 11L && l4 <= 19L) {
                        return PluralCategory.ZERO;
                    }
                    if (l2 % 10L == 1L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 7: {
                    if (l2 == 0L) {
                        return PluralCategory.ZERO;
                    }
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 8: {
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 2L) {
                        return PluralCategory.TWO;
                    }
                    return PluralCategory.OTHER;
                }
                case 9: {
                    if (l2 == 0L || l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 >= 2L && l2 <= 10L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 10: {
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 0L) {
                        return PluralCategory.FEW;
                    }
                    long l5 = l2 % 100L;
                    if (l5 >= 2L && l5 <= 19L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 11: {
                    long l6 = l2 % 100L;
                    if (l2 % 10L == 1L && l6 != 11L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 % 10L >= 2L && l2 % 10L <= 4L && l6 != 12L && l6 != 13L && l6 != 14L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 12: {
                    if (l2 == 1L || l2 == 11L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 2L || l2 == 12L) {
                        return PluralCategory.TWO;
                    }
                    if (l2 >= 3L && l2 <= 10L || l2 >= 13L && l2 <= 19L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 13: {
                    long l7 = l2 % 100L;
                    if (l7 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l7 == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l7 == 3L || l7 == 4L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 14: {
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l2 >= 11L && l2 % 10L == 0L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 15: {
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 >= 2L && l2 <= 4L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 16: {
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    long l8 = l2 % 10L;
                    long l9 = l2 % 100L;
                    if (l8 >= 2L && l8 <= 4L && l9 != 12L && l9 != 13L && l9 != 14L) {
                        return PluralCategory.FEW;
                    }
                    if (l8 >= 0L && l8 <= 1L || l8 >= 5L && l8 <= 9L || l9 >= 12L && l9 <= 14L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 17: {
                    long l10 = l2 % 10L;
                    long l11 = l2 % 100L;
                    if (l10 == 1L && l11 != 11L) {
                        return PluralCategory.ONE;
                    }
                    if (l10 >= 2L && l10 <= 4L && l11 != 12L && l11 != 13L && l11 != 14L) {
                        return PluralCategory.FEW;
                    }
                    if (l10 == 0L || l10 >= 5L && l10 <= 9L || l11 >= 11L && l11 <= 14L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 18: {
                    long l12 = l2 % 10L;
                    long l13 = l2 % 100L;
                    if (l12 == 1L && (l13 < 11L || l13 > 19L)) {
                        return PluralCategory.ONE;
                    }
                    if (l12 >= 2L && l12 <= 9L && (l13 < 11L || l13 > 19L)) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 19: {
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    long l14 = l2 % 100L;
                    if (l2 == 0L || l14 >= 2L && l14 <= 10L) {
                        return PluralCategory.FEW;
                    }
                    if (l14 >= 11L && l14 <= 19L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 20: {
                    long l15 = l2 % 10L;
                    long l16 = l2 % 100L;
                    if (l15 == 1L && l16 != 11L && l16 != 71L && l16 != 91L) {
                        return PluralCategory.ONE;
                    }
                    if (l15 == 2L && l16 != 12L && l16 != 72L && l16 != 92L) {
                        return PluralCategory.TWO;
                    }
                    if (!(l15 != 3L && l15 != 4L && l15 != 9L || l16 >= 10L && l16 <= 19L || l16 >= 70L && l16 <= 79L || l16 >= 90L && l16 <= 99L)) {
                        return PluralCategory.FEW;
                    }
                    if (l2 != 0L && l2 % 1000000L == 0L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 21: {
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l2 >= 3L && l2 <= 6L) {
                        return PluralCategory.FEW;
                    }
                    if (l2 >= 7L && l2 <= 10L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 22: {
                    long l17 = l2 % 10L;
                    long l18 = l2 % 100L;
                    if (l17 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l17 == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l18 == 0L || l18 == 20L || l18 == 40L || l18 == 60L || l18 == 80L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 23: {
                    if (l2 == 0L) {
                        return PluralCategory.ZERO;
                    }
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 2L) {
                        return PluralCategory.TWO;
                    }
                    long l19 = l2 % 100L;
                    if (l19 >= 3L && l19 <= 10L) {
                        return PluralCategory.FEW;
                    }
                    if (l19 >= 11L && l19 <= 99L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 24: {
                    if (l2 == 0L) {
                        return PluralCategory.ZERO;
                    }
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l2 == 3L) {
                        return PluralCategory.FEW;
                    }
                    if (l2 == 6L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 25: {
                    long l20 = l2 % 100L;
                    if (l20 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l20 == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l20 == 3L || l20 == 4L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 26: {
                    if (l2 == 0L) {
                        return PluralCategory.ZERO;
                    }
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    long l21 = l2 % 100L;
                    if (l21 == 2L || l21 == 22L || l21 == 42L || l21 == 62L || l21 == 82L) {
                        return PluralCategory.TWO;
                    }
                    if (l21 == 3L || l21 == 23L || l21 == 43L || l21 == 63L || l21 == 83L) {
                        return PluralCategory.FEW;
                    }
                    if (l21 == 1L || l21 == 21L || l21 == 41L || l21 == 61L || l21 == 81L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
            }
            return PluralCategory.OTHER;
        }

        @Override
        public NumberType getNumberType() {
            return NumberType.CARDINALS;
        }
    }

    private static class StdOrdinalRules
    extends PluralRules {
        private final int id;

        private StdOrdinalRules(int n2) {
            this.id = n2;
        }

        @Override
        public PluralCategory getCategory(long l2) {
            switch (this.id) {
                case 0: {
                    return PluralCategory.OTHER;
                }
                case 1: {
                    long l3 = l2 % 10L;
                    long l4 = l2 % 100L;
                    if ((l3 == 1L || l3 == 2L) && l4 != 11L && l4 != 12L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 2: {
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 3: {
                    if (l2 == 1L || l2 == 5L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 4: {
                    if (l2 >= 1L && l2 <= 4L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 5: {
                    long l5 = l2 % 10L;
                    if (l5 == 6L || l5 == 9L || l5 == 0L && l2 != 0L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 6: {
                    if (l2 == 8L || l2 == 11L || l2 == 80L || l2 == 800L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 7: {
                    long l6 = l2 % 100L;
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 0L || l6 >= 2L && l6 <= 20L || l6 == 40L || l6 == 60L || l6 == 80L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 8: {
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 % 10L == 4L && l2 % 100L != 14L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 9: {
                    long l7 = l2 % 10L;
                    long l8 = l2 % 100L;
                    if (l7 == 1L && l8 != 11L) {
                        return PluralCategory.ONE;
                    }
                    if (l7 == 2L && l8 != 12L) {
                        return PluralCategory.TWO;
                    }
                    if (l7 == 3L && l8 != 13L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 10: {
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 2L || l2 == 3L) {
                        return PluralCategory.TWO;
                    }
                    if (l2 == 4L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 11: {
                    if (l2 == 1L || l2 == 3L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l2 == 4L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 12: {
                    long l9 = l2 % 10L;
                    long l10 = l2 % 100L;
                    if (l9 == 1L && l10 != 11L) {
                        return PluralCategory.ONE;
                    }
                    if (l9 == 2L && l10 != 12L) {
                        return PluralCategory.TWO;
                    }
                    if ((l9 == 7L || l9 == 8L) && l10 != 17L && l10 != 18L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 13: {
                    long l11 = l2 % 10L;
                    long l12 = l2 % 100L;
                    long l13 = l2 % 1000L;
                    if (l11 == 1L || l11 == 2L || l11 == 5L || l11 == 7L || l11 == 8L || l12 == 20L || l12 == 50L || l12 == 70L || l12 == 80L) {
                        return PluralCategory.ONE;
                    }
                    if (l11 == 3L || l11 == 4L || l13 == 100L || l13 == 200L || l13 == 300L || l13 == 400L || l13 == 500L || l13 == 600L || l13 == 700L || l13 == 800L || l13 == 900L) {
                        return PluralCategory.FEW;
                    }
                    if (l2 == 0L || l11 == 6L || l12 == 40L || l12 == 60L || l12 == 90L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 14: {
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 2L || l2 == 3L) {
                        return PluralCategory.TWO;
                    }
                    if (l2 == 4L) {
                        return PluralCategory.FEW;
                    }
                    if (l2 == 6L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 15: {
                    if (l2 == 1L || l2 == 5L || l2 >= 7L && l2 <= 10L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 2L || l2 == 3L) {
                        return PluralCategory.TWO;
                    }
                    if (l2 == 4L) {
                        return PluralCategory.FEW;
                    }
                    if (l2 == 6L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 16: {
                    if (l2 == 0L || l2 >= 7L && l2 <= 9L) {
                        return PluralCategory.ZERO;
                    }
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l2 == 3L || l2 == 4L) {
                        return PluralCategory.FEW;
                    }
                    if (l2 == 5L || l2 == 6L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 17: {
                    long l14 = l2 % 10L;
                    long l15 = l2 % 100L;
                    if ((l14 == 2L || l14 == 3L) && l15 != 12L && l15 != 13L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 18: {
                    long l16 = l2 % 10L;
                    long l17 = l2 % 100L;
                    if (l16 == 3L && l17 != 13L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 19: {
                    long l18 = l2 % 10L;
                    if (l18 == 6L || l18 == 9L || l2 == 10L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 20: {
                    if (l2 == 1L || l2 == 5L || l2 == 7L || l2 == 8L || l2 == 9L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 2L || l2 == 3L) {
                        return PluralCategory.TWO;
                    }
                    if (l2 == 4L) {
                        return PluralCategory.FEW;
                    }
                    if (l2 == 6L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 21: {
                    if (l2 == 1L || l2 == 11L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 2L || l2 == 12L) {
                        return PluralCategory.TWO;
                    }
                    if (l2 == 3L || l2 == 13L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 22: {
                    long l19 = l2 % 100L;
                    if (l19 >= 1L && l19 <= 4L || l19 >= 21L && l19 <= 24L || l19 >= 41L && l19 <= 44L || l19 >= 61L && l19 <= 64L || l19 >= 81L && l19 <= 84L) {
                        return PluralCategory.ONE;
                    }
                    if (l19 == 5L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
            }
            return PluralCategory.OTHER;
        }

        @Override
        public NumberType getNumberType() {
            return NumberType.ORDINALS;
        }
    }
}

