/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.io.Serializable;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.VariantSource;

public abstract class CalendarVariant<D extends CalendarVariant<D>>
extends ChronoEntity<D>
implements CalendarDate,
VariantSource,
Comparable<D>,
Serializable {
    public D withVariant(String string) {
        if (string.equals(this.getVariant())) {
            return (D)((CalendarVariant)this.getContext());
        }
        return (D)this.transform(this.getChronology().getChronoType(), string);
    }

    public D withVariant(VariantSource variantSource) {
        return this.withVariant(variantSource.getVariant());
    }

    @Override
    public int compareTo(D d2) {
        long l2;
        long l3 = this.getDaysSinceEpochUTC();
        if (l3 < (l2 = ((CalendarVariant)d2).getDaysSinceEpochUTC())) {
            return -1;
        }
        if (l3 > l2) {
            return 1;
        }
        return this.getVariant().compareTo(d2.getVariant());
    }

    @Override
    public boolean isAfter(CalendarDate calendarDate) {
        long l2;
        long l3 = this.getDaysSinceEpochUTC();
        return l3 > (l2 = calendarDate.getDaysSinceEpochUTC());
    }

    @Override
    public boolean isBefore(CalendarDate calendarDate) {
        long l2;
        long l3 = this.getDaysSinceEpochUTC();
        return l3 < (l2 = calendarDate.getDaysSinceEpochUTC());
    }

    @Override
    public boolean isSimultaneous(CalendarDate calendarDate) {
        long l2;
        long l3 = this.getDaysSinceEpochUTC();
        return l3 == (l2 = calendarDate.getDaysSinceEpochUTC());
    }

    public D plus(CalendarDays calendarDays) {
        long l2 = Math.addExact(this.getDaysSinceEpochUTC(), calendarDays.getAmount());
        try {
            return (D)((CalendarVariant)this.getCalendarSystem().transform(l2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArithmeticException arithmeticException = new ArithmeticException("Out of range: " + l2);
            arithmeticException.initCause(illegalArgumentException);
            throw arithmeticException;
        }
    }

    public D minus(CalendarDays calendarDays) {
        return this.plus(CalendarDays.of(Math.negateExact(calendarDays.getAmount())));
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    @Override
    public long getDaysSinceEpochUTC() {
        return this.getCalendarSystem().transform((CalendarVariant)this.getContext());
    }

    @Override
    protected abstract CalendarFamily<D> getChronology();

    protected CalendarSystem<D> getCalendarSystem() {
        return ((CalendarFamily)this.getChronology()).getCalendarSystem(this.getVariant());
    }

    @Override
    <V> ElementRule<D, V> getRule(ChronoElement<V> chronoElement) {
        if (chronoElement instanceof EpochDays) {
            EpochDays epochDays = (EpochDays)EpochDays.class.cast(chronoElement);
            return epochDays.derive(this.getCalendarSystem());
        }
        return super.getRule(chronoElement);
    }
}

