/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.time4j.engine.AbstractDuration;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimeMetric;
import net.time4j.engine.TimePoint;
import net.time4j.engine.TimeSpan;

public abstract class AbstractMetric<U extends ChronoUnit, P extends AbstractDuration<U>>
implements TimeMetric<U, P>,
Comparator<U> {
    private static final int MIO = 1000000;
    private static final double LENGTH_OF_FORTNIGHT = 1209600.0;
    private final List<U> sortedUnits;
    private final boolean normalizing;

    @SafeVarargs
    protected AbstractMetric(boolean bl2, U ... UArray) {
        this(Arrays.asList(UArray), bl2);
    }

    protected AbstractMetric(boolean bl2, Collection<? extends U> collection) {
        this(new ArrayList<U>(collection), bl2);
    }

    private AbstractMetric(List<U> list, boolean bl2) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Missing units.");
        }
        list.sort(this);
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ChronoUnit chronoUnit = (ChronoUnit)list.get(i2);
            for (int i3 = i2 + 1; i3 < n2; ++i3) {
                if (!chronoUnit.equals(list.get(i3))) continue;
                throw new IllegalArgumentException("Duplicate unit: " + chronoUnit);
            }
        }
        this.sortedUnits = Collections.unmodifiableList(list);
        this.normalizing = bl2;
    }

    @Override
    public int compare(U u2, U u3) {
        return Double.compare(u3.getLength(), u2.getLength());
    }

    @Override
    public <T extends TimePoint<? super U, T>> P between(T t2, T t3) {
        return this.between(t2, t3, -1);
    }

    private <T extends TimePoint<? super U, T>> P between(T t2, T t3, int n2) {
        Object object;
        if (t3.equals(t2)) {
            return this.createEmptyTimeSpan();
        }
        T t4 = t2;
        T t5 = t3;
        boolean bl2 = false;
        if (t4.compareTo(t5) > 0) {
            object = t4;
            t4 = t3;
            t5 = object;
            bl2 = true;
        }
        object = new ArrayList(10);
        Chronology chronology = t2.getChronology();
        int n3 = this.sortedUnits.size();
        block0: for (int i2 = 0; i2 < n3; ++i2) {
            ChronoUnit chronoUnit;
            int n4;
            ChronoUnit chronoUnit2 = (ChronoUnit)this.sortedUnits.get(i2);
            if (this.getLength((TimeAxis<? super U, T>)chronology, (U)chronoUnit2) < 1.0 && i2 < n3 - 1) continue;
            long l2 = 1L;
            for (n4 = i2 + 1; n4 < n3 && (l2 *= this.getFactor((TimeAxis<? super U, T>)chronology, (U)chronoUnit2, (U)(chronoUnit = (ChronoUnit)this.sortedUnits.get(n4)))) < 1000000L && ((TimeAxis)chronology).isConvertible(chronoUnit2, chronoUnit); ++n4) {
                chronoUnit2 = chronoUnit;
            }
            i2 = n4 - 1;
            long l3 = t4.until(t5, (ChronoUnit)chronoUnit2);
            if (l3 < 0L) {
                throw new IllegalStateException("Implementation error: Cannot compute timespan due to illegal negative timespan amounts.");
            }
            while (l3 > 0L) {
                T t6 = t4.plus(l3, (ChronoUnit)chronoUnit2);
                if (i2 > n2 || i2 == n3 - 1 || ((TimePoint)((TimePoint)t6).minus(l3, (ChronoUnit)chronoUnit2)).equals(t4)) {
                    t4 = t6;
                    object.add(this.resolve(TimeSpan.Item.of(l3, chronoUnit2)));
                    continue block0;
                }
                --l3;
            }
        }
        if (this.normalizing) {
            this.normalize((TimeAxis<? super U, T>)chronology, this.sortedUnits, (List<TimeSpan.Item<U>>)object);
        }
        return this.createTimeSpan((List<TimeSpan.Item<U>>)object, bl2);
    }

    @Override
    public TimeMetric<U, P> reversible() {
        return new ReversalMetric(this);
    }

    protected abstract P createEmptyTimeSpan();

    protected abstract P createTimeSpan(List<TimeSpan.Item<U>> var1, boolean var2);

    protected TimeSpan.Item<U> resolve(TimeSpan.Item<U> item) {
        return item;
    }

    private <T extends TimePoint<? super U, T>> void normalize(TimeAxis<? super U, T> timeAxis, List<U> list, List<TimeSpan.Item<U>> list2) {
        Comparator<? super U> comparator = timeAxis.unitComparator();
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            long l2;
            long l3;
            TimeSpan.Item<ChronoUnit> item;
            if (i2 <= 0) continue;
            ChronoUnit chronoUnit = (ChronoUnit)list.get(i2);
            ChronoUnit chronoUnit2 = (ChronoUnit)list.get(i2 - 1);
            long l4 = this.getFactor(timeAxis, chronoUnit2, chronoUnit);
            if (l4 >= 1000000L || !timeAxis.isConvertible(chronoUnit2, chronoUnit) || (item = AbstractMetric.getItem(list2, chronoUnit)) == null || (l3 = (l2 = item.getAmount()) / l4) <= 0L) continue;
            long l5 = l2 % l4;
            if (l5 == 0L) {
                AbstractMetric.removeItem(list2, chronoUnit);
            } else {
                AbstractMetric.putItem(list2, comparator, l5, chronoUnit);
            }
            TimeSpan.Item<ChronoUnit> item2 = AbstractMetric.getItem(list2, chronoUnit2);
            if (item2 == null) {
                AbstractMetric.putItem(list2, comparator, l3, chronoUnit2);
                continue;
            }
            AbstractMetric.putItem(list2, comparator, Math.addExact(item2.getAmount(), l3), chronoUnit2);
        }
    }

    private static <U> TimeSpan.Item<U> getItem(List<TimeSpan.Item<U>> list, U u2) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TimeSpan.Item<U> item = list.get(i2);
            if (!item.getUnit().equals(u2)) continue;
            return item;
        }
        return null;
    }

    private static <U> void putItem(List<TimeSpan.Item<U>> list, Comparator<? super U> comparator, long l2, U u2) {
        TimeSpan.Item<U> item = TimeSpan.Item.of(l2, u2);
        int n2 = 0;
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            U u3 = list.get(i2).getUnit();
            if (u3.equals(u2)) {
                list.set(i2, item);
                return;
            }
            if (n2 != i2 || comparator.compare(u3, u2) >= 0) continue;
            ++n2;
        }
        list.add(n2, item);
    }

    private static <U> void removeItem(List<TimeSpan.Item<U>> list, U u2) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!list.get(i2).getUnit().equals(u2)) continue;
            list.remove(i2);
            return;
        }
    }

    private <T extends TimePoint<? super U, T>> long getFactor(TimeAxis<? super U, T> timeAxis, U u2, U u3) {
        double d2 = this.getLength(timeAxis, u2);
        double d3 = this.getLength(timeAxis, u3);
        return Math.round(d2 / d3);
    }

    private <T extends TimePoint<? super U, T>> double getLength(TimeAxis<? super U, T> timeAxis, U u2) {
        return timeAxis.getLength(u2);
    }

    private static class ReversalMetric<U extends ChronoUnit, P extends AbstractDuration<U>>
    implements TimeMetric<U, P> {
        private final AbstractMetric<U, P> delegate;
        private final int monthIndex;

        private ReversalMetric(AbstractMetric<U, P> abstractMetric) {
            this.delegate = abstractMetric;
            int n2 = -1;
            for (int i2 = ((AbstractMetric)this.delegate).sortedUnits.size() - 1; i2 >= 0; --i2) {
                ChronoUnit chronoUnit = (ChronoUnit)((AbstractMetric)this.delegate).sortedUnits.get(i2);
                if (Double.compare(chronoUnit.getLength(), 1209600.0) <= 0) continue;
                n2 = i2;
                break;
            }
            this.monthIndex = n2;
        }

        @Override
        public <T extends TimePoint<? super U, T>> P between(T t2, T t3) {
            return (P)((AbstractMetric)this.delegate).between(t2, t3, this.monthIndex);
        }

        @Override
        public TimeMetric<U, P> reversible() {
            return this;
        }
    }
}

