/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.service;

import java.io.IOException;
import java.text.ParsePosition;
import java.util.Locale;
import net.time4j.calendar.service.StdDateElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoOperator;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.NumericalElement;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;

public class StdEnumDateElement<V extends Enum<V>, T extends ChronoEntity<T>>
extends StdDateElement<V, T>
implements NumericalElement<V>,
TextElement<V> {
    private static final long serialVersionUID = -2452569351302286113L;
    private final transient Class<V> type;
    private final transient String defaultCalendarType;
    private final transient ChronoOperator<T> decrementor;
    private final transient ChronoOperator<T> incrementor;

    public StdEnumDateElement(String string, Class<T> clazz, Class<V> clazz2, char c2) {
        super(string, clazz, c2, StdEnumDateElement.isWeekdayElement(c2));
        this.type = clazz2;
        this.defaultCalendarType = StdEnumDateElement.extractCalendarType(clazz);
        this.decrementor = null;
        this.incrementor = null;
    }

    public StdEnumDateElement(String string, Class<T> clazz, Class<V> clazz2, char c2, String string2) {
        super(string, clazz, c2, StdEnumDateElement.isWeekdayElement(c2));
        this.type = clazz2;
        this.defaultCalendarType = string2;
        this.decrementor = null;
        this.incrementor = null;
    }

    public StdEnumDateElement(String string, Class<T> clazz, Class<V> clazz2, char c2, ChronoOperator<T> chronoOperator, ChronoOperator<T> chronoOperator2) {
        super(string, clazz, c2, false);
        this.type = clazz2;
        this.defaultCalendarType = StdEnumDateElement.extractCalendarType(clazz);
        this.decrementor = chronoOperator;
        this.incrementor = chronoOperator2;
    }

    @Override
    public Class<V> getType() {
        return this.type;
    }

    @Override
    public V getDefaultMinimum() {
        return (V)((Enum[])this.type.getEnumConstants())[0];
    }

    @Override
    public V getDefaultMaximum() {
        Enum[] enumArray = (Enum[])this.type.getEnumConstants();
        return (V)enumArray[enumArray.length - 1];
    }

    @Override
    public int numerical(V v2) {
        return ((Enum)v2).ordinal() + 1;
    }

    @Override
    public ChronoOperator<T> decremented() {
        if (this.decrementor != null) {
            return this.decrementor;
        }
        return super.decremented();
    }

    @Override
    public ChronoOperator<T> incremented() {
        if (this.incrementor != null) {
            return this.incrementor;
        }
        return super.incremented();
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
        Enum enum_ = (Enum)chronoDisplay.get(this);
        OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
        appendable.append(this.accessor(attributeQuery, outputContext, this.hasLeapMonth(chronoDisplay)).print(enum_));
    }

    @Override
    public V parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
        int n2 = parsePosition.getIndex();
        OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
        V v2 = this.accessor(attributeQuery, outputContext, false).parse(charSequence, parsePosition, this.getType(), attributeQuery);
        if (v2 == null && this.isMonthElement()) {
            parsePosition.setErrorIndex(-1);
            parsePosition.setIndex(n2);
            v2 = this.accessor(attributeQuery, outputContext, true).parse(charSequence, parsePosition, this.getType(), attributeQuery);
        }
        if (v2 == null && attributeQuery.get(Attributes.PARSE_MULTIPLE_CONTEXT, Boolean.TRUE).booleanValue()) {
            parsePosition.setErrorIndex(-1);
            parsePosition.setIndex(n2);
            outputContext = outputContext == OutputContext.FORMAT ? OutputContext.STANDALONE : OutputContext.FORMAT;
            v2 = this.accessor(attributeQuery, outputContext, false).parse(charSequence, parsePosition, this.getType(), attributeQuery);
            if (v2 == null && this.isMonthElement()) {
                parsePosition.setErrorIndex(-1);
                parsePosition.setIndex(n2);
                v2 = this.accessor(attributeQuery, outputContext, true).parse(charSequence, parsePosition, this.getType(), attributeQuery);
            }
        }
        return v2;
    }

    protected String getCalendarType(AttributeQuery attributeQuery) {
        if (this.isMonthElement() || this.isEraElement()) {
            return attributeQuery.get(Attributes.CALENDAR_TYPE, this.defaultCalendarType);
        }
        if (this.isWeekdayElement()) {
            return "iso8601";
        }
        return this.defaultCalendarType;
    }

    protected boolean hasLeapMonth(ChronoDisplay chronoDisplay) {
        return false;
    }

    protected boolean isEraElement() {
        return this.getSymbol() == 'G';
    }

    protected boolean isMonthElement() {
        return this.getSymbol() == 'M';
    }

    protected boolean isWeekdayElement() {
        return StdEnumDateElement.isWeekdayElement(this.getSymbol());
    }

    protected TextAccessor accessor(AttributeQuery attributeQuery, OutputContext outputContext, boolean bl2) {
        Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
        CalendarText calendarText = CalendarText.getInstance(this.getCalendarType(attributeQuery), locale);
        if (this.isMonthElement()) {
            if (bl2) {
                return calendarText.getLeapMonths(textWidth, outputContext);
            }
            return calendarText.getStdMonths(textWidth, outputContext);
        }
        if (this.isWeekdayElement()) {
            return calendarText.getWeekdays(textWidth, outputContext);
        }
        if (this.isEraElement()) {
            return calendarText.getEras(textWidth);
        }
        return calendarText.getTextForms(this.name(), this.type, new String[0]);
    }

    private static boolean isWeekdayElement(char c2) {
        return c2 == 'E';
    }

    private static String extractCalendarType(Class<?> clazz) {
        CalendarType calendarType = clazz.getAnnotation(CalendarType.class);
        return calendarType == null ? "iso8601" : calendarType.value();
    }
}

