/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.bahai;

import java.util.Locale;
import net.time4j.calendar.bahai.BadiDivision;
import net.time4j.calendar.bahai.FormattedContent;
import net.time4j.format.CalendarText;
import net.time4j.format.TextAccessor;

public enum BadiMonth implements BadiDivision
{
    BAHA,
    JALAL,
    JAMAL,
    AZAMAT,
    NUR,
    RAHMAT,
    KALIMAT,
    KAMAL,
    ASMA,
    IZZAT,
    MASHIYYAT,
    ILM,
    QUDRAT,
    QAWL,
    MASAIL,
    SHARAF,
    SULTAN,
    MULK,
    ALA;


    public static BadiMonth valueOf(int n2) {
        if (n2 < 1 || n2 > 19) {
            throw new IllegalArgumentException("Out of range: " + n2);
        }
        return BadiMonth.values()[n2 - 1];
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public String getDisplayName(Locale locale) {
        return BadiMonth.accessor(locale, FormattedContent.TRANSCRIPTION).print(this);
    }

    public String getMeaning(Locale locale) {
        return BadiMonth.accessor(locale, FormattedContent.MEANING).print(this);
    }

    private static TextAccessor accessor(Locale locale, FormattedContent formattedContent) {
        CalendarText calendarText = CalendarText.getInstance("bahai", locale);
        return calendarText.getTextForms("M", BadiMonth.class, formattedContent.variant());
    }
}

