/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import java.util.concurrent.TimeUnit;
import net.time4j.Moment;
import net.time4j.PlainTimestamp;
import net.time4j.base.MathUtils;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.calendar.astro.MoonPosition;

public enum MoonPhase {
    NEW_MOON(0),
    FIRST_QUARTER(90),
    FULL_MOON(180),
    LAST_QUARTER(270);

    private static final int[] FACTORS;
    private static final double MEAN_SYNODIC_MONTH = 29.530588861;
    private static final Moment ZERO_REF;
    private static final int[] W_NEW_FULL;
    private static final int[] W_QUARTER;
    private static final int[] X_NEW_FULL;
    private static final int[] X_QUARTER;
    private static final int[] Y_NEW_FULL;
    private static final int[] Y_QUARTER;
    private static final int[] Z_NEW_FULL;
    private static final int[] Z_QUARTER;
    private static final double[] V_NEW;
    private static final double[] V_FULL;
    private static final double[] V_QUARTER;
    private final transient int phase;

    private MoonPhase(int n3) {
        this.phase = n3;
    }

    public Moment after(Moment moment) {
        int n2 = this.getEstimatedLunations(moment);
        Moment moment2 = this.atLunation(n2);
        int n3 = n2;
        while (!moment2.isAfter(moment)) {
            moment2 = this.atLunation(++n3);
        }
        if (n3 <= n2) {
            Moment moment3;
            while ((moment3 = this.atLunation(--n3)).isAfter(moment)) {
                moment2 = moment3;
            }
        }
        return moment2;
    }

    public Moment atOrAfter(Moment moment) {
        int n2 = this.getEstimatedLunations(moment);
        Moment moment2 = this.atLunation(n2);
        int n3 = n2;
        while (moment2.isBefore(moment)) {
            moment2 = this.atLunation(++n3);
        }
        if (n3 <= n2) {
            Moment moment3;
            while (!(moment3 = this.atLunation(--n3)).isBefore(moment)) {
                moment2 = moment3;
            }
        }
        return moment2;
    }

    public Moment before(Moment moment) {
        int n2 = this.getEstimatedLunations(moment);
        Moment moment2 = this.atLunation(n2);
        int n3 = n2;
        while (!moment2.isBefore(moment)) {
            moment2 = this.atLunation(--n3);
        }
        if (n3 >= n2) {
            Moment moment3;
            while (((Moment)moment2.plus(29L, TimeUnit.DAYS)).isBefore(moment) && (moment3 = this.atLunation(++n3)).isBefore(moment)) {
                moment2 = moment3;
            }
        }
        return moment2;
    }

    public static int minLunation() {
        return -49473;
    }

    public static int maxLunation() {
        return 12379;
    }

    public Moment atLunation(int n2) {
        double d2 = (double)n2 + (double)this.phase / 360.0;
        double d3 = d2 / 1236.85;
        double d4 = d3 * d3;
        double d5 = 2451550.09766 + 29.530588861 * d2 + (1.5437E-4 + (-1.5E-7 + 7.3E-10 * d3) * d3) * d4;
        double d6 = 124.7746 - 1.56375588 * d2 + (0.0020672 + 2.15E-6 * d3) * d4;
        d5 -= 1.7E-4 * Math.sin(Math.toRadians(d6));
        double d7 = 1.0 - (0.002516 + 7.4E-6 * d3) * d3;
        double d8 = 2.5534 + 29.1053567 * d2 - (1.4E-6 + 1.1E-7 * d3) * d4;
        double d9 = 201.5643 + 385.81693528 * d2 + (0.0107582 + (1.238E-5 - 5.8E-8 * d3) * d3) * d4;
        double d10 = 160.7108 + 390.67050284 * d2 + (-0.0016118 + (-2.27E-6 + 1.1E-8 * d3) * d3) * d4;
        d5 += this.periodic24(d7, d8, d9, d10);
        if (this == FIRST_QUARTER) {
            d5 += MoonPhase.corrQuarter(d7, d8, d9, d10);
        } else if (this == LAST_QUARTER) {
            d5 -= MoonPhase.corrQuarter(d7, d8, d9, d10);
        }
        double[] dArray = new double[]{299.77 + 0.107408 * d2 - 0.009173 * d4, 3.25E-4, 251.88 + 0.016321 * d2, 1.65E-4, 251.83 + 26.651886 * d2, 1.64E-4, 349.42 + 36.412478 * d2, 1.26E-4, 84.66 + 18.206239 * d2, 1.1E-4, 141.74 + 53.303771 * d2, 6.2E-5, 207.14 + 2.453732 * d2, 6.0E-5, 154.84 + 7.30686 * d2, 5.6E-5, 34.52 + 27.261239 * d2, 4.7E-5, 207.19 + 0.121824 * d2, 4.2E-5, 291.34 + 1.844379 * d2, 4.0E-5, 161.72 + 24.198154 * d2, 3.7E-5, 239.56 + 25.513099 * d2, 3.5E-5, 331.55 + 3.592518 * d2, 2.3E-5};
        for (int i2 = 0; i2 < 28; i2 += 2) {
            d5 += dArray[i2 + 1] * Math.sin(Math.toRadians(dArray[i2]));
        }
        return (Moment)JulianDay.ofEphemerisTime(d5).toMoment().with(Moment.PRECISION, TimeUnit.SECONDS);
    }

    public static double getIllumination(Moment moment) {
        return MoonPhase.getIllumination(moment, 0);
    }

    public static double getIllumination(Moment moment, int n2) {
        double d2 = JulianDay.ofEphemerisTime(moment).getCenturyJ2000();
        double d3 = MoonPosition.getMeanElongation(d2);
        double d4 = MoonPosition.getMeanAnomalyOfSun(d2);
        int n3 = FACTORS[n2];
        double d5 = MoonPosition.getMeanAnomalyOfMoon(d2);
        double d6 = 180.0 - d3 - 6.289 * MoonPhase.sin(d5) + 2.1 * MoonPhase.sin(d4) - 1.274 * MoonPhase.sin(2.0 * d3 - d5) - 0.658 * MoonPhase.sin(2.0 * d3) - 0.214 * MoonPhase.sin(2.0 * d5) - 0.11 * MoonPhase.sin(d3);
        double d7 = (MoonPhase.cos(d6) + 1.0) / 2.0;
        if ((double)n3 - d7 * (double)n3 <= 0.5) {
            return 1.0;
        }
        return Math.floor(d7 * (double)n3) / (double)n3;
    }

    private int getEstimatedLunations(Moment moment) {
        return MathUtils.safeCast(Math.round((double)ZERO_REF.until(moment, TimeUnit.DAYS) / 29.530588861 - (double)this.phase / 360.0));
    }

    private double periodic24(double d2, double d3, double d4, double d5) {
        double[] dArray = this == NEW_MOON ? V_NEW : (this == FULL_MOON ? V_FULL : V_QUARTER);
        int[] nArray = this == NEW_MOON || this == FULL_MOON ? W_NEW_FULL : W_QUARTER;
        int[] nArray2 = this == NEW_MOON || this == FULL_MOON ? X_NEW_FULL : X_QUARTER;
        int[] nArray3 = this == NEW_MOON || this == FULL_MOON ? Y_NEW_FULL : Y_QUARTER;
        int[] nArray4 = this == NEW_MOON || this == FULL_MOON ? Z_NEW_FULL : Z_QUARTER;
        double d6 = 0.0;
        for (int i2 = 23; i2 >= 0; --i2) {
            double d7 = dArray[i2];
            if (nArray[i2] == 1) {
                d7 *= d2;
            } else if (nArray[i2] == 2) {
                d7 = d7 * d2 * d2;
            }
            d6 += (d7 *= MoonPhase.sin((double)nArray2[i2] * d3 + (double)nArray3[i2] * d4 + (double)nArray4[i2] * d5));
        }
        return d6;
    }

    private static double corrQuarter(double d2, double d3, double d4, double d5) {
        return 0.00306 - 3.8E-4 * d2 * MoonPhase.cos(d3) + 2.6E-4 * MoonPhase.cos(d4) - 2.0E-5 * MoonPhase.cos(d4 - d3) + 2.0E-5 * MoonPhase.cos(d4 + d3) + 2.0E-5 * MoonPhase.cos(2.0 * d5);
    }

    private static double sin(double d2) {
        return Math.sin(d2 * Math.PI / 180.0);
    }

    private static double cos(double d2) {
        return Math.cos(d2 * Math.PI / 180.0);
    }

    static {
        FACTORS = new int[]{100, 1000, 10000, 100000};
        ZERO_REF = PlainTimestamp.of(2000, 1, 6, 18, 13, 42).atUTC();
        W_NEW_FULL = new int[]{0, 1, 0, 0, 1, 1, 2, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        W_QUARTER = new int[]{0, 1, 1, 0, 0, 1, 2, 0, 0, 0, 1, 1, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        X_NEW_FULL = new int[]{0, 1, 0, 0, -1, 1, 2, 0, 0, 1, 0, 1, 1, -1, 2, 0, 3, 1, 0, 1, -1, -1, 1, 0};
        X_QUARTER = new int[]{0, 1, 1, 0, 0, -1, 2, 0, 0, 0, -1, 1, 1, 2, 1, -1, 0, 1, -2, 1, 3, 0, -1, 1};
        Y_NEW_FULL = new int[]{1, 0, 2, 0, 1, 1, 0, 1, 1, 2, 3, 0, 0, 2, 1, 2, 0, 1, 2, 1, 1, 1, 3, 4};
        Y_QUARTER = new int[]{1, 0, 1, 2, 0, 1, 0, 1, 1, 3, 2, 0, 0, 1, 2, 1, 2, 1, 1, 1, 0, 2, 1, 3};
        Z_NEW_FULL = new int[]{0, 0, 0, 2, 0, 0, 0, -2, 2, 0, 0, 2, -2, 0, 0, -2, 0, -2, 2, 2, 2, -2, 0, 0};
        Z_QUARTER = new int[]{0, 0, 0, 0, 2, 0, 0, -2, 2, 0, 0, 2, -2, 0, 0, -2, 2, 2, 0, -2, 0, -2, 2, 0};
        V_NEW = new double[]{-0.4072, 0.17241, 0.01608, 0.01039, 0.00739, -0.00514, 0.00208, -0.00111, -5.7E-4, 5.6E-4, -4.2E-4, 4.2E-4, 3.8E-4, -2.4E-4, -7.0E-5, 4.0E-5, 4.0E-5, 3.0E-5, 3.0E-5, -3.0E-5, 3.0E-5, -2.0E-5, -2.0E-5, 2.0E-5};
        V_FULL = new double[]{-0.40614, 0.17302, 0.01614, 0.01043, 0.00734, -0.00515, 0.00209, -0.00111, -5.7E-4, 5.6E-4, -4.2E-4, 4.2E-4, 3.8E-4, -2.4E-4, -7.0E-5, 4.0E-5, 4.0E-5, 3.0E-5, 3.0E-5, -3.0E-5, 3.0E-5, -2.0E-5, -2.0E-5, 2.0E-5};
        V_QUARTER = new double[]{-0.62801, 0.17172, -0.01183, 0.00862, 0.00804, 0.00454, 0.00204, -0.0018, -7.0E-4, -4.0E-4, -3.4E-4, 3.2E-4, 3.2E-4, -2.8E-4, 2.7E-4, -5.0E-5, 4.0E-5, -4.0E-5, 4.0E-5, 3.0E-5, 3.0E-5, 2.0E-5, 2.0E-5, -2.0E-5};
    }
}

