/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import net.time4j.calendar.JulianCalendar;
import net.time4j.history.HistoricEra;

final class SPX7
implements Externalizable {
    private static final int JULIAN = 7;
    private static final long serialVersionUID = 1L;
    private transient Object obj;

    public SPX7() {
    }

    SPX7(Object object) {
        this.obj = object;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(7);
        JulianCalendar julianCalendar = (JulianCalendar)this.obj;
        objectOutput.writeInt(julianCalendar.getProlepticYear());
        objectOutput.writeInt(julianCalendar.getMonth().getValue());
        objectOutput.writeInt(julianCalendar.getDayOfMonth());
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by2 = objectInput.readByte();
        if (by2 != 7) {
            throw new InvalidObjectException("Unknown calendar type.");
        }
        int n2 = objectInput.readInt();
        int n3 = objectInput.readInt();
        int n4 = objectInput.readInt();
        HistoricEra historicEra = n2 >= 1 ? HistoricEra.AD : HistoricEra.BC;
        int n5 = n2 >= 1 ? n2 : Math.subtractExact(1, n2);
        this.obj = JulianCalendar.of(historicEra, n5, n3, n4);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }
}

