/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import net.time4j.CalendarUnit;
import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.calendar.PersianCalendar;
import net.time4j.calendar.astro.AstronomicalSeason;
import net.time4j.calendar.astro.SolarTime;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.EpochDays;
import net.time4j.format.Attributes;
import net.time4j.tz.OffsetSign;
import net.time4j.tz.ZonalOffset;

public enum PersianAlgorithm {
    BORKOWSKI{

        @Override
        boolean isLeapYear(int n2, ZonalOffset zonalOffset) {
            PersianAlgorithm.checkYear(n2);
            PersianCalendar persianCalendar = new PersianCalendar(n2 + 1, 1, 1);
            PersianCalendar persianCalendar2 = new PersianCalendar(n2, 1, 1);
            return this.transform(persianCalendar, zonalOffset) - this.transform(persianCalendar2, zonalOffset) == 366L;
        }

        @Override
        PersianCalendar transform(long l2, ZonalOffset zonalOffset) {
            int n2;
            int n3;
            PlainDate plainDate = PlainDate.of(l2, EpochDays.UTC);
            int n4 = plainDate.getYear() - 621;
            if (plainDate.getMonth() < 3) {
                --n4;
            }
            PlainDate plainDate2 = this.vernalEquinox(n4);
            long l3 = CalendarUnit.DAYS.between(plainDate2, plainDate);
            while (l3 < 0L) {
                plainDate2 = this.vernalEquinox(--n4);
                l3 = CalendarUnit.DAYS.between(plainDate2, plainDate);
            }
            for (n3 = 1; n3 < 12; ++n3) {
                int n5 = n2 = n3 <= 6 ? 31 : 30;
                if (l3 < (long)n2) break;
                l3 -= (long)n2;
            }
            n2 = (int)(l3 + 1L);
            return PersianCalendar.of(n4, n3, n2);
        }

        @Override
        long transform(PersianCalendar persianCalendar, ZonalOffset zonalOffset) {
            int n2 = persianCalendar.getYear();
            int n3 = persianCalendar.getMonth().getValue();
            long l2 = this.vernalEquinox(n2).getDaysSinceEpochUTC();
            return l2 += (long)((n3 - 1) * 31 - n3 / 7 * (n3 - 7) + persianCalendar.getDayOfMonth() - 1);
        }

        private PlainDate vernalEquinox(int n2) {
            int n3;
            int n4;
            int[] nArray = new int[]{-61, 9, 38, 199, 426, 686, 756, 818, 1111, 1181, 1210, 1635, 2060, 2097, 2192, 2262, 2324, 2394, 2456, 3178};
            int n5 = nArray[nArray.length - 1];
            if (n2 < 1 || n2 >= n5) {
                throw new IllegalArgumentException("Persian year out of range 1-" + n5 + ": " + n2);
            }
            int n6 = n2 + 621;
            int n7 = -14;
            int n8 = nArray[0];
            int n9 = 0;
            for (n4 = 1; n4 < nArray.length; ++n4) {
                n3 = nArray[n4];
                n9 = n3 - n8;
                if (n2 < n3) break;
                n7 += n9 / 33 * 8 + n9 % 33 / 4;
                n8 = n3;
            }
            n4 = n2 - n8;
            n7 += n4 / 33 * 8 + (n4 % 33 + 3) / 4;
            if (n9 % 33 == 4 && n9 - n4 == 4) {
                ++n7;
            }
            n3 = n6 / 4 - (n6 / 100 + 1) * 3 / 4 - 150;
            int n10 = 20 + n7 - n3;
            return PlainDate.of(n6, 3, n10);
        }
    }
    ,
    KHAYYAM{

        @Override
        boolean isLeapYear(int n2, ZonalOffset zonalOffset) {
            PersianAlgorithm.checkYear(n2);
            int n3 = n2 % 33;
            return n3 == 1 || n3 == 5 || n3 == 9 || n3 == 13 || n3 == 17 || n3 == 22 || n3 == 26 || n3 == 30;
        }

        @Override
        PersianCalendar transform(long l2, ZonalOffset zonalOffset) {
            int n2;
            int n3;
            PersianAlgorithm.checkRange(l2);
            long l3 = l2 + 493363L;
            int n4 = (int)(l3 / 12053L);
            int n5 = (int)(l3 % 12053L);
            int n6 = n4 * 33;
            int n7 = 1;
            int n8 = 1;
            for (n3 = 0; n3 < 33; ++n3) {
                int n9 = n2 = n3 == 1 || n3 == 5 || n3 == 9 || n3 == 13 || n3 == 17 || n3 == 22 || n3 == 26 || n3 == 30 ? 366 : 365;
                if (n5 < n2) break;
                n5 -= n2;
                ++n6;
            }
            for (n3 = 1; n3 < 12; ++n3) {
                int n10 = n2 = n3 <= 6 ? 31 : 30;
                if (n5 < n2) break;
                n5 -= n2;
                ++n7;
            }
            return new PersianCalendar(n6, n7, n8 += n5);
        }

        @Override
        long transform(PersianCalendar persianCalendar, ZonalOffset zonalOffset) {
            int n2;
            int n3 = persianCalendar.getYear();
            long l2 = (long)(n3 / 33 * 12053) - 493363L;
            int n4 = n3 % 33;
            for (n2 = 0; n2 < n4; ++n2) {
                int n5 = n2 == 1 || n2 == 5 || n2 == 9 || n2 == 13 || n2 == 17 || n2 == 22 || n2 == 26 || n2 == 30 ? 366 : 365;
                l2 += (long)n5;
            }
            n2 = persianCalendar.getMonth().getValue();
            l2 = n2 <= 7 ? (l2 += (long)(31 * (n2 - 1))) : (l2 += (long)(30 * (n2 - 1) + 6));
            return l2 + (long)persianCalendar.getDayOfMonth() - 1L;
        }
    }
    ,
    BIRASHK{

        @Override
        boolean isLeapYear(int n2, ZonalOffset zonalOffset) {
            PersianAlgorithm.checkYear(n2);
            return Math.floorMod((Math.floorMod(n2 - 474, 2820) + 512) * 31, 128) < 31;
        }

        @Override
        PersianCalendar transform(long l2, ZonalOffset zonalOffset) {
            PersianAlgorithm.checkRange(l2);
            int n2 = (int)(l2 - -319872L);
            int n3 = Math.floorDiv(n2, 1029983);
            int n4 = Math.floorMod(n2, 1029983);
            int n5 = n4 == 1029982 ? 2820 : Math.floorDiv(128 * n4 + 46878, 46751);
            int n6 = 474 + 2820 * n3 + n5;
            int n7 = 1;
            int n8 = 1;
            int n9 = (int)(l2 - this.transform(new PersianCalendar(n6, 1, 1), zonalOffset));
            for (int i2 = 1; i2 < 12; ++i2) {
                int n10;
                int n11 = n10 = i2 <= 6 ? 31 : 30;
                if (n9 < n10) break;
                n9 -= n10;
                ++n7;
            }
            return new PersianCalendar(n6, n7, n8 += n9);
        }

        @Override
        long transform(PersianCalendar persianCalendar, ZonalOffset zonalOffset) {
            int n2 = persianCalendar.getYear() - 474;
            int n3 = Math.floorMod(n2, 2820) + 474;
            long l2 = -492998L;
            l2 += (long)(1029983 * Math.floorDiv(n2, 2820));
            l2 += (long)(365 * (n3 - 1));
            l2 += (long)Math.floorDiv(31 * n3 - 5, 128);
            int n4 = persianCalendar.getMonth().getValue();
            l2 = n4 <= 7 ? (l2 += (long)(31 * (n4 - 1))) : (l2 += (long)(30 * (n4 - 1) + 6));
            return l2 + (long)persianCalendar.getDayOfMonth();
        }
    }
    ,
    ASTRONOMICAL{

        @Override
        int getMaxPersianYear() {
            return 2378;
        }

        @Override
        boolean isLeapYear(int n2, ZonalOffset zonalOffset) {
            if (n2 < 1 || n2 > this.getMaxPersianYear()) {
                throw new IllegalArgumentException("Out of range: " + n2);
            }
            PersianCalendar persianCalendar = new PersianCalendar(n2 + 1, 1, 1);
            PersianCalendar persianCalendar2 = new PersianCalendar(n2, 1, 1);
            return this.transform(persianCalendar, zonalOffset) - this.transform(persianCalendar2, zonalOffset) == 366L;
        }

        @Override
        PersianCalendar transform(long l2, ZonalOffset zonalOffset) {
            int n2;
            int n3;
            if (l2 < -492997L || l2 > 375548L) {
                throw new IllegalArgumentException("Out of range: " + l2);
            }
            PlainDate plainDate = PlainDate.of(l2, EpochDays.UTC);
            int n4 = plainDate.getYear() - 621;
            if (plainDate.getMonth() < 3) {
                --n4;
            }
            PlainDate plainDate2 = this.vernalEquinox(n4, zonalOffset);
            long l3 = CalendarUnit.DAYS.between(plainDate2, plainDate);
            while (l3 < 0L) {
                plainDate2 = this.vernalEquinox(--n4, zonalOffset);
                l3 = CalendarUnit.DAYS.between(plainDate2, plainDate);
            }
            for (n3 = 1; n3 < 12; ++n3) {
                int n5 = n2 = n3 <= 6 ? 31 : 30;
                if (l3 < (long)n2) break;
                l3 -= (long)n2;
            }
            n2 = (int)(l3 + 1L);
            return new PersianCalendar(n4, n3, n2);
        }

        @Override
        long transform(PersianCalendar persianCalendar, ZonalOffset zonalOffset) {
            int n2 = persianCalendar.getYear();
            int n3 = persianCalendar.getMonth().getValue();
            long l2 = this.vernalEquinox(n2, zonalOffset).getDaysSinceEpochUTC();
            return l2 += (long)((n3 - 1) * 31 - n3 / 7 * (n3 - 7) + persianCalendar.getDayOfMonth() - 1);
        }

        private PlainDate vernalEquinox(int n2, ZonalOffset zonalOffset) {
            PlainTimestamp plainTimestamp = AstronomicalSeason.VERNAL_EQUINOX.inYear(n2 + 621).get(SolarTime.apparentAt(zonalOffset));
            if (plainTimestamp.getHour() >= 12) {
                return plainTimestamp.getCalendarDate().plus(1L, CalendarUnit.DAYS);
            }
            return plainTimestamp.getCalendarDate();
        }
    };

    static final ZonalOffset STD_OFFSET;
    private static final int LENGTH_OF_KHAYYAM_CYCLE = 12053;
    private static final long REFERENCE_ZERO_KHAYYAM = 493363L;
    private static final long START_OF_BIRASHK_CYCLE = -319872L;
    private static final AttributeKey<PersianAlgorithm> ATTRIBUTE;

    public static AttributeKey<PersianAlgorithm> attribute() {
        return ATTRIBUTE;
    }

    public boolean isLeapYear(int n2) {
        return this.isLeapYear(n2, STD_OFFSET);
    }

    abstract boolean isLeapYear(int var1, ZonalOffset var2);

    abstract PersianCalendar transform(long var1, ZonalOffset var3);

    int getMaxPersianYear() {
        return 3000;
    }

    abstract long transform(PersianCalendar var1, ZonalOffset var2);

    boolean isValid(int n2, int n3, int n4, ZonalOffset zonalOffset) {
        if (n2 < 1 || n2 > this.getMaxPersianYear() || n3 < 1 || n3 > 12 || n4 < 1) {
            return false;
        }
        if (n3 <= 6) {
            return n4 <= 31;
        }
        if (n3 <= 11) {
            return n4 <= 30;
        }
        return n4 <= (this.isLeapYear(n2, zonalOffset) ? 30 : 29);
    }

    private static void checkRange(long l2) {
        CalendarSystem<PersianCalendar> calendarSystem = PersianCalendar.axis().getCalendarSystem();
        if (l2 < calendarSystem.getMinimumSinceUTC() || l2 > calendarSystem.getMaximumSinceUTC()) {
            throw new IllegalArgumentException("Out of range: " + l2);
        }
    }

    private static void checkYear(int n2) {
        if (n2 < 1 || n2 > 3000) {
            throw new IllegalArgumentException("Out of range: " + n2);
        }
    }

    static {
        STD_OFFSET = ZonalOffset.ofHoursMinutes(OffsetSign.AHEAD_OF_UTC, 3, 30);
        ATTRIBUTE = Attributes.createKey("PERSIAN_ALGORITHM", PersianAlgorithm.class);
    }
}

