/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.time4j.base.MathUtils;
import net.time4j.calendar.EraYearMonthDaySystem;
import net.time4j.calendar.HijriAdjustment;
import net.time4j.calendar.HijriCalendar;
import net.time4j.calendar.HijriEra;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.VariantSource;

public enum HijriAlgorithm implements VariantSource
{
    EAST_ISLAMIC_CIVIL("islamic-eastc", new int[]{2, 5, 7, 10, 13, 15, 18, 21, 24, 26, 29}, true),
    EAST_ISLAMIC_ASTRO("islamic-easta", new int[]{2, 5, 7, 10, 13, 15, 18, 21, 24, 26, 29}, false),
    WEST_ISLAMIC_CIVIL("islamic-civil", new int[]{2, 5, 7, 10, 13, 16, 18, 21, 24, 26, 29}, true),
    WEST_ISLAMIC_ASTRO("islamic-tbla", new int[]{2, 5, 7, 10, 13, 16, 18, 21, 24, 26, 29}, false),
    FATIMID_CIVIL("islamic-fatimidc", new int[]{2, 5, 8, 10, 13, 16, 19, 21, 24, 27, 29}, true),
    FATIMID_ASTRO("islamic-fatimida", new int[]{2, 5, 8, 10, 13, 16, 19, 21, 24, 27, 29}, false),
    HABASH_AL_HASIB_CIVIL("islamic-habashalhasibc", new int[]{2, 5, 8, 11, 13, 16, 19, 21, 24, 27, 30}, true),
    HABASH_AL_HASIB_ASTRO("islamic-habashalhasiba", new int[]{2, 5, 8, 11, 13, 16, 19, 21, 24, 27, 30}, false);

    private static final long LENGTH_OF_30_YEAR_CYCLE;
    private static final long START_622_07_15;
    private static final long START_622_07_16;
    private static final int MAX_YEAR;
    private static final long ASTRO_1600_12_29;
    private static final long CIVIL_1600_12_29;
    private final transient Transformer calsys;

    private HijriAlgorithm(String string2, int[] nArray, boolean bl2) {
        this.calsys = new Transformer(string2, nArray, bl2, 0);
    }

    @Override
    public String getVariant() {
        return this.calsys.variant;
    }

    EraYearMonthDaySystem<HijriCalendar> getCalendarSystem(int n2) {
        if (n2 == 0) {
            return this.calsys;
        }
        HijriAdjustment hijriAdjustment = HijriAdjustment.of(this.getVariant(), n2);
        return new Transformer(hijriAdjustment.getVariant(), this.calsys.intercalaries, this.calsys.civil, n2);
    }

    static {
        LENGTH_OF_30_YEAR_CYCLE = 10631L;
        START_622_07_15 = -492879L;
        START_622_07_16 = START_622_07_15 + 1L;
        MAX_YEAR = 1600;
        ASTRO_1600_12_29 = 74106L;
        CIVIL_1600_12_29 = ASTRO_1600_12_29 + 1L;
    }

    private static class Transformer
    implements EraYearMonthDaySystem<HijriCalendar> {
        private final String variant;
        private final int[] intercalaries;
        private final boolean civil;
        private final int adjustment;

        Transformer(String string, int[] nArray, boolean bl2, int n2) {
            this.variant = string;
            this.intercalaries = nArray;
            this.civil = bl2;
            this.adjustment = n2;
        }

        @Override
        public boolean isValid(CalendarEra calendarEra, int n2, int n3, int n4) {
            return calendarEra == HijriEra.ANNO_HEGIRAE && n2 >= 1 && n2 <= MAX_YEAR && n3 >= 1 && n3 <= 12 && n4 >= 1 && n4 <= this.getLengthOfMonth(calendarEra, n2, n3);
        }

        @Override
        public int getLengthOfMonth(CalendarEra calendarEra, int n2, int n3) {
            if (calendarEra != HijriEra.ANNO_HEGIRAE) {
                throw new IllegalArgumentException("Wrong era: " + calendarEra);
            }
            if (n2 < 1 || n2 > MAX_YEAR || n3 < 1 || n3 > 12) {
                throw new IllegalArgumentException("Out of bounds: " + n2 + "/" + n3);
            }
            if (n3 == 12) {
                int n4 = (n2 - 1) % 30 + 1;
                return Arrays.binarySearch(this.intercalaries, n4) >= 0 ? 30 : 29;
            }
            return n3 % 2 == 1 ? 30 : 29;
        }

        @Override
        public int getLengthOfYear(CalendarEra calendarEra, int n2) {
            if (calendarEra != HijriEra.ANNO_HEGIRAE) {
                throw new IllegalArgumentException("Wrong era: " + calendarEra);
            }
            if (n2 < 1 || n2 > MAX_YEAR) {
                throw new IllegalArgumentException("Out of bounds: yearOfEra=" + n2);
            }
            int n3 = (n2 - 1) % 30 + 1;
            return Arrays.binarySearch(this.intercalaries, n3) >= 0 ? 355 : 354;
        }

        @Override
        public HijriCalendar transform(long l2) {
            int n2;
            int n3;
            long l3;
            long l4 = Math.addExact(l2, (long)this.adjustment);
            long l5 = l3 = this.civil ? START_622_07_16 : START_622_07_15;
            if (l4 < l3 || l4 > (this.civil ? CIVIL_1600_12_29 : ASTRO_1600_12_29)) {
                throw new IllegalArgumentException("Out of supported range: " + l2);
            }
            long l6 = Math.subtractExact(l4, l3);
            int n4 = 1;
            int n5 = 1;
            int n6 = 1;
            n4 += MathUtils.safeCast(l6 / LENGTH_OF_30_YEAR_CYCLE * 30L);
            int n7 = (int)(l6 % LENGTH_OF_30_YEAR_CYCLE);
            for (n3 = 1; n3 < 30; ++n3) {
                n2 = 354;
                if (Arrays.binarySearch(this.intercalaries, n3) >= 0) {
                    ++n2;
                }
                if (n7 <= n2) break;
                n7 -= n2;
                ++n4;
            }
            for (n3 = 1; n3 < 12; ++n3) {
                n2 = 30;
                if (n3 % 2 == 0) {
                    n2 = 29;
                }
                if (n7 <= n2) break;
                n7 -= n2;
                ++n5;
            }
            n6 += n7;
            if (n5 == 12) {
                n2 = (n4 - 1) % 30 + 1;
                n3 = Arrays.binarySearch(this.intercalaries, n2) >= 0 ? 30 : 29;
            } else {
                int n8 = n3 = n5 % 2 == 1 ? 30 : 29;
            }
            if (n6 > n3) {
                n6 = 1;
                if (++n5 > 12) {
                    n5 = 1;
                    ++n4;
                }
            }
            return HijriCalendar.of(this.variant, n4, n5, n6);
        }

        @Override
        public long transform(HijriCalendar hijriCalendar) {
            int n2;
            int n3 = hijriCalendar.getYear();
            int n4 = hijriCalendar.getMonth().getValue();
            int n5 = hijriCalendar.getDayOfMonth();
            if (n3 < 1 || n3 > MAX_YEAR || n4 < 1 || n4 > 12 || n5 < 1 || n5 > 30) {
                throw new IllegalArgumentException("Out of supported range: " + hijriCalendar);
            }
            long l2 = (long)((n3 - 1) / 30) * LENGTH_OF_30_YEAR_CYCLE;
            int n6 = (n3 - 1) % 30 + 1;
            for (n2 = 1; n2 < n6; ++n2) {
                if (Arrays.binarySearch(this.intercalaries, n2) >= 0) {
                    l2 += 355L;
                    continue;
                }
                l2 += 354L;
            }
            for (n2 = 1; n2 < n4; ++n2) {
                if (n2 % 2 == 0) {
                    l2 += 29L;
                    continue;
                }
                l2 += 30L;
            }
            if (n5 == 30 && (n4 == 12 && Arrays.binarySearch(this.intercalaries, n6) < 0 || n4 != 12 && n4 % 2 == 0)) {
                throw new IllegalArgumentException("Invalid day-of-month: " + hijriCalendar);
            }
            long l3 = this.civil ? START_622_07_16 : START_622_07_15;
            return Math.subtractExact(l3 + (l2 += (long)n5) - 1L, (long)this.adjustment);
        }

        @Override
        public long getMinimumSinceUTC() {
            return Math.subtractExact(this.civil ? START_622_07_16 : START_622_07_15, (long)this.adjustment);
        }

        @Override
        public long getMaximumSinceUTC() {
            return Math.subtractExact(this.civil ? CIVIL_1600_12_29 : ASTRO_1600_12_29, (long)this.adjustment);
        }

        @Override
        public List<CalendarEra> getEras() {
            HijriEra hijriEra = HijriEra.ANNO_HEGIRAE;
            return Collections.singletonList(hijriEra);
        }
    }
}

