/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import net.time4j.base.MathUtils;
import net.time4j.calendar.CyclicYear;

@FunctionalInterface
public interface EastAsianYear {
    public static EastAsianYear forGregorian(int n2) {
        return () -> MathUtils.safeAdd(n2, 2636);
    }

    public static EastAsianYear forMinguo(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Minguo year must not be smaller than 1: " + n2);
        }
        return EastAsianYear.forGregorian(MathUtils.safeAdd(n2, 1911));
    }

    public static EastAsianYear forDangi(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Dangi year must not be smaller than 1: " + n2);
        }
        return EastAsianYear.forGregorian(MathUtils.safeAdd(n2, -2333));
    }

    public static EastAsianYear forJuche(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Juche year must not be smaller than 1: " + n2);
        }
        return EastAsianYear.forGregorian(MathUtils.safeAdd(n2, 1911));
    }

    default public int getCycle() {
        int n2 = this.getElapsedCyclicYears() + 1;
        return MathUtils.floorDivide(n2 - 1, 60) + 1;
    }

    default public CyclicYear getYearOfCycle() {
        int n2 = this.getElapsedCyclicYears() + 1;
        int n3 = MathUtils.floorModulo(n2, 60);
        if (n3 == 0) {
            n3 = 60;
        }
        return CyclicYear.of(n3);
    }

    public int getElapsedCyclicYears();
}

