/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.base;

import net.time4j.base.GregorianDate;

public final class GregorianMath {
    public static final int MIN_YEAR = -999999999;
    public static final int MAX_YEAR = 999999999;
    private static final int OFFSET = 678881;

    private GregorianMath() {
    }

    public static boolean isLeapYear(int n2) {
        if (n2 > 1900 && n2 < 2100) {
            return (n2 & 3) == 0;
        }
        return (n2 & 3) == 0 && (n2 % 100 != 0 || n2 % 400 == 0);
    }

    public static int getLengthOfMonth(int n2, int n3) {
        switch (n3) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                return GregorianMath.isLeapYear(n2) ? 29 : 28;
            }
        }
        throw new IllegalArgumentException("Invalid month: " + n3);
    }

    public static boolean isValid(int n2, int n3, int n4) {
        return n2 >= -999999999 && n2 <= 999999999 && n3 >= 1 && n3 <= 12 && n4 >= 1 && n4 <= GregorianMath.getLengthOfMonth(n2, n3);
    }

    public static void checkDate(int n2, int n3, int n4) {
        if (n2 < -999999999 || n2 > 999999999) {
            throw new IllegalArgumentException("YEAR out of range: " + n2);
        }
        if (n3 < 1 || n3 > 12) {
            throw new IllegalArgumentException("MONTH out of range: " + n3);
        }
        if (n4 < 1 || n4 > 31) {
            throw new IllegalArgumentException("DAY_OF_MONTH out of range: " + n4);
        }
        if (n4 > GregorianMath.getLengthOfMonth(n2, n3)) {
            throw new IllegalArgumentException("DAY_OF_MONTH exceeds month length in given year: " + GregorianMath.toString(n2, n3, n4));
        }
    }

    public static int getDayOfWeek(int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n4 < 1 || n4 > 31) {
            throw new IllegalArgumentException("Day out of range: " + n4);
        }
        if (n4 > GregorianMath.getLengthOfMonth(n2, n3)) {
            throw new IllegalArgumentException("Day exceeds month length: " + GregorianMath.toString(n2, n3, n4));
        }
        int n7 = GregorianMath.gaussianWeekTerm(n3);
        int n8 = n2 % 100;
        int n9 = Math.floorDiv(n2, 100);
        if (n8 < 0) {
            n8 += 100;
        }
        if (n3 <= 2 && --n8 < 0) {
            n8 = 99;
            --n9;
        }
        if ((n6 = (n4 + n7 + n8 + n8 / 4 + (n5 = Math.floorDiv(n9, 4)) - 2 * n9) % 7) <= 0) {
            n6 += 7;
        }
        return n6;
    }

    public static int readYear(long l2) {
        return (int)(l2 >> 32);
    }

    public static int readMonth(long l2) {
        return (int)(l2 >> 16 & 0xFFL);
    }

    public static int readDayOfMonth(long l2) {
        return (int)(l2 & 0xFFL);
    }

    public static long toPackedDate(long l2) {
        int n2;
        int n3;
        long l3;
        long l4;
        long l5 = Math.addExact(l2, 678881L);
        if (l5 >= 694266L && l5 < 766950L) {
            l4 = Math.floorDiv(l5 += 15L, 1461L);
            int n4 = (int)Math.floorMod(l5, 1461L);
            if (n4 == 1460) {
                l3 = (l4 + 1L) * 4L;
                n3 = 2;
                n2 = 29;
            } else {
                int n5 = n4 / 365;
                int n6 = n4 % 365;
                l3 = l4 * 4L + (long)n5;
                n3 = (n6 + 31) * 5 / 153 + 2;
                n2 = n6 - (n3 + 1) * 153 / 5 + 123;
                if (n3 > 12) {
                    ++l3;
                    n3 -= 12;
                }
            }
        } else {
            l4 = Math.floorDiv(l5, 146097L);
            int n7 = (int)Math.floorMod(l5, 146097L);
            if (n7 == 146096) {
                l3 = (l4 + 1L) * 400L;
                n3 = 2;
                n2 = 29;
            } else {
                int n8 = n7 / 36524;
                int n9 = n7 % 36524;
                int n10 = n9 / 1461;
                int n11 = n9 % 1461;
                if (n11 == 1460) {
                    l3 = l4 * 400L + (long)(n8 * 100) + (long)((n10 + 1) * 4);
                    n3 = 2;
                    n2 = 29;
                } else {
                    int n12 = n11 / 365;
                    int n13 = n11 % 365;
                    l3 = l4 * 400L + (long)(n8 * 100) + (long)(n10 * 4) + (long)n12;
                    n3 = (n13 + 31) * 5 / 153 + 2;
                    n2 = n13 - (n3 + 1) * 153 / 5 + 123;
                    if (n3 > 12) {
                        ++l3;
                        n3 -= 12;
                    }
                }
            }
            if (l3 < -999999999L || l3 > 999999999L) {
                throw new IllegalArgumentException("Year out of range: " + l3);
            }
        }
        l4 = l3 << 32;
        l4 |= (long)(n3 << 16);
        return l4 |= (long)n2;
    }

    public static long toMJD(GregorianDate gregorianDate) {
        return GregorianMath.toMJD(gregorianDate.getYear(), gregorianDate.getMonth(), gregorianDate.getDayOfMonth());
    }

    public static long toMJD(int n2, int n3, int n4) {
        GregorianMath.checkDate(n2, n3, n4);
        long l2 = n2;
        int n5 = n3;
        if (n5 < 3) {
            --l2;
            n5 += 12;
        }
        long l3 = l2 * 365L + Math.floorDiv(l2, 4L) + (long)((n5 + 1) * 153 / 5) - 123L + (long)n4;
        l3 = n2 >= 1901 && n2 < 2100 ? (l3 -= 15L) : l3 - Math.floorDiv(l2, 100L) + Math.floorDiv(l2, 400L);
        return l3 - 678881L;
    }

    private static String toString(int n2, int n3, int n4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n2);
        stringBuilder.append('-');
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        stringBuilder.append('-');
        if (n4 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n4);
        return stringBuilder.toString();
    }

    private static int gaussianWeekTerm(int n2) {
        switch (n2) {
            case 1: {
                return 28;
            }
            case 2: {
                return 31;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 10;
            }
            case 7: {
                return 12;
            }
            case 8: {
                return 15;
            }
            case 9: {
                return 18;
            }
            case 10: {
                return 20;
            }
            case 11: {
                return 23;
            }
            case 12: {
                return 25;
            }
        }
        throw new IllegalArgumentException("Month out of range: " + n2);
    }
}

