/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.engine.AbstractDuration;
import net.time4j.engine.Normalizer;
import net.time4j.engine.TimeSpan;

final class ClockNormalizer
implements Normalizer<ClockUnit> {
    private static final int ONLY_MODE = 0;
    private static final int TRUNCATE_MODE = 1;
    private static final int ROUNDING_MODE = 2;
    private static final Map<ClockUnit, ClockNormalizer> MAP_ONLY = ClockNormalizer.fill(0);
    private static final Map<ClockUnit, ClockNormalizer> MAP_TRUNC = ClockNormalizer.fill(1);
    private static final Map<ClockUnit, ClockNormalizer> MAP_ROUND = ClockNormalizer.fill(2);
    private final ClockUnit unit;
    private final int mode;

    private ClockNormalizer(ClockUnit clockUnit, int n2) {
        this.unit = clockUnit;
        this.mode = n2;
    }

    static ClockNormalizer ofOnlyMode(ClockUnit clockUnit) {
        ClockNormalizer clockNormalizer = MAP_ONLY.get(clockUnit);
        if (clockNormalizer == null) {
            throw new IllegalArgumentException(clockUnit.name());
        }
        return clockNormalizer;
    }

    static ClockNormalizer ofTruncateMode(ClockUnit clockUnit) {
        ClockNormalizer clockNormalizer = MAP_TRUNC.get(clockUnit);
        if (clockNormalizer == null) {
            throw new IllegalArgumentException(clockUnit.name());
        }
        return clockNormalizer;
    }

    static ClockNormalizer ofRoundingMode(ClockUnit clockUnit) {
        ClockNormalizer clockNormalizer = MAP_ROUND.get(clockUnit);
        if (clockNormalizer == null) {
            throw new IllegalArgumentException(clockUnit.name());
        }
        return clockNormalizer;
    }

    @Override
    public Duration<ClockUnit> normalize(TimeSpan<? extends ClockUnit> timeSpan) {
        switch (this.mode) {
            case 0: {
                return Duration.of(this.unit.convert(timeSpan), this.unit);
            }
            case 1: {
                ArrayList arrayList = new ArrayList();
                for (TimeSpan.Item<? extends ClockUnit> item : timeSpan.getTotalLength()) {
                    ClockUnit clockUnit = item.getUnit();
                    if (clockUnit.compareTo(this.unit) > 0) continue;
                    arrayList.add(TimeSpan.Item.of(item.getAmount(), clockUnit));
                }
                if (arrayList.isEmpty()) {
                    return Duration.ofZero();
                }
                return new Duration<ClockUnit>(arrayList, timeSpan.isNegative());
            }
            case 2: {
                long l2;
                boolean bl2 = timeSpan.isNegative();
                AbstractDuration abstractDuration = Duration.ofZero();
                abstractDuration = abstractDuration.plus(timeSpan);
                if (bl2) {
                    abstractDuration = abstractDuration.abs();
                }
                abstractDuration = abstractDuration.with(Duration.STD_CLOCK_PERIOD);
                switch (this.unit) {
                    case HOURS: 
                    case MINUTES: {
                        l2 = 30L;
                        break;
                    }
                    case SECONDS: 
                    case MILLIS: 
                    case MICROS: {
                        l2 = 500L;
                        break;
                    }
                    default: {
                        return abstractDuration;
                    }
                }
                ClockUnit clockUnit = ClockUnit.values()[this.unit.ordinal() + 1];
                if (abstractDuration.getPartialAmount(clockUnit) >= l2) {
                    abstractDuration = abstractDuration.plus(1L, (ClockUnit)((Object)this.unit)).with(Duration.STD_CLOCK_PERIOD);
                }
                abstractDuration = abstractDuration.with(this.unit.truncated());
                if (bl2) {
                    abstractDuration = abstractDuration.inverse();
                }
                return abstractDuration;
            }
        }
        throw new UnsupportedOperationException("Unknown mode: " + this.mode);
    }

    private static Map<ClockUnit, ClockNormalizer> fill(int n2) {
        EnumMap<ClockUnit, ClockNormalizer> enumMap = new EnumMap<ClockUnit, ClockNormalizer>(ClockUnit.class);
        for (ClockUnit clockUnit : ClockUnit.values()) {
            enumMap.put(clockUnit, new ClockNormalizer(clockUnit, n2));
        }
        return Collections.unmodifiableMap(enumMap);
    }
}

