/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import jakarta.activation.UnsupportedDataTypeException;
import java.io.IOException;
import java.io.OutputStream;

class DataSourceDataContentHandler
implements DataContentHandler {
    private DataSource ds = null;
    private ActivationDataFlavor[] transferFlavors = null;
    private DataContentHandler dch = null;

    public DataSourceDataContentHandler(DataContentHandler dch, DataSource ds2) {
        this.ds = ds2;
        this.dch = dch;
    }

    @Override
    public ActivationDataFlavor[] getTransferDataFlavors() {
        if (this.transferFlavors == null) {
            if (this.dch != null) {
                this.transferFlavors = this.dch.getTransferDataFlavors();
            } else {
                this.transferFlavors = new ActivationDataFlavor[1];
                this.transferFlavors[0] = new ActivationDataFlavor(this.ds.getContentType(), this.ds.getContentType());
            }
        }
        return this.transferFlavors;
    }

    @Override
    public Object getTransferData(ActivationDataFlavor df2, DataSource ds2) throws IOException {
        if (this.dch != null) {
            return this.dch.getTransferData(df2, ds2);
        }
        if (df2.equals(this.getTransferDataFlavors()[0])) {
            return ds2.getInputStream();
        }
        throw new IOException("Unsupported DataFlavor: " + df2);
    }

    @Override
    public Object getContent(DataSource ds2) throws IOException {
        if (this.dch != null) {
            return this.dch.getContent(ds2);
        }
        return ds2.getInputStream();
    }

    @Override
    public void writeTo(Object obj, String mimeType, OutputStream os2) throws IOException {
        if (this.dch == null) {
            throw new UnsupportedDataTypeException("no DCH for content type " + this.ds.getContentType());
        }
        this.dch.writeTo(obj, mimeType, os2);
    }
}

