/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.compression;

import io.jsonwebtoken.CompressionCodec;
import io.jsonwebtoken.CompressionException;
import io.jsonwebtoken.lang.Assert;
import java.io.IOException;

public abstract class AbstractCompressionCodec
implements CompressionCodec {
    protected abstract byte[] doCompress(byte[] var1) throws IOException;

    @Override
    public final byte[] compress(byte[] payload) {
        Assert.notNull(payload, "payload cannot be null.");
        try {
            return this.doCompress(payload);
        }
        catch (IOException e2) {
            throw new CompressionException("Unable to compress payload.", e2);
        }
    }

    @Override
    public final byte[] decompress(byte[] compressed) {
        Assert.notNull(compressed, "compressed bytes cannot be null.");
        try {
            return this.doDecompress(compressed);
        }
        catch (IOException e2) {
            throw new CompressionException("Unable to decompress bytes.", e2);
        }
    }

    protected abstract byte[] doDecompress(byte[] var1) throws IOException;
}

