/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.swe.common.constraint;

import de.fraunhofer.iosb.ilt.swe.common.Utils;
import de.fraunhofer.iosb.ilt.swe.common.constraint.AbstractConstraint;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

public class AllowedValues
extends AbstractConstraint {
    private List<BigDecimal> value;
    private List<List<BigDecimal>> interval;
    private Integer significantFigures;

    public List<BigDecimal> getValue() {
        return this.value;
    }

    public List<List<BigDecimal>> getInterval() {
        return this.interval;
    }

    public Integer getSignificantFigures() {
        return this.significantFigures;
    }

    public boolean isValid(BigDecimal input) {
        if (Utils.isNullOrEmpty(this.value) && Utils.isNullOrEmpty(this.interval) && this.significantFigures == 0) {
            return true;
        }
        if (this.value != null) {
            for (BigDecimal bigDecimal : this.value) {
                if (bigDecimal.compareTo(input) != 0) continue;
                return true;
            }
        }
        if (this.interval != null) {
            for (List list : this.interval) {
                if (((BigDecimal)list.get(0)).compareTo(input) >= 0 || ((BigDecimal)list.get(1)).compareTo(input) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public void setValue(List<BigDecimal> value) {
        this.value = value;
    }

    public void setInterval(List<List<BigDecimal>> interval) {
        this.interval = interval;
    }

    public void setSignificantFigures(Integer significantFigures) {
        this.significantFigures = significantFigures;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.value);
        hash = 17 * hash + Objects.hashCode(this.interval);
        hash = 17 * hash + Objects.hashCode(this.significantFigures);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AllowedValues other = (AllowedValues)obj;
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        if (!Objects.equals(this.interval, other.interval)) {
            return false;
        }
        return Objects.equals(this.significantFigures, other.significantFigures);
    }
}

