/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.Utils;
import de.fraunhofer.iosb.ilt.sta.jackson.ObjectMapperFactory;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.query.Expansion;
import de.fraunhofer.iosb.ilt.sta.query.QueryParameter;
import de.fraunhofer.iosb.ilt.sta.query.QueryRequest;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query<T extends Entity<T>>
implements QueryRequest<T>,
QueryParameter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Query.class);
    private final SensorThingsService service;
    private final EntityType plural;
    private final Class<T> entityClass;
    private final Entity<?> parent;
    private final List<NameValuePair> params = new ArrayList<NameValuePair>();

    public Query(SensorThingsService service, Class<T> entityClass) {
        this(service, entityClass, null);
    }

    public Query(SensorThingsService service, Class<T> entityClass, Entity<?> parent) {
        this.service = service;
        this.plural = EntityType.listForClass(entityClass);
        this.entityClass = entityClass;
        this.parent = parent;
    }

    public EntityType getEntityType() {
        return this.plural;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public SensorThingsService getService() {
        return this.service;
    }

    private void removeAllParams(String key) {
        Iterator<NameValuePair> it2 = this.params.iterator();
        while (it2.hasNext()) {
            NameValuePair param = it2.next();
            if (!param.getName().equals(key)) continue;
            it2.remove();
            break;
        }
    }

    @Override
    public Query<T> filter(String options) {
        this.removeAllParams("$filter");
        if (options.isEmpty()) {
            return this;
        }
        this.params.add(new BasicNameValuePair("$filter", options));
        return this;
    }

    @Override
    public Query<T> top(int n2) {
        this.removeAllParams("$top");
        this.params.add(new BasicNameValuePair("$top", Integer.toString(n2)));
        return this;
    }

    @Override
    public Query<T> orderBy(String clause) {
        this.removeAllParams("$orderby");
        this.params.add(new BasicNameValuePair("$orderby", clause));
        return this;
    }

    @Override
    public Query<T> skip(int n2) {
        this.removeAllParams("$skip");
        this.params.add(new BasicNameValuePair("$skip", Integer.toString(n2)));
        return this;
    }

    @Override
    public Query<T> count() {
        this.removeAllParams("$count");
        this.params.add(new BasicNameValuePair("$count", "true"));
        return this;
    }

    public Query<T> expand(Expansion expansion) {
        this.removeAllParams("$expand");
        this.params.add(new BasicNameValuePair("$expand", expansion.toString()));
        return this;
    }

    public Query<T> expand(String expansion) {
        this.removeAllParams("$expand");
        this.params.add(new BasicNameValuePair("$expand", expansion));
        return this;
    }

    public Query<T> select(String ... fields2) {
        this.removeAllParams("$select");
        if (fields2 == null) {
            return this;
        }
        StringBuilder selectValue = new StringBuilder();
        for (String field : fields2) {
            selectValue.append(field).append(",");
        }
        if (selectValue.length() == 0) {
            return this;
        }
        String select = selectValue.substring(0, selectValue.length() - 1);
        if (select.isEmpty()) {
            return this;
        }
        this.params.add(new BasicNameValuePair("$select", select));
        return this;
    }

    @Override
    public T first() throws ServiceFailureException {
        this.top(1);
        List<T> asList = this.list().toList();
        if (asList.isEmpty()) {
            return null;
        }
        return (T)((Entity)asList.get(0));
    }

    @Override
    public EntityList<T> list() throws ServiceFailureException {
        HttpGet httpGet;
        EntityList list = new EntityList(this.plural);
        try {
            URIBuilder uriBuilder = new URIBuilder(this.service.getFullPath(this.parent, this.plural).toURI());
            uriBuilder.addParameters(this.params);
            httpGet = new HttpGet(uriBuilder.build());
        }
        catch (URISyntaxException ex2) {
            throw new ServiceFailureException("Failed to fetch entities from query.", ex2);
        }
        LOGGER.debug("Fetching: {}", (Object)httpGet.getURI());
        httpGet.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        try (CloseableHttpResponse response = this.service.execute(httpGet);){
            Utils.throwIfNotOk(httpGet, response);
            String json = EntityUtils.toString(response.getEntity(), Consts.UTF_8);
            ObjectMapper mapper = ObjectMapperFactory.get();
            list = mapper.readValue(json, this.plural.getTypeReference());
        }
        catch (IOException ex3) {
            throw new ServiceFailureException("Failed to fetch entities from query.", ex3);
        }
        list.setService(this.service, this.entityClass);
        return list;
    }

    public void delete() throws ServiceFailureException {
        HttpDelete httpDelete;
        this.removeAllParams("$top");
        this.removeAllParams("$skip");
        this.removeAllParams("$count");
        this.removeAllParams("$select");
        this.removeAllParams("$expand");
        try {
            URIBuilder uriBuilder = new URIBuilder(this.service.getFullPath(this.parent, this.plural).toURI());
            uriBuilder.addParameters(this.params);
            httpDelete = new HttpDelete(uriBuilder.build());
        }
        catch (URISyntaxException ex2) {
            throw new ServiceFailureException("Failed to delete from query.", ex2);
        }
        LOGGER.debug("Deleting: {}", (Object)httpDelete.getURI());
        httpDelete.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        try (CloseableHttpResponse response = this.service.execute(httpDelete);){
            Utils.throwIfNotOk(httpDelete, response);
            EntityUtils.consumeQuietly(response.getEntity());
        }
        catch (IOException ex3) {
            throw new ServiceFailureException("Failed to delete from query.", ex3);
        }
    }
}

