/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model.builder.api;

import de.fraunhofer.iosb.ilt.sta.model.Actuator;
import de.fraunhofer.iosb.ilt.sta.model.TaskingCapability;
import de.fraunhofer.iosb.ilt.sta.model.builder.api.EntityBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class AbstractActuatorBuilder<U extends AbstractActuatorBuilder<U>>
extends EntityBuilder<Actuator, U> {
    @Override
    protected Actuator newBuildingInstance() {
        return new Actuator();
    }

    public U name(String name) {
        ((Actuator)this.getBuildingInstance()).setName(name);
        return (U)((AbstractActuatorBuilder)this.getSelf());
    }

    public U description(String description) {
        ((Actuator)this.getBuildingInstance()).setDescription(description);
        return (U)((AbstractActuatorBuilder)this.getSelf());
    }

    public U encodingType(String encodingType) {
        ((Actuator)this.getBuildingInstance()).setEncodingType(encodingType);
        return (U)((AbstractActuatorBuilder)this.getSelf());
    }

    public U encodingType(ValueCode encodingType) {
        ((Actuator)this.getBuildingInstance()).setEncodingType(encodingType.getValue());
        return (U)((AbstractActuatorBuilder)this.getSelf());
    }

    public U metadata(Object metadata) {
        ((Actuator)this.getBuildingInstance()).setMetadata(metadata);
        return (U)((AbstractActuatorBuilder)this.getSelf());
    }

    public U properties(Map<String, Object> properties) {
        ((Actuator)this.getBuildingInstance()).setProperties(properties);
        return (U)((AbstractActuatorBuilder)this.getSelf());
    }

    public U property(String key, Object value) {
        if (((Actuator)this.getBuildingInstance()).getProperties() == null) {
            ((Actuator)this.getBuildingInstance()).setProperties(new HashMap<String, Object>());
        }
        ((Actuator)this.getBuildingInstance()).getProperties().put(key, value);
        return (U)((AbstractActuatorBuilder)this.getSelf());
    }

    public U taskingCapabilities(List<TaskingCapability> taskingCapabilities) {
        ((Actuator)this.getBuildingInstance()).getTaskingCapabilities().addAll((Collection<TaskingCapability>)taskingCapabilities);
        return (U)((AbstractActuatorBuilder)this.getSelf());
    }

    public U taskingCapability(TaskingCapability taskingCapability) {
        ((Actuator)this.getBuildingInstance()).getTaskingCapabilities().add(taskingCapability);
        return (U)((AbstractActuatorBuilder)this.getSelf());
    }

    public static enum ValueCode {
        PDF("application/pdf"),
        SensorML("http://www.opengis.net/doc/IS/SensorML/2.0");

        private final String value;

        private ValueCode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static ValueCode from(String value) {
            Optional<ValueCode> result = Stream.of(ValueCode.values()).filter(x2 -> x2.value.equals(value)).findAny();
            if (!result.isPresent()) {
                throw new IllegalArgumentException("unkown value code '" + value + "'");
            }
            return result.get();
        }
    }
}

