/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.dao;

import com.github.fge.jsonpatch.JsonPatchOperation;
import de.fraunhofer.iosb.ilt.sta.MqttException;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityProperty;
import de.fraunhofer.iosb.ilt.sta.model.Id;
import de.fraunhofer.iosb.ilt.sta.query.Expansion;
import de.fraunhofer.iosb.ilt.sta.query.Query;
import de.fraunhofer.iosb.ilt.sta.service.MqttSubscription;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface Dao<T extends Entity<T>> {
    public void create(T var1) throws ServiceFailureException;

    public T find(Entity<?> var1) throws ServiceFailureException;

    public T find(Id var1) throws ServiceFailureException;

    public T find(URI var1) throws ServiceFailureException;

    public T find(Id var1, Expansion var2) throws ServiceFailureException;

    public void update(T var1) throws ServiceFailureException;

    public void patch(T var1, List<JsonPatchOperation> var2) throws ServiceFailureException;

    public void delete(T var1) throws ServiceFailureException;

    public Query<T> query();

    public MqttSubscription subscribe(Consumer<T> var1) throws MqttException;

    public MqttSubscription subscribe(Predicate<T> var1, Consumer<T> var2) throws MqttException;

    public MqttSubscription subscribe(Consumer<T> var1, EntityProperty ... var2) throws MqttException;

    public MqttSubscription subscribe(Predicate<T> var1, Consumer<T> var2, EntityProperty ... var3) throws MqttException;

    public void unsubscribe(MqttSubscription var1) throws MqttException;

    public void unsubscribe() throws MqttException;
}

