/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.property.type;

import com.fasterxml.jackson.core.type.TypeReference;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotatable;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotation;
import java.util.ArrayList;
import java.util.List;

public class PropertyType
implements Annotatable {
    private final String name;
    private final String description;
    private final TypeReference typeReference;
    private final List<Annotation> annotations = new ArrayList<Annotation>();

    public PropertyType(String name, String description, TypeReference typeReference) {
        this.name = name;
        this.description = description;
        this.typeReference = typeReference;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public TypeReference getTypeReference() {
        return this.typeReference;
    }

    public Object parseFromUrl(String input) {
        throw new IllegalArgumentException("Don't know how to parse for " + this.name);
    }

    public boolean isCollection() {
        return false;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public PropertyType addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public PropertyType addAnnotations(List<Annotation> annotationsToAdd) {
        this.annotations.addAll(annotationsToAdd);
        return this;
    }
}

