/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.property;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeEntity;
import java.util.Objects;

public class EntityPropertyCustomLink
implements Property<Entity> {
    private static final String UNSUPPORTED = "Not supported on custom properties.";
    private final String name;
    private final EntityType targetEntityType;

    public EntityPropertyCustomLink(String name, EntityType targetEntityType) {
        this.name = name;
        this.targetEntityType = targetEntityType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getJsonName() {
        return this.getName();
    }

    @Override
    public TypeEntity getType() {
        return new TypeEntity(this.targetEntityType);
    }

    public EntityType getTargetEntityType() {
        return this.targetEntityType;
    }

    @Override
    public Entity getFrom(Entity entity) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public void setOn(Entity entity, Entity value) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public boolean isSetOn(Entity entity) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityPropertyCustomLink other = (EntityPropertyCustomLink)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.targetEntityType, other.targetEntityType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.targetEntityType);
    }
}

