/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.property;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeComplex;
import java.util.Objects;

public class EntityPropertyCustom
implements EntityProperty<Object> {
    private static final String NOT_SUPPORTED = "Not supported on custom properties.";
    public final String name;

    public EntityPropertyCustom(String name) {
        String finalName = name;
        if (finalName.startsWith("[") && finalName.endsWith("]")) {
            try {
                Integer realIndex = Integer.parseInt(finalName.substring(1, finalName.length() - 1));
                finalName = realIndex.toString();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.name = finalName;
    }

    public EntityPropertyCustom() {
        this.name = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getJsonName() {
        return this.name;
    }

    @Override
    public PropertyType getType() {
        return TypeComplex.STA_OBJECT;
    }

    @Override
    public Object getFrom(Entity entity) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void setOn(Entity entity, Object value) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public boolean isSetOn(Entity entity) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityPropertyCustom other = (EntityPropertyCustom)obj;
        return Objects.equals(this.name, other.name);
    }
}

