/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.PostgresPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.QueryBuilder;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.FieldAccessor;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.Relation;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.QueryState;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.TableRef;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import org.jooq.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationOneToMany<S extends StaMainTable<S>, T extends StaMainTable<T>>
implements Relation<S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationOneToMany.class.getName());
    private final EntityType targetType;
    private final String name;
    private FieldAccessor<S> sourceFieldAccessor;
    private final T target;
    private FieldAccessor<T> targetFieldAccessor;
    private final boolean distinctRequired;

    public RelationOneToMany(NavigationPropertyMain navProp, S source, T target) {
        this(navProp.getName(), source, target, navProp.getEntityType(), navProp.isEntitySet());
    }

    public RelationOneToMany(String name, S source, T target, EntityType targetType, boolean distinctRequired) {
        if (source == null) {
            LOGGER.error("NULL source");
        }
        this.target = target;
        this.targetType = targetType;
        this.name = name;
        this.distinctRequired = distinctRequired;
    }

    public RelationOneToMany<S, T> setSourceFieldAccessor(FieldAccessor<S> sourceFieldAccessor) {
        this.sourceFieldAccessor = sourceFieldAccessor;
        return this;
    }

    public RelationOneToMany<S, T> setTargetFieldAccessor(FieldAccessor<T> targetFieldAccessor) {
        this.targetFieldAccessor = targetFieldAccessor;
        return this;
    }

    @Override
    public TableRef join(S joinSource, QueryState<?> queryState, TableRef sourceRef) {
        Field sourceField = this.sourceFieldAccessor.getField(joinSource);
        StaTable targetAliased = this.target.as(queryState.getNextAlias());
        Field targetField = this.targetFieldAccessor.getField(targetAliased);
        queryState.setSqlFrom(queryState.getSqlFrom().innerJoin(targetAliased).on(targetField.eq(sourceField)));
        if (this.distinctRequired) {
            queryState.setDistinctRequired(this.distinctRequired);
        }
        return QueryBuilder.createJoinedRef(sourceRef, this.targetType, targetAliased);
    }

    @Override
    public void link(PostgresPersistenceManager pm2, Object sourceId, Object targetId) {
        if (!this.distinctRequired) {
            throw new IllegalStateException("Trying to update a one-to-many relation from the wrong side.");
        }
        int count = pm2.getDslContext().update(this.target).set(this.targetFieldAccessor.getField(this.target), sourceId).where(this.target.getId().eq(targetId)).execute();
        if (count != 1) {
            LOGGER.error("Executing query did not result in an update!");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

