/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.parser.path;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.ASTArrayIndex;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.ASTEntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.ASTEntityType;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.ASTIdentifiedPath;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.ASTLong;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.ASTRef;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.ASTStart;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.ASTString;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.ASTSubProperty;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.ASTValue;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.ASTentityId;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.ParseException;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.Parser;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.ParserVisitor;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.SimpleNode;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.TokenMgrError;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementArrayIndex;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementCustomProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntityType;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathParser
implements ParserVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathParser.class);
    private final ModelRegistry modelRegistry;

    public static ResourcePath parsePath(ModelRegistry modelRegistry, String serviceRootUrl, Version version, String path) {
        return PathParser.parsePath(modelRegistry, serviceRootUrl, version, path, StringHelper.UTF8);
    }

    public static ResourcePath parsePath(ModelRegistry modelRegistry, String serviceRootUrl, Version version, String path, Charset encoding) {
        ResourcePath resourcePath = new ResourcePath();
        resourcePath.setServiceRootUrl(serviceRootUrl);
        resourcePath.setVersion(version);
        if (path == null) {
            resourcePath.setPath("");
            return resourcePath;
        }
        resourcePath.setPath(path);
        LOGGER.debug("Parsing: {}", (Object)path);
        ByteArrayInputStream is2 = new ByteArrayInputStream(path.getBytes(encoding));
        Parser t2 = new Parser(is2, StringHelper.UTF8.name());
        try {
            ASTStart start = t2.Start();
            PathParser v2 = new PathParser(modelRegistry);
            start.jjtAccept(v2, resourcePath);
        }
        catch (ParseException | TokenMgrError ex2) {
            throw new IllegalArgumentException("Path " + StringHelper.cleanForLogging(path) + " is not valid: " + ex2.getMessage());
        }
        return resourcePath;
    }

    public PathParser(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
    }

    public ResourcePath defltAction(SimpleNode node, ResourcePath data) {
        if (node.value == null) {
            LOGGER.debug("{}", (Object)node);
        } else {
            LOGGER.debug("{} : ({}){}", node, node.value.getClass().getSimpleName(), node.value);
        }
        node.childrenAccept(this, data);
        return data;
    }

    private void addAsEntity(ResourcePath rp, EntityType type, String id2) {
        PathElementEntity epa = new PathElementEntity(type, rp.getLastElement());
        if (id2 != null) {
            epa.setId(type.parsePrimaryKey(id2));
            rp.setIdentifiedElement(epa);
        }
        rp.addPathElement(epa, true, false);
    }

    private void addAsEntity(ResourcePath rp, NavigationPropertyMain type, String id2) {
        PathElementEntity epa;
        if (type instanceof NavigationPropertyMain.NavigationPropertyEntity) {
            epa = new PathElementEntity((NavigationPropertyMain.NavigationPropertyEntity)type, rp.getLastElement());
            if (id2 != null) {
                epa.setId(((NavigationPropertyMain.NavigationPropertyEntity)type).getEntityType().parsePrimaryKey(id2));
                rp.setIdentifiedElement(epa);
            }
        } else {
            throw new IllegalArgumentException("NavigationProperty should be of type NavigationPropertyEntity, got: " + StringHelper.cleanForLogging(type));
        }
        rp.addPathElement(epa, true, false);
    }

    private void addAsEntitySet(ResourcePath rp, EntityType type) {
        if (rp.getLastElement() != null) {
            throw new IllegalArgumentException("Adding a set by type should only happen on an empty path. Add a set by NavigationProperty instead." + rp);
        }
        PathElementEntitySet espa = new PathElementEntitySet(type);
        rp.addPathElement(espa, true, false);
    }

    private void addAsEntitySet(ResourcePath rp, NavigationPropertyMain type) {
        if (!(type instanceof NavigationPropertyMain.NavigationPropertyEntitySet)) {
            throw new IllegalArgumentException("NavigationProperty should be of type NavigationPropertyEntitySet, got: " + StringHelper.cleanForLogging(type));
        }
        PathElementEntitySet espa = new PathElementEntitySet((NavigationPropertyMain.NavigationPropertyEntitySet)type, rp.getLastElement());
        rp.addPathElement(espa, true, false);
    }

    private void addAsEntityProperty(ResourcePath rp, EntityPropertyMain type) {
        PathElementProperty ppe = new PathElementProperty();
        ppe.setProperty(type);
        ppe.setParent(rp.getLastElement());
        rp.addPathElement(ppe);
    }

    private void addAsCustomProperty(ResourcePath rp, SimpleNode node) {
        PathElementCustomProperty cppa = new PathElementCustomProperty();
        cppa.setName(node.value.toString());
        cppa.setParent(rp.getLastElement());
        rp.addPathElement(cppa);
    }

    private void addAsArrayIndex(ResourcePath rp, SimpleNode node) {
        PathElementArrayIndex cpai = new PathElementArrayIndex();
        String image = node.value.toString();
        if (!image.startsWith("[") && image.endsWith("]")) {
            throw new IllegalArgumentException("Received node is not an array index: " + StringHelper.cleanForLogging(image));
        }
        String numberString = image.substring(1, image.length() - 1);
        try {
            int index = Integer.parseInt(numberString);
            cpai.setIndex(index);
            cpai.setParent(rp.getLastElement());
            rp.addPathElement(cpai);
        }
        catch (NumberFormatException e2) {
            throw new IllegalArgumentException("Array indices must be integer values. Failed to parse: " + StringHelper.cleanForLogging(image));
        }
    }

    @Override
    public ResourcePath visit(SimpleNode node, ResourcePath data) {
        LOGGER.error("{}: acceptor not implemented in subclass?", (Object)node);
        node.childrenAccept(this, data);
        return data;
    }

    @Override
    public ResourcePath visit(ASTStart node, ResourcePath data) {
        node.childrenAccept(this, data);
        return data;
    }

    @Override
    public ResourcePath visit(ASTIdentifiedPath node, ResourcePath data) {
        return this.defltAction(node, data);
    }

    @Override
    public ResourcePath visit(ASTRef node, ResourcePath data) {
        data.setRef(true);
        return this.defltAction(node, data);
    }

    @Override
    public ResourcePath visit(ASTValue node, ResourcePath data) {
        data.setValue(true);
        return this.defltAction(node, data);
    }

    @Override
    public ResourcePath visit(ASTSubProperty node, ResourcePath data) {
        this.addAsCustomProperty(data, node);
        return this.defltAction(node, data);
    }

    @Override
    public ResourcePath visit(ASTArrayIndex node, ResourcePath data) {
        this.addAsArrayIndex(data, node);
        return this.defltAction(node, data);
    }

    @Override
    public ResourcePath visit(ASTLong node, ResourcePath data) {
        return this.defltAction(node, data);
    }

    @Override
    public ResourcePath visit(ASTString node, ResourcePath data) {
        return this.defltAction(node, data);
    }

    @Override
    public ResourcePath visit(ASTEntityType node, ResourcePath data) {
        EntityType parentType;
        PathElementEntityType parentEntity;
        PathElement parent = data.getLastElement();
        String name = node.value.toString();
        if (parent == null) {
            EntityType entityType = this.modelRegistry.getEntityTypeForName(name);
            if (entityType == null) {
                throw new IllegalArgumentException("Unknown EntityType: '" + StringHelper.cleanForLogging(name) + "'");
            }
            if (!entityType.plural.equals(name)) {
                throw new IllegalArgumentException("Path must start with an EntitySet.");
            }
            this.addAsEntitySet(data, entityType);
            return this.defltAction(node, data);
        }
        if (parent instanceof PathElementEntity) {
            parentEntity = (PathElementEntity)parent;
            parentType = ((PathElementEntity)parentEntity).getEntityType();
        } else if (parent instanceof PathElementEntitySet) {
            parentEntity = (PathElementEntitySet)parent;
            parentType = ((PathElementEntitySet)parentEntity).getEntityType();
        } else {
            throw new IllegalArgumentException("Do not know what to do with: " + StringHelper.cleanForLogging(node.value));
        }
        NavigationPropertyMain np2 = parentType.getNavigationProperty(name);
        if (np2 == null || !np2.getName().equals(name)) {
            throw new IllegalArgumentException("Entities of type " + parentType + " do not have a navigation property named " + StringHelper.cleanForLogging(node.value));
        }
        if (np2.isEntitySet()) {
            this.addAsEntitySet(data, np2);
            return this.defltAction(node, data);
        }
        this.addAsEntity(data, np2, null);
        return this.defltAction(node, data);
    }

    @Override
    public ResourcePath visit(ASTentityId node, ResourcePath data) {
        PathElement parent = data.getLastElement();
        if (parent instanceof PathElementEntitySet) {
            PathElementEntitySet parentEntitySet = (PathElementEntitySet)parent;
            this.addAsEntity(data, parentEntitySet.getEntityType(), node.value.toString());
            return this.defltAction(node, data);
        }
        throw new IllegalArgumentException("IDs must follow after EntitySets");
    }

    @Override
    public ResourcePath visit(ASTEntityProperty node, ResourcePath data) {
        PathElement parent = data.getLastElement();
        if (parent instanceof PathElementEntity) {
            PathElementEntity parentEntity = (PathElementEntity)parent;
            EntityType parentEntityType = parentEntity.getEntityType();
            EntityPropertyMain property = parentEntityType.getEntityProperty(node.value.toString());
            if (property == null) {
                throw new IllegalArgumentException("Entities of type " + parentEntityType + " do not have an entity property named " + StringHelper.cleanForLogging(node.value));
            }
            this.addAsEntityProperty(data, property);
            return this.defltAction(node, data);
        }
        throw new IllegalArgumentException("Properties must follow after Entities");
    }
}

