/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.ext;

import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeObject;
import de.fraunhofer.iosb.ilt.frostserver.property.ComplexValue;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.text.ParseException;
import java.util.Objects;
import net.time4j.Moment;
import net.time4j.range.MomentInterval;

public class TimeInterval
implements TimeObject,
ComplexValue {
    private final MomentInterval interval;

    public TimeInterval(MomentInterval interval) {
        if (interval == null) {
            throw new IllegalArgumentException("Interval must be non-null");
        }
        this.interval = interval;
    }

    public int hashCode() {
        return Objects.hash(this.interval);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeInterval other = (TimeInterval)obj;
        return Objects.equals(this.interval, other.interval);
    }

    public static TimeInterval create(Moment start, Moment end) {
        return new TimeInterval(MomentInterval.between(start, end));
    }

    public static TimeInterval parse(String value) {
        try {
            return new TimeInterval(MomentInterval.parseISO(value));
        }
        catch (ParseException ex2) {
            throw new IllegalArgumentException("Failed to parse TimeInterval " + StringHelper.cleanForLogging(value), ex2);
        }
    }

    public MomentInterval getInterval() {
        return this.interval;
    }

    @Override
    public boolean isEmpty() {
        return this.interval == null;
    }

    @Override
    public String asISO8601() {
        return StringHelper.FORMAT_INTERVAL.print(this.interval);
    }

    public String toString() {
        return this.asISO8601();
    }

    @Override
    public Object get(String name) {
        switch (name) {
            case "start": {
                return this.interval.getStartAsMoment();
            }
            case "end": {
                return this.interval.getEndAsMoment();
            }
        }
        throw new IllegalArgumentException("Unknown sub-property: " + name);
    }
}

