/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.frostserver.model.DefaultEntity;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityChangedMessage;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.model.core.NavigableElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Path;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;

public interface Entity
extends NavigableElement {
    public Id getId();

    public Entity setId(Id var1);

    public String getSelfLink();

    public Entity setSelfLink(String var1);

    @JsonIgnore
    public EntityType getEntityType();

    public Entity setEntityType(EntityType var1);

    public boolean isSetProperty(Property var1);

    public <P> P getProperty(Property<P> var1);

    public Object getProperty(Path var1);

    public <P> Entity setProperty(Property<P> var1, P var2);

    public Entity unsetProperty(Property var1);

    public Entity addNavigationEntity(Entity var1);

    public DefaultEntity addNavigationEntity(NavigationPropertyMain.NavigationPropertyEntitySet var1, Entity var2);

    default public void setEntityPropertiesSet() {
        this.setEntityPropertiesSet(true, false);
    }

    @JsonIgnore
    public void setEntityPropertiesSet(boolean var1, boolean var2);

    @JsonIgnore
    public void setEntityPropertiesSet(Entity var1, EntityChangedMessage var2);

    public void complete(PathElementEntitySet var1) throws IncompleteEntityException;

    default public void complete() throws IncompleteEntityException {
        this.complete(false);
    }

    default public void complete(boolean entityPropertiesOnly) throws IncompleteEntityException {
        EntityType type = this.getEntityType();
        for (Property property : type.getPropertySet()) {
            if (entityPropertiesOnly && !(property instanceof EntityPropertyMain) || !type.isRequired(property) || this.isSetProperty(property)) continue;
            throw new IncompleteEntityException("Missing required property '" + property.getJsonName() + "'");
        }
    }

    public Query getQuery();

    public Entity setQuery(Query var1);

    @JsonIgnore
    default public ResourcePath getPath() {
        EntityType type = this.getEntityType();
        PathElementEntity epe = new PathElementEntity(type, null);
        epe.setId(this.getId());
        ResourcePath resourcePath = new ResourcePath();
        resourcePath.addPathElement(epe, true, false);
        return resourcePath;
    }
}

