/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.messagebus;

import de.fraunhofer.iosb.ilt.frostserver.messagebus.InternalMessageBus;
import de.fraunhofer.iosb.ilt.frostserver.messagebus.MessageBus;
import de.fraunhofer.iosb.ilt.frostserver.messagebus.MqttMessageBus;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBusFactory {
    private static final String ERROR_MSG = "Could not generate MessageBus instance: ";
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageBusFactory.class);
    private static final Map<String, String> RENAME = new HashMap<String, String>();

    public static synchronized void createMessageBus(CoreSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("settings must be non-null");
        }
        MessageBus instance = settings.getMessageBus();
        if (instance == null) {
            String mbClsName = settings.getBusSettings().getBusImplementationClass();
            try {
                if (RENAME.containsKey(mbClsName)) {
                    String oldName = mbClsName;
                    mbClsName = RENAME.get(mbClsName);
                    LOGGER.warn("Using MessageBus {} instead of old name {}", (Object)mbClsName, (Object)oldName);
                }
                Class<?> messageBusClass = Class.forName(mbClsName);
                instance = (MessageBus)messageBusClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                instance.init(settings);
                settings.setMessageBus(instance);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex2) {
                throw new IllegalArgumentException("Could not generate MessageBus instance: Class '" + mbClsName + "' could not be started", ex2);
            }
        }
    }

    private MessageBusFactory() {
    }

    static {
        RENAME.put("de.fraunhofer.iosb.ilt.sta.messagebus.InternalMessageBus", InternalMessageBus.class.getName());
        RENAME.put("de.fraunhofer.iosb.ilt.sta.messagebus.MqttMessageBus", MqttMessageBus.class.getName());
    }
}

