/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.json.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.query.Expand;
import de.fraunhofer.iosb.ilt.frostserver.query.Metadata;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySerializer
extends JsonSerializer<Entity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntitySerializer.class.getName());
    private final String countField;
    private final String navLinkField;
    private final String nextLinkField;
    private final boolean serialiseAllNulls;
    private final Map<EntityPropertyMain, SimplePropertySerializer> propertySerializers = new HashMap<EntityPropertyMain, SimplePropertySerializer>();
    private final Map<PropertyType, SimplePropertySerializer> propertyTypeSerializers = new HashMap<PropertyType, SimplePropertySerializer>();

    public EntitySerializer() {
        this(false, "@iot.count", "@iot.navigationLink", "@iot.nextLink", "@iot.selfLink");
    }

    public EntitySerializer(boolean nulls, String countField, String navLinkField, String nextLinkField, String selfLinkField) {
        this.countField = countField;
        this.navLinkField = navLinkField;
        this.nextLinkField = nextLinkField;
        this.serialiseAllNulls = nulls;
        this.propertySerializers.put(ModelRegistry.EP_SELFLINK, (ep2, entity, gen) -> {
            String value;
            if (entity.getQuery().getMetadata() == Metadata.FULL && (value = entity.getSelfLink()) != null) {
                gen.writeStringField(selfLinkField, value);
            }
        });
    }

    @Override
    public void serialize(Entity entity, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        try {
            this.writeContent(entity, gen);
        }
        catch (IOException | RuntimeException exc) {
            LOGGER.error("Failed to serialise entity.", exc);
            throw new IOException("could not serialize Entity");
        }
        finally {
            gen.writeEndObject();
        }
    }

    public void writeContent(Entity entity, JsonGenerator gen) throws IOException {
        Set<Object> navigationProps;
        Query query = entity.getQuery();
        Metadata metadata = Metadata.DEFAULT;
        if (query == null) {
            LOGGER.error("Received entity without Query: {}", (Object)entity);
            throw new IllegalArgumentException("Entity without query.");
        }
        metadata = query.getMetadata();
        switch (metadata) {
            case OFF: 
            case NONE: 
            case MINIMAL: {
                navigationProps = Collections.emptySet();
                break;
            }
            case INTERNAL_COMPARE: {
                navigationProps = query.getSelectNavProperties(query.hasParentExpand());
                break;
            }
            default: {
                navigationProps = query.getSelectNavProperties(query.hasParentExpand());
            }
        }
        Set<EntityPropertyMain> entityProps = query.getSelectMainEntityProperties(query.hasParentExpand());
        List<Expand> expand = query.getExpand();
        for (EntityPropertyMain entityPropertyMain : entityProps) {
            this.writeProperty(entityPropertyMain, entity, gen);
        }
        if (expand != null) {
            this.writeExpand(expand, entity, gen);
        }
        for (NavigationPropertyMain navigationPropertyMain : navigationProps) {
            String navigationLink = navigationPropertyMain.getNavigationLink(entity);
            if (navigationLink != null && (navigationPropertyMain.isEntitySet() || entity.getProperty(navigationPropertyMain) != null)) {
                gen.writeStringField(navigationPropertyMain.getName() + this.navLinkField, navigationLink);
            }
            if (metadata != Metadata.INTERNAL_COMPARE) continue;
            this.writeExpand(null, entity, navigationPropertyMain, gen);
        }
    }

    public void writeProperty(EntityPropertyMain ep2, Entity entity, JsonGenerator gen) throws IOException {
        SimplePropertySerializer ser = this.propertySerializers.get(ep2);
        if (ser != null) {
            ser.writeProperty(ep2, entity, gen);
            return;
        }
        ser = this.propertyTypeSerializers.get(ep2.getType());
        if (ser != null) {
            ser.writeProperty(ep2, entity, gen);
            return;
        }
        Object value = entity.getProperty(ep2);
        if (this.serialiseAllNulls || value != null || ep2.serialiseNull) {
            String name = ep2.name;
            if (this.serialiseAllNulls && "@iot.id".equals(name)) {
                gen.writeObjectField("id", value);
            } else {
                gen.writeObjectField(name, value);
            }
        }
    }

    private void writeExpand(List<Expand> expand, Entity entity, JsonGenerator gen) throws IOException {
        for (Expand exp : expand) {
            NavigationProperty np2 = exp.getPath();
            if (!(np2 instanceof NavigationPropertyMain)) continue;
            this.writeExpand(exp, entity, (NavigationPropertyMain)np2, gen);
        }
    }

    private void writeExpand(Expand exp, Entity entity, NavigationPropertyMain np2, JsonGenerator gen) throws IOException {
        Object entityOrSet = np2.getFrom(entity);
        if (np2.isEntitySet()) {
            EntitySet entitySet = (EntitySet)entityOrSet;
            this.writeEntitySet(np2, entitySet, gen, exp.getSubQuery());
        } else {
            Entity expandedEntity = (Entity)entityOrSet;
            if (expandedEntity == null) {
                if (this.serialiseAllNulls) {
                    gen.writeNullField(np2.getJsonName());
                }
            } else {
                if (expandedEntity.getQuery() == null && exp != null) {
                    expandedEntity.setQuery(exp.getSubQuery());
                }
                gen.writeObjectField(np2.getJsonName(), entityOrSet);
            }
        }
    }

    private void writeEntitySet(NavigationProperty np2, EntitySet entitySet, JsonGenerator gen, Query query) throws IOException {
        String nextLink;
        String jsonName = np2.getJsonName();
        if (entitySet == null) {
            gen.writeArrayFieldStart(jsonName);
            gen.writeEndArray();
            return;
        }
        long count = entitySet.getCount();
        if (count >= 0L) {
            gen.writeNumberField(jsonName + this.countField, count);
        }
        gen.writeArrayFieldStart(jsonName);
        for (Object child : entitySet) {
            gen.writeObject(child);
        }
        gen.writeEndArray();
        if (query.getMetadata() != Metadata.OFF && (nextLink = entitySet.getNextLink()) != null) {
            gen.writeStringField(jsonName + this.nextLinkField, nextLink);
        }
    }

    public <P> EntitySerializer addPropertySerializer(EntityPropertyMain<P> property, SimplePropertySerializer serializer) {
        this.propertySerializers.put(property, serializer);
        return this;
    }

    public EntitySerializer addPropertyTypeSerializer(PropertyType propertyType, SimplePropertySerializer serializer) {
        this.propertyTypeSerializers.put(propertyType, serializer);
        return this;
    }

    public static interface SimplePropertySerializer {
        public void writeProperty(EntityPropertyMain var1, Entity var2, JsonGenerator var3) throws IOException;
    }
}

