/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.json.deserialize.custom;

import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.custom.CustomDeserializer;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.custom.DefaultDeserializer;
import java.util.HashMap;
import java.util.Map;

public class CustomDeserializationManager {
    private static CustomDeserializationManager instance;
    private final Map<String, CustomDeserializer> customDeserializers = new HashMap<String, CustomDeserializer>();

    private CustomDeserializationManager() {
    }

    public static CustomDeserializationManager getInstance() {
        if (instance == null) {
            instance = new CustomDeserializationManager();
        }
        return instance;
    }

    public void registerDeserializer(String encodingType, CustomDeserializer deserializer) {
        this.customDeserializers.put(encodingType, deserializer);
    }

    public CustomDeserializer getDeserializer(String encodingType) {
        CustomDeserializer result = null;
        if (this.customDeserializers.containsKey(encodingType)) {
            result = this.customDeserializers.get(encodingType);
        }
        if (result == null) {
            result = new DefaultDeserializer();
        }
        return result;
    }
}

