/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.json.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.TimeInstantDeserializer;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.TimeIntervalDeserializer;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.TimeValueDeserializer;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.custom.CustomDeserializationManager;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.custom.CustomEntityChangedMessageDeserializer;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.custom.CustomEntityDeserializer;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.custom.GeoJsonDeserializier;
import de.fraunhofer.iosb.ilt.frostserver.json.mixin.MixinUtils;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityChangedMessage;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySetImpl;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeValue;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class JsonReader {
    private static final Map<ModelRegistry, ObjectMapper> mappers = new HashMap<ModelRegistry, ObjectMapper>();
    private final ObjectMapper mapper;
    private final ModelRegistry modelRegistry;

    private static ObjectMapper getObjectMapper(ModelRegistry modelRegistry) {
        return mappers.computeIfAbsent(modelRegistry, JsonReader::createObjectMapper);
    }

    private static ObjectMapper createObjectMapper(ModelRegistry modelRegistry) {
        GeoJsonDeserializier geoJsonDeserializier = new GeoJsonDeserializier();
        for (String encodingType : GeoJsonDeserializier.ENCODINGS) {
            CustomDeserializationManager.getInstance().registerDeserializer(encodingType, geoJsonDeserializier);
        }
        ObjectMapper mapper = new ObjectMapper().enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        MixinUtils.addMixins(mapper);
        SimpleModule module = new SimpleModule();
        module.addAbstractTypeMapping(EntitySet.class, EntitySetImpl.class);
        for (EntityType entityType : modelRegistry.getEntityTypes()) {
            CustomEntityDeserializer.getInstance(modelRegistry, entityType);
        }
        module.addDeserializer(EntityChangedMessage.class, new CustomEntityChangedMessageDeserializer(modelRegistry));
        module.addDeserializer(TimeInstant.class, new TimeInstantDeserializer());
        module.addDeserializer(TimeInterval.class, new TimeIntervalDeserializer());
        module.addDeserializer(TimeValue.class, new TimeValueDeserializer());
        mapper.registerModule(module);
        return mapper;
    }

    public JsonReader(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
        this.mapper = JsonReader.getObjectMapper(modelRegistry);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public Entity parseEntity(EntityType entityType, String value) throws IOException {
        Entity entity;
        block8: {
            JsonParser parser = this.mapper.createParser(value);
            try {
                DefaultDeserializationContext dsc = (DefaultDeserializationContext)this.mapper.getDeserializationContext();
                dsc = dsc.createInstance(this.mapper.getDeserializationConfig(), parser, this.mapper.getInjectableValues());
                entity = CustomEntityDeserializer.getInstance(this.modelRegistry, entityType).deserializeFull(parser, dsc);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StackOverflowError err) {
                    throw new IOException("Json is too deeply nested.");
                }
            }
            parser.close();
        }
        return entity;
    }

    public Entity parseEntity(EntityType entityType, Reader value) throws IOException {
        Entity entity;
        block8: {
            JsonParser parser = this.mapper.createParser(value);
            try {
                DefaultDeserializationContext dsc = (DefaultDeserializationContext)this.mapper.getDeserializationContext();
                dsc = dsc.createInstance(this.mapper.getDeserializationConfig(), parser, this.mapper.getInjectableValues());
                entity = CustomEntityDeserializer.getInstance(this.modelRegistry, entityType).deserializeFull(parser, dsc);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StackOverflowError err) {
                    throw new IOException("Json is too deeply nested.");
                }
            }
            parser.close();
        }
        return entity;
    }

    public <T> T parseObject(Class<T> clazz, String value) throws IOException {
        return this.mapper.readValue(value, clazz);
    }

    public <T> T parseObject(Class<T> clazz, Reader value) throws IOException {
        return this.mapper.readValue(value, clazz);
    }

    public <T> T parseObject(TypeReference<T> typeReference, String value) throws IOException {
        return this.mapper.readValue(value, typeReference);
    }

    public <T> T parseObject(TypeReference<T> typeReference, Reader value) throws IOException {
        return this.mapper.readValue(value, typeReference);
    }
}

