/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.swing;

import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorPassword;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public final class FactoryStringSwing
implements GuiFactorySwing {
    private final EditorString parentEditor;
    private JTextComponent swText;
    private JComponent swComponent;
    private boolean passwordControl;

    public FactoryStringSwing(EditorString parentEditor) {
        this.parentEditor = parentEditor;
        if (parentEditor instanceof EditorPassword) {
            this.passwordControl = true;
        }
    }

    @Override
    public JComponent getComponent() {
        if (this.swComponent == null) {
            this.createComponent();
        }
        return this.swComponent;
    }

    private void createComponent() {
        if (this.passwordControl) {
            this.swText = new JPasswordField();
            this.swComponent = this.swText;
        } else if (this.parentEditor.getLines() == 1) {
            this.swText = new JTextField();
            this.swComponent = this.swText;
        } else {
            JTextArea textArea = new JTextArea();
            this.swText = textArea;
            textArea.setRows(this.parentEditor.getLines());
            textArea.setLineWrap(true);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(textArea);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)jScrollPane, "Center");
            this.swComponent = panel;
        }
        this.fillComponent();
    }

    public void fillComponent() {
        this.swText.setEditable(this.parentEditor.canEdit());
        this.swText.setText(this.parentEditor.getRawValue());
    }

    public void readComponent() {
        this.parentEditor.setRawValue(this.swText.getText());
    }
}

