/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.fx;

import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorSubclass;
import de.fraunhofer.iosb.ilt.configurable.editor.fx.FilteringComboBox;
import java.util.List;
import java.util.Set;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;

public final class FactorySubclsFx
implements GuiFactoryFx {
    private final EditorSubclass<?, ?, ?> parentEditor;
    private EditorSubclass.classItem item;
    private String selectLabel = "Type:";
    private BorderPane fxPaneRoot;
    private BorderPane fxPaneItem;
    private ComboBox<String> fxItems;
    private FlowPane controls;

    public FactorySubclsFx(EditorSubclass<?, ?, ?> parentEditor) {
        this.parentEditor = parentEditor;
    }

    @Override
    public Pane getNode() {
        if (this.fxPaneRoot == null) {
            this.createGui();
        }
        return this.fxPaneRoot;
    }

    private void createGui() {
        String jsonName = this.parentEditor.getJsonName();
        this.item = this.parentEditor.findClassItem(jsonName);
        this.createPane();
    }

    private void createPane() {
        Set<String> values = this.parentEditor.getClassesByDisplayName().keySet();
        this.controls = new FlowPane();
        this.controls.setAlignment(Pos.TOP_CENTER);
        this.controls.getChildren().add(new Label(this.selectLabel));
        this.fxItems = new FilteringComboBox<String>((List<String>)FXCollections.observableArrayList(values));
        this.fxItems.setEditable(true);
        if (this.item != null) {
            this.fxItems.getSelectionModel().select(this.item.displayName);
        }
        this.controls.getChildren().add(this.fxItems);
        Button addButton = new Button("set");
        addButton.setOnAction(event -> this.setItem());
        this.controls.getChildren().add(addButton);
        this.fxPaneItem = new BorderPane();
        this.fxPaneItem.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        this.fxPaneRoot = new BorderPane();
        this.fxPaneRoot.setStyle("    -fx-border-base: gray;    -fx-border-shadow: white;    -fx-light-border: derive(-fx-border-base, 25%);    -fx-border-color: -fx-light-border -fx-border-base -fx-border-base -fx-light-border;    -fx-border-insets: 0 1 1 0;    -fx-background-color: -fx-border-shadow, -fx-background;    -fx-background-insets: 1 0 0 1, 2;    -fx-padding: 2;");
        this.fxPaneRoot.setCenter(this.fxPaneItem);
        this.fxPaneRoot.setTop(this.controls);
        this.fillComponent();
    }

    private void setItem() {
        String selected = (String)this.fxItems.getSelectionModel().getSelectedItem();
        if (selected != null && !selected.isEmpty()) {
            this.item = this.parentEditor.getClassesByDisplayName().get(selected);
            if (this.item == null) {
                if (!this.parentEditor.isRestrictedClasses()) {
                    this.parentEditor.setJsonName(selected);
                }
            } else {
                this.parentEditor.setJsonName(this.item.jsonName);
            }
        }
    }

    public void fillComponent() {
        this.controls.setVisible(this.parentEditor.canEdit());
        String jsonName = this.parentEditor.getJsonName();
        this.item = this.parentEditor.findClassItem(jsonName);
        ConfigEditor classEditor = this.parentEditor.getClassEditor();
        String label = jsonName == null || jsonName.isEmpty() ? "No Class selected." : (this.item == null ? "Manual: " + jsonName : "Selected: " + this.item.displayName);
        this.fxPaneItem.getChildren().clear();
        this.fxPaneItem.setTop(new Label(label));
        if (classEditor == null) {
            Label noConf = new Label("Nothing to be configured.");
            this.fxPaneItem.setCenter(noConf);
        } else {
            this.fxPaneItem.setCenter(classEditor.getGuiFactoryFx().getNode());
        }
    }

    public void setSelectLabel(String selectLabel) {
        this.selectLabel = selectLabel;
    }
}

