/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditors;
import de.fraunhofer.iosb.ilt.configurable.Configurable;
import de.fraunhofer.iosb.ilt.configurable.ConfigurableFactory;
import de.fraunhofer.iosb.ilt.configurable.ConfigurationException;
import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.ItemObject;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.ItemRef;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.ItemString;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.RootSchema;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.SchemaItem;
import de.fraunhofer.iosb.ilt.configurable.Reflection;
import de.fraunhofer.iosb.ilt.configurable.Utils;
import de.fraunhofer.iosb.ilt.configurable.annotations.AnnotationHelper;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableClass;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorDefault;
import de.fraunhofer.iosb.ilt.configurable.editor.fx.FactorySubclsFx;
import de.fraunhofer.iosb.ilt.configurable.editor.swing.FactorySubclsSwing;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorSubclass<C, D, T>
extends EditorDefault<T> {
    private static final String KEY_CLASSNAME = "className";
    private static final String KEY_CLASSCONFIG = "classConfig";
    private static final Logger LOGGER = LoggerFactory.getLogger(EditorSubclass.class);
    private Map<String, classItem> classesByClassName = new HashMap<String, classItem>();
    private Map<String, classItem> classesByJsonName = new HashMap<String, classItem>();
    private Map<String, classItem> classesByDisplayName = new TreeMap<String, classItem>();
    private Class<?> iface;
    private Class<? extends Annotation> requiredAnnotation = NoFilter.class;
    private List<Class<? extends Annotation>> allowList = new ArrayList<Class<? extends Annotation>>();
    private List<Class<? extends Annotation>> denyList = new ArrayList<Class<? extends Annotation>>();
    private boolean merge = false;
    private boolean shortenClassNames = false;
    private boolean restrictedClasses = true;
    private String nameField = "className";
    private String jsonName = "";
    private JsonElement classConfig;
    private T instance;
    private ConfigEditor classEditor;
    private C context;
    private D edtCtx;
    private String selectLabel = "Type:";
    public Set<String> profilesEdit = AnnotationHelper.csvToReadOnlySet("");
    private String profile = "default";
    private FactorySubclsSwing factorySwing;
    private FactorySubclsFx factoryFx;

    public EditorSubclass() {
    }

    public EditorSubclass(C context, D edtCtx, Class<? extends T> iface, boolean merge, String nameField) {
        this(context, edtCtx, iface, "", "", merge, nameField);
    }

    public EditorSubclass(C context, D edtCtx, Class<? extends T> iface, String label, String description) {
        this(context, edtCtx, iface, label, description, false, KEY_CLASSNAME);
    }

    public EditorSubclass(C context, D edtCtx, Class<? extends T> iface, String label, String description, boolean merge, String nameField) {
        this.iface = iface;
        this.merge = merge;
        this.nameField = nameField;
        this.setLabel(label);
        this.setDescription(description);
        this.setContexts(context, edtCtx);
    }

    @Override
    public void initFor(Field field) {
        EdOptsSubclass annotation = field.getAnnotation(EdOptsSubclass.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Field must have an EdOptsSubclass annotation to use this editor: " + field.getName());
        }
        this.iface = annotation.iface();
        this.merge = annotation.merge();
        this.nameField = annotation.nameField();
        this.requiredAnnotation = annotation.requiredAnnotation();
        for (Class<? extends Annotation> anno : annotation.allowList()) {
            this.allowList.add(anno);
        }
        for (Class<? extends Annotation> anno : annotation.denyList()) {
            this.denyList.add(anno);
        }
        this.restrictedClasses = annotation.restrictedClasses();
        this.shortenClassNames = annotation.shortenClassNames();
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(annotation.profilesEdit());
    }

    public final void setContexts(C context, D edtCtx) {
        this.context = context;
        this.edtCtx = edtCtx;
    }

    @Override
    public JsonElement getConfig() {
        JsonObject result;
        this.readComponent();
        if (this.merge && this.classConfig != null && this.classConfig.isJsonObject()) {
            result = new JsonObject();
            result.add(this.nameField, new JsonPrimitive(this.jsonName));
            for (Map.Entry<String, JsonElement> entry : this.classConfig.getAsJsonObject().entrySet()) {
                result.add(entry.getKey(), entry.getValue());
            }
        } else {
            result = new JsonObject();
            result.add(KEY_CLASSNAME, new JsonPrimitive(this.jsonName));
            result.add(KEY_CLASSCONFIG, this.classConfig);
        }
        return result;
    }

    @Override
    public void setConfig(JsonElement config) {
        String name = null;
        this.jsonName = "";
        if (config == null || !config.isJsonObject()) {
            this.classConfig = null;
        } else {
            JsonObject confObj = config.getAsJsonObject();
            if (this.merge) {
                JsonElement classNameElem = confObj.get(this.nameField);
                if (classNameElem != null && classNameElem.isJsonPrimitive()) {
                    name = classNameElem.getAsString();
                }
                this.classConfig = confObj;
            } else {
                JsonElement classNameElem = confObj.get(KEY_CLASSNAME);
                if (classNameElem != null && classNameElem.isJsonPrimitive()) {
                    name = classNameElem.getAsString();
                }
                this.classConfig = confObj.get(KEY_CLASSCONFIG);
            }
        }
        this.setJsonName(name);
    }

    public JsonElement getClassConfig() {
        return this.classConfig;
    }

    public void setClassConfig(JsonElement classConfig) {
        this.classConfig = classConfig;
    }

    @Override
    public SchemaItem getJsonSchema(RootSchema rootSchema) {
        ItemObject myItem;
        this.initClasses();
        SchemaItem retval = myItem = ((ItemObject)((ItemObject)new ItemObject().setTitle(this.getLabel())).setDescription(this.getDescription())).setAdditionalProperties(true);
        if (rootSchema == null) {
            rootSchema = new RootSchema(myItem);
            retval = rootSchema;
        }
        ArrayList<SchemaItem> oneOfs = new ArrayList<SchemaItem>();
        for (Map.Entry<String, classItem> classEntry : this.classesByJsonName.entrySet()) {
            classItem classItem2 = classEntry.getValue();
            String itemClassName = classItem2.className;
            String itemJsonName = classItem2.jsonName;
            if (!rootSchema.hasDef(itemClassName)) {
                rootSchema.addDef(itemClassName, new ItemRef(itemClassName));
                SchemaItem itemSchema = this.createClassEditor(classItem2.jsonName, this.context, this.edtCtx).getJsonSchema(rootSchema);
                rootSchema.addDef(itemClassName, itemSchema);
            }
            oneOfs.add(((ItemObject)new ItemObject().setTitle(classItem2.displayName)).addProperty(KEY_CLASSNAME, false, new ItemString().addAllowedValue(itemJsonName).addOption("hidden", true)).addProperty(KEY_CLASSCONFIG, false, new ItemRef(itemClassName)));
        }
        myItem.setOneOf(oneOfs);
        return retval;
    }

    @Override
    public GuiFactorySwing getGuiFactorySwing() {
        if (this.factoryFx != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factorySwing == null) {
            this.factorySwing = new FactorySubclsSwing(this);
            this.factorySwing.setSelectLabel(this.selectLabel);
        }
        return this.factorySwing;
    }

    @Override
    public GuiFactoryFx getGuiFactoryFx() {
        if (this.factorySwing != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factoryFx == null) {
            this.factoryFx = new FactorySubclsFx(this);
            this.factoryFx.setSelectLabel(this.selectLabel);
        }
        return this.factoryFx;
    }

    private void fillComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.fillComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.fillComponent();
        }
    }

    public String getJsonName() {
        return this.jsonName;
    }

    public ConfigEditor getClassEditor() {
        return this.classEditor;
    }

    public Map<String, classItem> getClassesByClassName() {
        this.initClasses();
        return this.classesByClassName;
    }

    public Map<String, classItem> getClassesByDisplayName() {
        this.initClasses();
        return this.classesByDisplayName;
    }

    public Map<String, classItem> getClassesByJsonName() {
        this.initClasses();
        return this.classesByJsonName;
    }

    private boolean isAllowed(Class<?> subtype) {
        if (this.allowList.isEmpty()) {
            return true;
        }
        for (Class<? extends Annotation> annotation : this.allowList) {
            if (subtype.getAnnotation(annotation) == null) continue;
            LOGGER.debug("Allowing class {}, annotated with {}.", (Object)subtype, (Object)annotation);
            return true;
        }
        LOGGER.debug("Not Allowing class {}, not annotated with any of the allowList annotations.", (Object)subtype);
        return false;
    }

    private boolean isDenied(Class<?> subtype) {
        if (this.denyList.isEmpty()) {
            return false;
        }
        for (Class<? extends Annotation> annotation : this.denyList) {
            if (subtype.getAnnotation(annotation) == null) continue;
            LOGGER.debug("Ignoring class {}, annotated with {}.", (Object)subtype, (Object)annotation);
            return true;
        }
        return false;
    }

    private void initClasses() {
        if (!this.classesByJsonName.isEmpty()) {
            return;
        }
        List<Class<?>> subtypes = Reflection.getSubtypesOf(this.iface, false, true);
        for (Class<?> subtype : subtypes) {
            if (this.requiredAnnotation != NoFilter.class && subtype.getAnnotation(this.requiredAnnotation) == null) {
                LOGGER.debug("Ignoring class {}, not annotated with {}.", (Object)subtype, (Object)this.requiredAnnotation);
                continue;
            }
            if (!this.isAllowed(subtype) || this.isDenied(subtype)) continue;
            classItem item = new classItem(subtype.getName());
            ConfigurableClass annotation = subtype.getAnnotation(ConfigurableClass.class);
            if (annotation != null) {
                if (!annotation.jsonName().isEmpty()) {
                    item.displayName = item.jsonName = annotation.jsonName();
                }
                if (!annotation.displayName().isEmpty()) {
                    item.displayName = annotation.displayName();
                }
            }
            if (this.classesByJsonName.containsKey(item.displayName)) {
                classItem conflict = this.classesByJsonName.get(item.displayName);
                LOGGER.warn("Name conflict, a class with jsonName {} already exists. {} and {}.", item.jsonName, conflict.className, item.jsonName);
                item.displayName = item.className;
            }
            this.classesByJsonName.put(item.jsonName, item);
            this.classesByClassName.put(item.className, item);
        }
        if (this.shortenClassNames) {
            this.findPrefix();
        }
        for (classItem item : this.classesByJsonName.values()) {
            if (this.classesByDisplayName.containsKey(item.displayName)) {
                classItem conflict = this.classesByDisplayName.get(item.displayName);
                LOGGER.warn("Name conflict, a class with displayName {} already exists. {} and {}.", item.displayName, conflict.className, item.className);
                item.displayName = item.className;
            }
            this.classesByDisplayName.put(item.displayName, item);
        }
    }

    private void findPrefix() {
        if (this.classesByJsonName.isEmpty()) {
            return;
        }
        String prefix = null;
        for (classItem item : this.classesByJsonName.values()) {
            if (prefix == null) {
                prefix = this.shortenPrefix(item.displayName);
                continue;
            }
            while (!prefix.isEmpty() && !item.displayName.startsWith(prefix)) {
                prefix = this.shortenPrefix(prefix);
            }
            if (!prefix.isEmpty()) continue;
            break;
        }
        LOGGER.debug("Found prefix to be: {}", (Object)prefix);
        for (classItem item : this.classesByJsonName.values()) {
            item.displayName = item.displayName.substring(prefix.length());
        }
    }

    private String shortenPrefix(String prefix) {
        int idx = prefix.lastIndexOf(46, prefix.length() - 2);
        if (idx == -1) {
            return "";
        }
        return prefix.substring(0, idx + 1);
    }

    private ConfigEditor createClassEditor(String jsonName, C context, D edtCtx) {
        ConfigurableFactory factory = this.findFactory(context, edtCtx);
        try {
            Class<?> subclassType = factory.loadClass(jsonName);
            return ConfigEditors.buildEditorFromClass(subclassType, context, edtCtx).orElse(null);
        }
        catch (ClassNotFoundException exc) {
            LOGGER.warn("Exception loading class {}.", (Object)jsonName);
            LOGGER.debug("Exception loading class.", exc);
            try {
                Object tempInstance = factory.instantiate(jsonName, this.classConfig, context, edtCtx);
                if (tempInstance instanceof Configurable) {
                    Configurable confInstance = (Configurable)tempInstance;
                    return confInstance.getConfigEditor(context, edtCtx);
                }
            }
            catch (ConfigurationException exc2) {
                LOGGER.warn("Exception instantiating class {}.", (Object)jsonName);
                LOGGER.debug("Exception instantiating class.", exc2);
            }
            return null;
        }
    }

    public void setJsonName(String name) {
        if (Utils.isNullOrEmpty(name)) {
            LOGGER.debug("Empty class name.");
            this.instance = null;
            this.classEditor = null;
            this.fillComponent();
            return;
        }
        if (name.equals(this.jsonName)) {
            return;
        }
        this.jsonName = name;
        this.instance = null;
        if (!Utils.isNullOrEmpty(this.jsonName)) {
            ConfigurableFactory factory = this.findFactory(this.context, this.edtCtx);
            try {
                Class<?> subclassType = factory.loadClass(this.jsonName);
                this.classEditor = ConfigEditors.buildEditorFromClass(subclassType, this.context, this.edtCtx).orElse(null);
            }
            catch (ClassNotFoundException exc) {
                LOGGER.warn("Exception loading class {}.", (Object)this.jsonName);
                LOGGER.debug("Exception loading class.", exc);
            }
            if (this.classEditor == null) {
                try {
                    this.instance = factory.instantiate(this.jsonName, this.classConfig, this.context, this.edtCtx);
                }
                catch (ConfigurationException exc) {
                    LOGGER.warn("Exception instantiating class {}.", (Object)this.jsonName);
                    LOGGER.debug("Exception instantiating class.", exc);
                }
            }
        }
        if (this.instance instanceof Configurable) {
            Configurable confInstance = (Configurable)this.instance;
            this.classEditor = confInstance.getConfigEditor(this.context, this.edtCtx);
        }
        if (this.classEditor == null) {
            LOGGER.warn("Class {} is not configurable.", (Object)this.jsonName);
        } else {
            this.classEditor.setConfig(this.classConfig);
            this.classEditor.setProfile(this.profile);
        }
        this.fillComponent();
    }

    public String findClassName(String from) {
        classItem item = this.findClassItem(from);
        if (item == null) {
            return from;
        }
        return item.className;
    }

    public classItem findClassItem(String from) {
        if (Utils.isNullOrEmpty(from)) {
            return null;
        }
        this.initClasses();
        classItem item = this.classesByJsonName.get(from);
        if (item != null) {
            LOGGER.debug("Mapping {} to {}.", (Object)from, (Object)item.className);
            return item;
        }
        item = this.classesByDisplayName.get(from);
        if (item != null) {
            LOGGER.debug("Mapping {} to {}.", (Object)from, (Object)item.className);
            return item;
        }
        for (classItem clazz : this.classesByJsonName.values()) {
            if (!clazz.className.endsWith(from)) continue;
            return clazz;
        }
        return null;
    }

    private void readComponent() {
        if (this.classEditor != null) {
            this.classConfig = this.classEditor.getConfig();
        }
    }

    @Override
    public T getValue() throws ConfigurationException {
        this.readComponent();
        if (Utils.isNullOrEmpty(this.jsonName)) {
            return null;
        }
        if (this.instance == null) {
            this.instance = this.tryToInstantiate();
        } else if (this.instance instanceof Configurable) {
            Configurable confInstance = (Configurable)this.instance;
            confInstance.configure(this.classConfig, this.context, this.edtCtx, this.classEditor);
        }
        return this.instance;
    }

    private T tryToInstantiate() throws ConfigurationException {
        try {
            return this.instantiate();
        }
        catch (IllegalArgumentException | ReflectiveOperationException exc) {
            throw new ConfigurationException(exc);
        }
    }

    private T instantiate() throws ReflectiveOperationException, ConfigurationException, IllegalArgumentException {
        ConfigurableFactory factory = this.findFactory(this.context, this.edtCtx);
        Class<?> subclassClass = factory.loadClass(this.jsonName);
        Optional<Constructor<?>> configurableConstructor = AnnotationHelper.getConfigurableConstructor(subclassClass);
        if (configurableConstructor.isPresent()) {
            return AnnotationHelper.instantiateFrom(configurableConstructor.get(), this.classConfig, this.context, this.edtCtx);
        }
        return (T)factory.instantiate(this.jsonName, this.classConfig, this.context, this.edtCtx);
    }

    @Override
    public void setValue(T value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public EditorSubclass<C, D, T> setSelectLabel(String selectLabel) {
        this.selectLabel = selectLabel;
        return this;
    }

    public boolean testConfig(JsonElement config) {
        if (config == null || !config.isJsonObject()) {
            return false;
        }
        JsonObject confObj = config.getAsJsonObject();
        if (this.merge) {
            JsonElement classNameElem = confObj.get(this.nameField);
            if (classNameElem == null || !classNameElem.isJsonPrimitive()) {
                return false;
            }
        } else {
            JsonElement classNameElem = confObj.get(KEY_CLASSNAME);
            if (classNameElem == null || !classNameElem.isJsonPrimitive()) {
                return false;
            }
            if (!confObj.has(KEY_CLASSCONFIG)) {
                return false;
            }
        }
        return true;
    }

    public Class<?> getIface() {
        return this.iface;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public String getNameField() {
        return this.nameField;
    }

    public void setNameField(String nameField) {
        this.nameField = nameField;
    }

    public Class<? extends Annotation> getRequiredAnnotation() {
        return this.requiredAnnotation;
    }

    public void setRequiredAnnotation(Class<? extends Annotation> requiredAnnotation) {
        this.requiredAnnotation = requiredAnnotation;
    }

    public List<Class<? extends Annotation>> getAllowList() {
        return this.allowList;
    }

    public void setAllowList(List<Class<? extends Annotation>> allowList) {
        this.allowList = allowList;
    }

    public List<Class<? extends Annotation>> getDenyList() {
        return this.denyList;
    }

    public void setDenyList(List<Class<? extends Annotation>> denyList) {
        this.denyList = denyList;
    }

    public boolean isRestrictedClasses() {
        return this.restrictedClasses;
    }

    public void setRestrictedClasses(boolean restrictedClasses) {
        this.restrictedClasses = restrictedClasses;
    }

    public void setProfilesEdit(String csv) {
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(csv);
    }

    @Override
    public void setProfile(String profile) {
        this.profile = profile;
        if (this.classEditor != null) {
            this.classEditor.setProfile(profile);
        }
    }

    @Override
    public boolean canEdit() {
        return this.profilesEdit.contains(this.profile);
    }

    private ConfigurableFactory findFactory(C context, D edtCtx) {
        if (edtCtx instanceof ConfigurableFactory) {
            return (ConfigurableFactory)edtCtx;
        }
        if (context instanceof ConfigurableFactory) {
            return (ConfigurableFactory)context;
        }
        return new FactoryImp();
    }

    private class FactoryImp
    implements ConfigurableFactory {
        private FactoryImp() {
        }

        private Class<? extends T> loadClass() throws ReflectiveOperationException, ConfigurationException {
            if (Utils.isNullOrEmpty(EditorSubclass.this.jsonName)) {
                throw new ConfigurationException("No class specified.");
            }
            String name = EditorSubclass.this.jsonName;
            Class<?> loadedClass = null;
            ClassLoader cl2 = this.getClass().getClassLoader();
            try {
                loadedClass = cl2.loadClass(name);
            }
            catch (ClassNotFoundException e2) {
                LOGGER.trace("Could not find class {}. Not a full class name?", (Object)name);
                LOGGER.trace("Exception loading class.", e2);
            }
            if (loadedClass == null) {
                name = EditorSubclass.this.findClassName(name);
                loadedClass = cl2.loadClass(name);
            }
            return loadedClass;
        }

        @Override
        public Object instantiate(String className, JsonElement config, Object context, Object edtCtx) throws ConfigurationException {
            try {
                Class loadedClass = this.loadClass();
                return this.instantiate(loadedClass, config, context, edtCtx);
            }
            catch (ReflectiveOperationException | SecurityException exc) {
                throw new ConfigurationException(exc);
            }
        }

        @Override
        public <T> T instantiate(Class<? extends T> clazz, JsonElement config, Object context, Object edtCtx) throws ConfigurationException {
            T newInstance;
            try {
                newInstance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException | SecurityException exc) {
                throw new ConfigurationException(exc);
            }
            if (newInstance instanceof Configurable) {
                Configurable confInstance = (Configurable)newInstance;
                confInstance.configure(EditorSubclass.this.classConfig, context, edtCtx, null);
            }
            return newInstance;
        }
    }

    public static class classItem
    implements Comparable<classItem> {
        public String className;
        public String displayName;
        public String jsonName;

        public classItem(String className) {
            this(className, className, className);
        }

        public classItem(String className, String displayName, String jsonName) {
            this.className = className;
            this.displayName = displayName;
            this.jsonName = jsonName;
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public int compareTo(classItem o2) {
            return this.displayName.compareTo(o2.displayName);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Expose {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface NoFilter {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface EdOptsSubclass {
        public Class<?> iface();

        public boolean merge() default false;

        public String nameField() default "className";

        public Class<? extends Annotation> requiredAnnotation() default NoFilter.class;

        public Class<? extends Annotation>[] allowList() default {};

        public Class<? extends Annotation>[] denyList() default {};

        public boolean restrictedClasses() default true;

        public String profilesEdit() default "";

        public boolean shortenClassNames() default false;
    }
}

