/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate.quadedge;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.math.DD;

public class TrianglePredicate {
    public static boolean isInCircleNonRobust(Coordinate a2, Coordinate b2, Coordinate c2, Coordinate p2) {
        boolean isInCircle = (a2.x * a2.x + a2.y * a2.y) * TrianglePredicate.triArea(b2, c2, p2) - (b2.x * b2.x + b2.y * b2.y) * TrianglePredicate.triArea(a2, c2, p2) + (c2.x * c2.x + c2.y * c2.y) * TrianglePredicate.triArea(a2, b2, p2) - (p2.x * p2.x + p2.y * p2.y) * TrianglePredicate.triArea(a2, b2, c2) > 0.0;
        return isInCircle;
    }

    public static boolean isInCircleNormalized(Coordinate a2, Coordinate b2, Coordinate c2, Coordinate p2) {
        double adx = a2.x - p2.x;
        double ady = a2.y - p2.y;
        double alift = adx * adx + ady * ady;
        double bdx = b2.x - p2.x;
        double cdy = c2.y - p2.y;
        double cdx = c2.x - p2.x;
        double bdy = b2.y - p2.y;
        double bcdet = bdx * cdy - cdx * bdy;
        double blift = bdx * bdx + bdy * bdy;
        double cadet = cdx * ady - adx * cdy;
        double clift = cdx * cdx + cdy * cdy;
        double abdet = adx * bdy - bdx * ady;
        double disc = alift * bcdet + blift * cadet + clift * abdet;
        return disc > 0.0;
    }

    private static double triArea(Coordinate a2, Coordinate b2, Coordinate c2) {
        return (b2.x - a2.x) * (c2.y - a2.y) - (b2.y - a2.y) * (c2.x - a2.x);
    }

    public static boolean isInCircleRobust(Coordinate a2, Coordinate b2, Coordinate c2, Coordinate p2) {
        return TrianglePredicate.isInCircleNormalized(a2, b2, c2, p2);
    }

    public static boolean isInCircleDDSlow(Coordinate a2, Coordinate b2, Coordinate c2, Coordinate p2) {
        DD px2 = DD.valueOf(p2.x);
        DD py2 = DD.valueOf(p2.y);
        DD ax2 = DD.valueOf(a2.x);
        DD ay2 = DD.valueOf(a2.y);
        DD bx2 = DD.valueOf(b2.x);
        DD by2 = DD.valueOf(b2.y);
        DD cx2 = DD.valueOf(c2.x);
        DD cy2 = DD.valueOf(c2.y);
        DD aTerm = ax2.multiply(ax2).add(ay2.multiply(ay2)).multiply(TrianglePredicate.triAreaDDSlow(bx2, by2, cx2, cy2, px2, py2));
        DD bTerm = bx2.multiply(bx2).add(by2.multiply(by2)).multiply(TrianglePredicate.triAreaDDSlow(ax2, ay2, cx2, cy2, px2, py2));
        DD cTerm = cx2.multiply(cx2).add(cy2.multiply(cy2)).multiply(TrianglePredicate.triAreaDDSlow(ax2, ay2, bx2, by2, px2, py2));
        DD pTerm = px2.multiply(px2).add(py2.multiply(py2)).multiply(TrianglePredicate.triAreaDDSlow(ax2, ay2, bx2, by2, cx2, cy2));
        DD sum = aTerm.subtract(bTerm).add(cTerm).subtract(pTerm);
        boolean isInCircle = sum.doubleValue() > 0.0;
        return isInCircle;
    }

    public static DD triAreaDDSlow(DD ax2, DD ay2, DD bx2, DD by2, DD cx2, DD cy2) {
        return bx2.subtract(ax2).multiply(cy2.subtract(ay2)).subtract(by2.subtract(ay2).multiply(cx2.subtract(ax2)));
    }

    public static boolean isInCircleDDFast(Coordinate a2, Coordinate b2, Coordinate c2, Coordinate p2) {
        DD aTerm = DD.sqr(a2.x).selfAdd(DD.sqr(a2.y)).selfMultiply(TrianglePredicate.triAreaDDFast(b2, c2, p2));
        DD bTerm = DD.sqr(b2.x).selfAdd(DD.sqr(b2.y)).selfMultiply(TrianglePredicate.triAreaDDFast(a2, c2, p2));
        DD cTerm = DD.sqr(c2.x).selfAdd(DD.sqr(c2.y)).selfMultiply(TrianglePredicate.triAreaDDFast(a2, b2, p2));
        DD pTerm = DD.sqr(p2.x).selfAdd(DD.sqr(p2.y)).selfMultiply(TrianglePredicate.triAreaDDFast(a2, b2, c2));
        DD sum = aTerm.selfSubtract(bTerm).selfAdd(cTerm).selfSubtract(pTerm);
        boolean isInCircle = sum.doubleValue() > 0.0;
        return isInCircle;
    }

    public static DD triAreaDDFast(Coordinate a2, Coordinate b2, Coordinate c2) {
        DD t1 = DD.valueOf(b2.x).selfSubtract(a2.x).selfMultiply(DD.valueOf(c2.y).selfSubtract(a2.y));
        DD t2 = DD.valueOf(b2.y).selfSubtract(a2.y).selfMultiply(DD.valueOf(c2.x).selfSubtract(a2.x));
        return t1.selfSubtract(t2);
    }

    public static boolean isInCircleDDNormalized(Coordinate a2, Coordinate b2, Coordinate c2, Coordinate p2) {
        DD adx = DD.valueOf(a2.x).selfSubtract(p2.x);
        DD ady = DD.valueOf(a2.y).selfSubtract(p2.y);
        DD bdx = DD.valueOf(b2.x).selfSubtract(p2.x);
        DD bdy = DD.valueOf(b2.y).selfSubtract(p2.y);
        DD cdx = DD.valueOf(c2.x).selfSubtract(p2.x);
        DD cdy = DD.valueOf(c2.y).selfSubtract(p2.y);
        DD abdet = adx.multiply(bdy).selfSubtract(bdx.multiply(ady));
        DD bcdet = bdx.multiply(cdy).selfSubtract(cdx.multiply(bdy));
        DD cadet = cdx.multiply(ady).selfSubtract(adx.multiply(cdy));
        DD alift = adx.multiply(adx).selfAdd(ady.multiply(ady));
        DD blift = bdx.multiply(bdx).selfAdd(bdy.multiply(bdy));
        DD clift = cdx.multiply(cdx).selfAdd(cdy.multiply(cdy));
        DD sum = alift.selfMultiply(bcdet).selfAdd(blift.selfMultiply(cadet)).selfAdd(clift.selfMultiply(abdet));
        boolean isInCircle = sum.doubleValue() > 0.0;
        return isInCircle;
    }

    public static boolean isInCircleCC(Coordinate a2, Coordinate b2, Coordinate c2, Coordinate p2) {
        Coordinate cc2 = Triangle.circumcentre(a2, b2, c2);
        double ccRadius = a2.distance(cc2);
        double pRadiusDiff = p2.distance(cc2) - ccRadius;
        return pRadiusDiff <= 0.0;
    }

    private static void checkRobustInCircle(Coordinate a2, Coordinate b2, Coordinate c2, Coordinate p2) {
        boolean nonRobustInCircle = TrianglePredicate.isInCircleNonRobust(a2, b2, c2, p2);
        boolean isInCircleDD = TrianglePredicate.isInCircleDDSlow(a2, b2, c2, p2);
        boolean isInCircleCC = TrianglePredicate.isInCircleCC(a2, b2, c2, p2);
        Coordinate circumCentre = Triangle.circumcentre(a2, b2, c2);
        System.out.println("p radius diff a = " + Math.abs(p2.distance(circumCentre) - a2.distance(circumCentre)) / a2.distance(circumCentre));
        if (nonRobustInCircle != isInCircleDD || nonRobustInCircle != isInCircleCC) {
            System.out.println("inCircle robustness failure (double result = " + nonRobustInCircle + ", DD result = " + isInCircleDD + ", CC result = " + isInCircleCC + ")");
            System.out.println(WKTWriter.toLineString(new CoordinateArraySequence(new Coordinate[]{a2, b2, c2, p2})));
            System.out.println("Circumcentre = " + WKTWriter.toPoint(circumCentre) + " radius = " + a2.distance(circumCentre));
            System.out.println("p radius diff a = " + Math.abs(p2.distance(circumCentre) / a2.distance(circumCentre) - 1.0));
            System.out.println("p radius diff b = " + Math.abs(p2.distance(circumCentre) / b2.distance(circumCentre) - 1.0));
            System.out.println("p radius diff c = " + Math.abs(p2.distance(circumCentre) / c2.distance(circumCentre) - 1.0));
            System.out.println();
        }
    }
}

