/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay.validate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import java.util.ArrayList;
import java.util.List;

public class OffsetPointGenerator {
    private Geometry g;
    private boolean doLeft = true;
    private boolean doRight = true;

    public OffsetPointGenerator(Geometry g2) {
        this.g = g2;
    }

    public void setSidesToGenerate(boolean doLeft, boolean doRight) {
        this.doLeft = doLeft;
        this.doRight = doRight;
    }

    public List getPoints(double offsetDistance) {
        ArrayList offsetPts = new ArrayList();
        List lines = LinearComponentExtracter.getLines(this.g);
        for (LineString line : lines) {
            this.extractPoints(line, offsetDistance, offsetPts);
        }
        return offsetPts;
    }

    private void extractPoints(LineString line, double offsetDistance, List offsetPts) {
        Coordinate[] pts = line.getCoordinates();
        for (int i2 = 0; i2 < pts.length - 1; ++i2) {
            this.computeOffsetPoints(pts[i2], pts[i2 + 1], offsetDistance, offsetPts);
        }
    }

    private void computeOffsetPoints(Coordinate p0, Coordinate p1, double offsetDistance, List offsetPts) {
        double dx2 = p1.x - p0.x;
        double dy2 = p1.y - p0.y;
        double len = Math.sqrt(dx2 * dx2 + dy2 * dy2);
        double ux = offsetDistance * dx2 / len;
        double uy = offsetDistance * dy2 / len;
        double midX = (p1.x + p0.x) / 2.0;
        double midY = (p1.y + p0.y) / 2.0;
        if (this.doLeft) {
            Coordinate offsetLeft = new Coordinate(midX - uy, midY + ux);
            offsetPts.add(offsetLeft);
        }
        if (this.doRight) {
            Coordinate offsetRight = new Coordinate(midX + uy, midY - ux);
            offsetPts.add(offsetRight);
        }
    }
}

