/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Location;

public class TopologyLocation {
    int[] location;

    public TopologyLocation(int[] location) {
        this.init(location.length);
    }

    public TopologyLocation(int on2, int left, int right) {
        this.init(3);
        this.location[0] = on2;
        this.location[1] = left;
        this.location[2] = right;
    }

    public TopologyLocation(int on2) {
        this.init(1);
        this.location[0] = on2;
    }

    public TopologyLocation(TopologyLocation gl2) {
        this.init(gl2.location.length);
        if (gl2 != null) {
            for (int i2 = 0; i2 < this.location.length; ++i2) {
                this.location[i2] = gl2.location[i2];
            }
        }
    }

    private void init(int size) {
        this.location = new int[size];
        this.setAllLocations(-1);
    }

    public int get(int posIndex) {
        if (posIndex < this.location.length) {
            return this.location[posIndex];
        }
        return -1;
    }

    public boolean isNull() {
        for (int i2 = 0; i2 < this.location.length; ++i2) {
            if (this.location[i2] == -1) continue;
            return false;
        }
        return true;
    }

    public boolean isAnyNull() {
        for (int i2 = 0; i2 < this.location.length; ++i2) {
            if (this.location[i2] != -1) continue;
            return true;
        }
        return false;
    }

    public boolean isEqualOnSide(TopologyLocation le2, int locIndex) {
        return this.location[locIndex] == le2.location[locIndex];
    }

    public boolean isArea() {
        return this.location.length > 1;
    }

    public boolean isLine() {
        return this.location.length == 1;
    }

    public void flip() {
        if (this.location.length <= 1) {
            return;
        }
        int temp = this.location[1];
        this.location[1] = this.location[2];
        this.location[2] = temp;
    }

    public void setAllLocations(int locValue) {
        for (int i2 = 0; i2 < this.location.length; ++i2) {
            this.location[i2] = locValue;
        }
    }

    public void setAllLocationsIfNull(int locValue) {
        for (int i2 = 0; i2 < this.location.length; ++i2) {
            if (this.location[i2] != -1) continue;
            this.location[i2] = locValue;
        }
    }

    public void setLocation(int locIndex, int locValue) {
        this.location[locIndex] = locValue;
    }

    public void setLocation(int locValue) {
        this.setLocation(0, locValue);
    }

    public int[] getLocations() {
        return this.location;
    }

    public void setLocations(int on2, int left, int right) {
        this.location[0] = on2;
        this.location[1] = left;
        this.location[2] = right;
    }

    public boolean allPositionsEqual(int loc) {
        for (int i2 = 0; i2 < this.location.length; ++i2) {
            if (this.location[i2] == loc) continue;
            return false;
        }
        return true;
    }

    public void merge(TopologyLocation gl2) {
        if (gl2.location.length > this.location.length) {
            int[] newLoc = new int[]{this.location[0], -1, -1};
            this.location = newLoc;
        }
        for (int i2 = 0; i2 < this.location.length; ++i2) {
            if (this.location[i2] != -1 || i2 >= gl2.location.length) continue;
            this.location[i2] = gl2.location[i2];
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.location.length > 1) {
            buf.append(Location.toLocationSymbol(this.location[1]));
        }
        buf.append(Location.toLocationSymbol(this.location[0]));
        if (this.location.length > 1) {
            buf.append(Location.toLocationSymbol(this.location[2]));
        }
        return buf.toString();
    }
}

