/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.algorithm.BoundaryNodeRule;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.algorithm.locate.IndexedPointInAreaLocator;
import com.vividsolutions.jts.algorithm.locate.PointOnGeometryLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.geomgraph.index.EdgeSetIntersector;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import com.vividsolutions.jts.geomgraph.index.SimpleMCSweepLineIntersector;
import com.vividsolutions.jts.util.Assert;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GeometryGraph
extends PlanarGraph {
    private Geometry parentGeom;
    private Map lineEdgeMap = new HashMap();
    private BoundaryNodeRule boundaryNodeRule = null;
    private boolean useBoundaryDeterminationRule = true;
    private int argIndex;
    private Collection boundaryNodes;
    private boolean hasTooFewPoints = false;
    private Coordinate invalidPoint = null;
    private PointOnGeometryLocator areaPtLocator = null;
    private final PointLocator ptLocator = new PointLocator();

    public static int determineBoundary(BoundaryNodeRule boundaryNodeRule, int boundaryCount) {
        return boundaryNodeRule.isInBoundary(boundaryCount) ? 1 : 0;
    }

    private EdgeSetIntersector createEdgeSetIntersector() {
        return new SimpleMCSweepLineIntersector();
    }

    public GeometryGraph(int argIndex, Geometry parentGeom) {
        this(argIndex, parentGeom, BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE);
    }

    public GeometryGraph(int argIndex, Geometry parentGeom, BoundaryNodeRule boundaryNodeRule) {
        this.argIndex = argIndex;
        this.parentGeom = parentGeom;
        this.boundaryNodeRule = boundaryNodeRule;
        if (parentGeom != null) {
            this.add(parentGeom);
        }
    }

    public boolean hasTooFewPoints() {
        return this.hasTooFewPoints;
    }

    public Coordinate getInvalidPoint() {
        return this.invalidPoint;
    }

    public Geometry getGeometry() {
        return this.parentGeom;
    }

    public BoundaryNodeRule getBoundaryNodeRule() {
        return this.boundaryNodeRule;
    }

    public Collection getBoundaryNodes() {
        if (this.boundaryNodes == null) {
            this.boundaryNodes = this.nodes.getBoundaryNodes(this.argIndex);
        }
        return this.boundaryNodes;
    }

    public Coordinate[] getBoundaryPoints() {
        Collection coll = this.getBoundaryNodes();
        Coordinate[] pts = new Coordinate[coll.size()];
        int i2 = 0;
        for (Node node : coll) {
            pts[i2++] = (Coordinate)node.getCoordinate().clone();
        }
        return pts;
    }

    public Edge findEdge(LineString line) {
        return (Edge)this.lineEdgeMap.get(line);
    }

    public void computeSplitEdges(List edgelist) {
        for (Edge e2 : this.edges) {
            e2.eiList.addSplitEdges(edgelist);
        }
    }

    private void add(Geometry g2) {
        if (g2.isEmpty()) {
            return;
        }
        if (g2 instanceof MultiPolygon) {
            this.useBoundaryDeterminationRule = false;
        }
        if (g2 instanceof Polygon) {
            this.addPolygon((Polygon)g2);
        } else if (g2 instanceof LineString) {
            this.addLineString((LineString)g2);
        } else if (g2 instanceof Point) {
            this.addPoint((Point)g2);
        } else if (g2 instanceof MultiPoint) {
            this.addCollection((MultiPoint)g2);
        } else if (g2 instanceof MultiLineString) {
            this.addCollection((MultiLineString)g2);
        } else if (g2 instanceof MultiPolygon) {
            this.addCollection((MultiPolygon)g2);
        } else if (g2 instanceof GeometryCollection) {
            this.addCollection((GeometryCollection)g2);
        } else {
            throw new UnsupportedOperationException(g2.getClass().getName());
        }
    }

    private void addCollection(GeometryCollection gc2) {
        for (int i2 = 0; i2 < gc2.getNumGeometries(); ++i2) {
            Geometry g2 = gc2.getGeometryN(i2);
            this.add(g2);
        }
    }

    private void addPoint(Point p2) {
        Coordinate coord = p2.getCoordinate();
        this.insertPoint(this.argIndex, coord, 0);
    }

    private void addPolygonRing(LinearRing lr2, int cwLeft, int cwRight) {
        if (lr2.isEmpty()) {
            return;
        }
        Coordinate[] coord = CoordinateArrays.removeRepeatedPoints(lr2.getCoordinates());
        if (coord.length < 4) {
            this.hasTooFewPoints = true;
            this.invalidPoint = coord[0];
            return;
        }
        int left = cwLeft;
        int right = cwRight;
        if (CGAlgorithms.isCCW(coord)) {
            left = cwRight;
            right = cwLeft;
        }
        Edge e2 = new Edge(coord, new Label(this.argIndex, 1, left, right));
        this.lineEdgeMap.put(lr2, e2);
        this.insertEdge(e2);
        this.insertPoint(this.argIndex, coord[0], 1);
    }

    private void addPolygon(Polygon p2) {
        this.addPolygonRing((LinearRing)p2.getExteriorRing(), 2, 0);
        for (int i2 = 0; i2 < p2.getNumInteriorRing(); ++i2) {
            LinearRing hole = (LinearRing)p2.getInteriorRingN(i2);
            this.addPolygonRing(hole, 0, 2);
        }
    }

    private void addLineString(LineString line) {
        Coordinate[] coord = CoordinateArrays.removeRepeatedPoints(line.getCoordinates());
        if (coord.length < 2) {
            this.hasTooFewPoints = true;
            this.invalidPoint = coord[0];
            return;
        }
        Edge e2 = new Edge(coord, new Label(this.argIndex, 0));
        this.lineEdgeMap.put(line, e2);
        this.insertEdge(e2);
        Assert.isTrue(coord.length >= 2, "found LineString with single point");
        this.insertBoundaryPoint(this.argIndex, coord[0]);
        this.insertBoundaryPoint(this.argIndex, coord[coord.length - 1]);
    }

    public void addEdge(Edge e2) {
        this.insertEdge(e2);
        Coordinate[] coord = e2.getCoordinates();
        this.insertPoint(this.argIndex, coord[0], 1);
        this.insertPoint(this.argIndex, coord[coord.length - 1], 1);
    }

    public void addPoint(Coordinate pt2) {
        this.insertPoint(this.argIndex, pt2, 0);
    }

    public SegmentIntersector computeSelfNodes(LineIntersector li2, boolean computeRingSelfNodes) {
        SegmentIntersector si = new SegmentIntersector(li2, true, false);
        EdgeSetIntersector esi = this.createEdgeSetIntersector();
        if (!computeRingSelfNodes && (this.parentGeom instanceof LinearRing || this.parentGeom instanceof Polygon || this.parentGeom instanceof MultiPolygon)) {
            esi.computeIntersections(this.edges, si, false);
        } else {
            esi.computeIntersections(this.edges, si, true);
        }
        this.addSelfIntersectionNodes(this.argIndex);
        return si;
    }

    public SegmentIntersector computeEdgeIntersections(GeometryGraph g2, LineIntersector li2, boolean includeProper) {
        SegmentIntersector si = new SegmentIntersector(li2, includeProper, true);
        si.setBoundaryNodes(this.getBoundaryNodes(), g2.getBoundaryNodes());
        EdgeSetIntersector esi = this.createEdgeSetIntersector();
        esi.computeIntersections(this.edges, g2.edges, si);
        return si;
    }

    private void insertPoint(int argIndex, Coordinate coord, int onLocation) {
        Node n2 = this.nodes.addNode(coord);
        Label lbl = n2.getLabel();
        if (lbl == null) {
            n2.label = new Label(argIndex, onLocation);
        } else {
            lbl.setLocation(argIndex, onLocation);
        }
    }

    private void insertBoundaryPoint(int argIndex, Coordinate coord) {
        Node n2 = this.nodes.addNode(coord);
        Label lbl = n2.getLabel();
        int boundaryCount = 1;
        int loc = -1;
        loc = lbl.getLocation(argIndex, 0);
        if (loc == 1) {
            ++boundaryCount;
        }
        int newLoc = GeometryGraph.determineBoundary(this.boundaryNodeRule, boundaryCount);
        lbl.setLocation(argIndex, newLoc);
    }

    private void addSelfIntersectionNodes(int argIndex) {
        for (Edge e2 : this.edges) {
            int eLoc = e2.getLabel().getLocation(argIndex);
            Iterator eiIt = e2.eiList.iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei2 = (EdgeIntersection)eiIt.next();
                this.addSelfIntersectionNode(argIndex, ei2.coord, eLoc);
            }
        }
    }

    private void addSelfIntersectionNode(int argIndex, Coordinate coord, int loc) {
        if (this.isBoundaryNode(argIndex, coord)) {
            return;
        }
        if (loc == 1 && this.useBoundaryDeterminationRule) {
            this.insertBoundaryPoint(argIndex, coord);
        } else {
            this.insertPoint(argIndex, coord, loc);
        }
    }

    public int locate(Coordinate pt2) {
        if (this.parentGeom instanceof Polygonal && this.parentGeom.getNumGeometries() > 50) {
            if (this.areaPtLocator == null) {
                this.areaPtLocator = new IndexedPointInAreaLocator(this.parentGeom);
            }
            return this.areaPtLocator.locate(pt2);
        }
        return this.ptLocator.locate(pt2, this.parentGeom);
    }
}

