/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.algorithm.BoundaryNodeRule;
import com.vividsolutions.jts.algorithm.locate.SimplePointInAreaLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.util.Assert;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class EdgeEndStar {
    protected Map edgeMap = new TreeMap();
    protected List edgeList;
    private int[] ptInAreaLocation = new int[]{-1, -1};

    public abstract void insert(EdgeEnd var1);

    protected void insertEdgeEnd(EdgeEnd e2, Object obj) {
        this.edgeMap.put(e2, obj);
        this.edgeList = null;
    }

    public Coordinate getCoordinate() {
        Iterator it2 = this.iterator();
        if (!it2.hasNext()) {
            return null;
        }
        EdgeEnd e2 = (EdgeEnd)it2.next();
        return e2.getCoordinate();
    }

    public int getDegree() {
        return this.edgeMap.size();
    }

    public Iterator iterator() {
        return this.getEdges().iterator();
    }

    public List getEdges() {
        if (this.edgeList == null) {
            this.edgeList = new ArrayList(this.edgeMap.values());
        }
        return this.edgeList;
    }

    public EdgeEnd getNextCW(EdgeEnd ee2) {
        this.getEdges();
        int i2 = this.edgeList.indexOf(ee2);
        int iNextCW = i2 - 1;
        if (i2 == 0) {
            iNextCW = this.edgeList.size() - 1;
        }
        return (EdgeEnd)this.edgeList.get(iNextCW);
    }

    public void computeLabelling(GeometryGraph[] geomGraph) {
        int geomi;
        Label label;
        EdgeEnd e2;
        this.computeEdgeEndLabels(geomGraph[0].getBoundaryNodeRule());
        this.propagateSideLabels(0);
        this.propagateSideLabels(1);
        boolean[] hasDimensionalCollapseEdge = new boolean[]{false, false};
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            e2 = (EdgeEnd)it2.next();
            label = e2.getLabel();
            for (geomi = 0; geomi < 2; ++geomi) {
                if (!label.isLine(geomi) || label.getLocation(geomi) != 1) continue;
                hasDimensionalCollapseEdge[geomi] = true;
            }
        }
        it2 = this.iterator();
        while (it2.hasNext()) {
            e2 = (EdgeEnd)it2.next();
            label = e2.getLabel();
            for (geomi = 0; geomi < 2; ++geomi) {
                if (!label.isAnyNull(geomi)) continue;
                int loc = -1;
                if (hasDimensionalCollapseEdge[geomi]) {
                    loc = 2;
                } else {
                    Coordinate p2 = e2.getCoordinate();
                    loc = this.getLocation(geomi, p2, geomGraph);
                }
                label.setAllLocationsIfNull(geomi, loc);
            }
        }
    }

    private void computeEdgeEndLabels(BoundaryNodeRule boundaryNodeRule) {
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            EdgeEnd ee2 = (EdgeEnd)it2.next();
            ee2.computeLabel(boundaryNodeRule);
        }
    }

    private int getLocation(int geomIndex, Coordinate p2, GeometryGraph[] geom) {
        if (this.ptInAreaLocation[geomIndex] == -1) {
            this.ptInAreaLocation[geomIndex] = SimplePointInAreaLocator.locate(p2, geom[geomIndex].getGeometry());
        }
        return this.ptInAreaLocation[geomIndex];
    }

    public boolean isAreaLabelsConsistent(GeometryGraph geomGraph) {
        this.computeEdgeEndLabels(geomGraph.getBoundaryNodeRule());
        return this.checkAreaLabelsConsistent(0);
    }

    private boolean checkAreaLabelsConsistent(int geomIndex) {
        List edges = this.getEdges();
        if (edges.size() <= 0) {
            return true;
        }
        int lastEdgeIndex = edges.size() - 1;
        Label startLabel = ((EdgeEnd)edges.get(lastEdgeIndex)).getLabel();
        int startLoc = startLabel.getLocation(geomIndex, 1);
        Assert.isTrue(startLoc != -1, "Found unlabelled area edge");
        int currLoc = startLoc;
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            EdgeEnd e2 = (EdgeEnd)it2.next();
            Label label = e2.getLabel();
            Assert.isTrue(label.isArea(geomIndex), "Found non-area edge");
            int leftLoc = label.getLocation(geomIndex, 1);
            int rightLoc = label.getLocation(geomIndex, 2);
            if (leftLoc == rightLoc) {
                return false;
            }
            if (rightLoc != currLoc) {
                return false;
            }
            currLoc = leftLoc;
        }
        return true;
    }

    void propagateSideLabels(int geomIndex) {
        int startLoc = -1;
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            EdgeEnd e2 = (EdgeEnd)it2.next();
            Label label = e2.getLabel();
            if (!label.isArea(geomIndex) || label.getLocation(geomIndex, 1) == -1) continue;
            startLoc = label.getLocation(geomIndex, 1);
        }
        if (startLoc == -1) {
            return;
        }
        int currLoc = startLoc;
        Iterator it3 = this.iterator();
        while (it3.hasNext()) {
            EdgeEnd e3 = (EdgeEnd)it3.next();
            Label label = e3.getLabel();
            if (label.getLocation(geomIndex, 0) == -1) {
                label.setLocation(geomIndex, 0, currLoc);
            }
            if (!label.isArea(geomIndex)) continue;
            int leftLoc = label.getLocation(geomIndex, 1);
            int rightLoc = label.getLocation(geomIndex, 2);
            if (rightLoc != -1) {
                if (rightLoc != currLoc) {
                    throw new TopologyException("side location conflict", e3.getCoordinate());
                }
                if (leftLoc == -1) {
                    Assert.shouldNeverReachHere("found single null side (at " + e3.getCoordinate() + ")");
                }
                currLoc = leftLoc;
                continue;
            }
            Assert.isTrue(label.getLocation(geomIndex, 1) == -1, "found single null side");
            label.setLocation(geomIndex, 2, currLoc);
            label.setLocation(geomIndex, 1, currLoc);
        }
    }

    public int findIndex(EdgeEnd eSearch) {
        this.iterator();
        for (int i2 = 0; i2 < this.edgeList.size(); ++i2) {
            EdgeEnd e2 = (EdgeEnd)this.edgeList.get(i2);
            if (e2 != eSearch) continue;
            return i2;
        }
        return -1;
    }

    public void print(PrintStream out) {
        System.out.println("EdgeEndStar:   " + this.getCoordinate());
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            EdgeEnd e2 = (EdgeEnd)it2.next();
            e2.print(out);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("EdgeEndStar:   " + this.getCoordinate());
        buf.append("\n");
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            EdgeEnd e2 = (EdgeEnd)it2.next();
            buf.append(e2);
            buf.append("\n");
        }
        return buf.toString();
    }
}

