/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geomgraph.Depth;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.EdgeIntersectionList;
import com.vividsolutions.jts.geomgraph.GraphComponent;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.index.MonotoneChainEdge;
import java.io.PrintStream;

public class Edge
extends GraphComponent {
    Coordinate[] pts;
    private Envelope env;
    EdgeIntersectionList eiList = new EdgeIntersectionList(this);
    private String name;
    private MonotoneChainEdge mce;
    private boolean isIsolated = true;
    private Depth depth = new Depth();
    private int depthDelta = 0;

    public static void updateIM(Label label, IntersectionMatrix im2) {
        im2.setAtLeastIfValid(label.getLocation(0, 0), label.getLocation(1, 0), 1);
        if (label.isArea()) {
            im2.setAtLeastIfValid(label.getLocation(0, 1), label.getLocation(1, 1), 2);
            im2.setAtLeastIfValid(label.getLocation(0, 2), label.getLocation(1, 2), 2);
        }
    }

    public Edge(Coordinate[] pts, Label label) {
        this.pts = pts;
        this.label = label;
    }

    public Edge(Coordinate[] pts) {
        this(pts, null);
    }

    public int getNumPoints() {
        return this.pts.length;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public Coordinate getCoordinate(int i2) {
        return this.pts[i2];
    }

    public Coordinate getCoordinate() {
        if (this.pts.length > 0) {
            return this.pts[0];
        }
        return null;
    }

    public Envelope getEnvelope() {
        if (this.env == null) {
            this.env = new Envelope();
            for (int i2 = 0; i2 < this.pts.length; ++i2) {
                this.env.expandToInclude(this.pts[i2]);
            }
        }
        return this.env;
    }

    public Depth getDepth() {
        return this.depth;
    }

    public int getDepthDelta() {
        return this.depthDelta;
    }

    public void setDepthDelta(int depthDelta) {
        this.depthDelta = depthDelta;
    }

    public int getMaximumSegmentIndex() {
        return this.pts.length - 1;
    }

    public EdgeIntersectionList getEdgeIntersectionList() {
        return this.eiList;
    }

    public MonotoneChainEdge getMonotoneChainEdge() {
        if (this.mce == null) {
            this.mce = new MonotoneChainEdge(this);
        }
        return this.mce;
    }

    public boolean isClosed() {
        return this.pts[0].equals(this.pts[this.pts.length - 1]);
    }

    public boolean isCollapsed() {
        if (!this.label.isArea()) {
            return false;
        }
        if (this.pts.length != 3) {
            return false;
        }
        return this.pts[0].equals(this.pts[2]);
    }

    public Edge getCollapsedEdge() {
        Coordinate[] newPts = new Coordinate[]{this.pts[0], this.pts[1]};
        Edge newe = new Edge(newPts, Label.toLineLabel(this.label));
        return newe;
    }

    public void setIsolated(boolean isIsolated) {
        this.isIsolated = isIsolated;
    }

    public boolean isIsolated() {
        return this.isIsolated;
    }

    public void addIntersections(LineIntersector li2, int segmentIndex, int geomIndex) {
        for (int i2 = 0; i2 < li2.getIntersectionNum(); ++i2) {
            this.addIntersection(li2, segmentIndex, geomIndex, i2);
        }
    }

    public void addIntersection(LineIntersector li2, int segmentIndex, int geomIndex, int intIndex) {
        Coordinate nextPt;
        Coordinate intPt = new Coordinate(li2.getIntersection(intIndex));
        int normalizedSegmentIndex = segmentIndex;
        double dist = li2.getEdgeDistance(geomIndex, intIndex);
        int nextSegIndex = normalizedSegmentIndex + 1;
        if (nextSegIndex < this.pts.length && intPt.equals2D(nextPt = this.pts[nextSegIndex])) {
            normalizedSegmentIndex = nextSegIndex;
            dist = 0.0;
        }
        EdgeIntersection ei2 = this.eiList.add(intPt, normalizedSegmentIndex, dist);
    }

    public void computeIM(IntersectionMatrix im2) {
        Edge.updateIM(this.label, im2);
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof Edge)) {
            return false;
        }
        Edge e2 = (Edge)o2;
        if (this.pts.length != e2.pts.length) {
            return false;
        }
        boolean isEqualForward = true;
        boolean isEqualReverse = true;
        int iRev = this.pts.length;
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            if (!this.pts[i2].equals2D(e2.pts[i2])) {
                isEqualForward = false;
            }
            if (!this.pts[i2].equals2D(e2.pts[--iRev])) {
                isEqualReverse = false;
            }
            if (isEqualForward || isEqualReverse) continue;
            return false;
        }
        return true;
    }

    public boolean isPointwiseEqual(Edge e2) {
        if (this.pts.length != e2.pts.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            if (this.pts[i2].equals2D(e2.pts[i2])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("edge " + this.name + ": ");
        buf.append("LINESTRING (");
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            if (i2 > 0) {
                buf.append(",");
            }
            buf.append(this.pts[i2].x + " " + this.pts[i2].y);
        }
        buf.append(")  " + this.label + " " + this.depthDelta);
        return buf.toString();
    }

    public void print(PrintStream out) {
        out.print("edge " + this.name + ": ");
        out.print("LINESTRING (");
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            if (i2 > 0) {
                out.print(",");
            }
            out.print(this.pts[i2].x + " " + this.pts[i2].y);
        }
        out.print(")  " + this.label + " " + this.depthDelta);
    }

    public void printReverse(PrintStream out) {
        out.print("edge " + this.name + ": ");
        for (int i2 = this.pts.length - 1; i2 >= 0; --i2) {
            out.print(this.pts[i2] + " ");
        }
        out.println("");
    }
}

